package com.dtyunxi.yundt.cube.center.item.api.dto;


import cn.afterturn.easypoi.excel.annotation.Excel;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 商品开票信息对象ItemInvoiceDto
 *
 * @author yiyun
 * @since 2021-10-07
 */
public class ItemInvoiceExportDto extends RequestDto {
    /*
     * 商品编码
     * */
    @ApiModelProperty(value = "itemCode",name = "商品编码")
    @Excel(name = "商品编码",orderNum = "0")
    private String itemCode;
    /*
     * 商品名称
     * */
    @ApiModelProperty(value = "ItemName",name = "商品名称")
    @Excel(name = "商品名称",orderNum = "1")
    private String ItemName;
    /*
     * 商品简称
     * */
    @ApiModelProperty(value = "ItemDisplayName",name = "商品简称")
    @Excel(name = "商品简称",orderNum = "2")
    private String ItemDisplayName;
    /*
     * 税收分类编码
     * */
    @ApiModelProperty(value = "taxCategoryCode",name = "税收分类编码")
    @Excel(name = "税收分类编码",orderNum = "3")
    private String taxCategoryCode;
    /*
     * 税率
     * */
    @ApiModelProperty(value = "taxRate",name = "税率")
    @Excel(name = "税率",suffix = "%",orderNum = "4")
    private BigDecimal taxRate;
    /*
     * 专利名称
     * */
    @ApiModelProperty(value = "patentName",name = "专利名称")
    @Excel(name = "专利名称",orderNum = "5")
    private String patentName;
    /*
     * 更新时间
     * */
    @ApiModelProperty(value = "updateTime",name = "更新时间")
    @Excel(name = "更新时间",orderNum = "6",exportFormat="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;


    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getItemDisplayName() {
        return ItemDisplayName;
    }

    public void setItemDisplayName(String itemDisplayName) {
        ItemDisplayName = itemDisplayName;
    }

    public String getPatentName() {
        return patentName;
    }

    public void setPatentName(String patentName) {
        this.patentName = patentName;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getTaxCategoryCode() {
        return taxCategoryCode;
    }

    public void setTaxCategoryCode(String taxCategoryCode) {
        this.taxCategoryCode = taxCategoryCode;
    }

    public String getItemName() {
        return ItemName;
    }

    public void setItemName(String itemName) {
        ItemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }
}
