/*
 * @(#)EmpowerQueryReqDto.java 1.0 2021年10月14日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * <p>Title:EmpowerQueryReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/10/14 11:01
 * @since 0.1.0
 */
@ApiModel(value = "EmpowerQueryReqDto", description = "EmpowerQueryReqDto")
public class EmpowerQueryReqDto implements Serializable {

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    @ApiModelProperty(name = "dirId", value = "后台类目")
    private Long dirId;
    @ApiModelProperty(name = "customerId", value = "客户ID")
    private Long customerId;
    @ApiModelProperty(
            name = "pageNum",
            value = "当前页"
    )
    private Integer pageNum;
    @ApiModelProperty(
            name = "pageSize",
            value = "每页数"
    )
    private Integer pageSize;
    @ApiModelProperty(name = "prodLargeClass", value = "产品大类(北鼎一级品类描述)")
    private String prodLargeClass;
    @ApiModelProperty(name = "prodLargeCode", value = "产品大类编码(北鼎一级品类)")
    private String prodLargeCode;
    @ApiModelProperty(name = "prodSecClassify", value = "产品二级分类(北鼎二级品类描述)")
    private String prodSecClassify;
    @ApiModelProperty(name = "prodSecCode", value = "产品二级分类编码(北鼎二级品类)")
    private String prodSecCode;
    @ApiModelProperty(name = "prodThrClassify", value = "产品三级分类(北鼎三级品类描述)")
    private String prodThrClassify;
    @ApiModelProperty(name = "prodThrCode", value = "产品三级分类编码(北鼎三级品类)")
    private String prodThrCode;
    @ApiModelProperty(name = "prodClassCode", value = "产品型号")
    private String prodClassCode;
    @ApiModelProperty(name = "prodClassName", value = "产品名称")
    private String prodClassName;
    @ApiModelProperty(name = "customerIds", value = "客户Id集合")
    private List<Long> customerIds;
    @ApiModelProperty(name = "itemIds", value = "商品Id集合")
    private List<Long> itemIds;

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getProdLargeClass() {
        return prodLargeClass;
    }

    public void setProdLargeClass(String prodLargeClass) {
        this.prodLargeClass = prodLargeClass;
    }

    public String getProdLargeCode() {
        return prodLargeCode;
    }

    public void setProdLargeCode(String prodLargeCode) {
        this.prodLargeCode = prodLargeCode;
    }

    public String getProdSecClassify() {
        return prodSecClassify;
    }

    public void setProdSecClassify(String prodSecClassify) {
        this.prodSecClassify = prodSecClassify;
    }

    public String getProdSecCode() {
        return prodSecCode;
    }

    public void setProdSecCode(String prodSecCode) {
        this.prodSecCode = prodSecCode;
    }

    public String getProdThrClassify() {
        return prodThrClassify;
    }

    public void setProdThrClassify(String prodThrClassify) {
        this.prodThrClassify = prodThrClassify;
    }

    public String getProdThrCode() {
        return prodThrCode;
    }

    public void setProdThrCode(String prodThrCode) {
        this.prodThrCode = prodThrCode;
    }

    public String getProdClassCode() {
        return prodClassCode;
    }

    public void setProdClassCode(String prodClassCode) {
        this.prodClassCode = prodClassCode;
    }

    public String getProdClassName() {
        return prodClassName;
    }

    public void setProdClassName(String prodClassName) {
        this.prodClassName = prodClassName;
    }

    public List<Long> getCustomerIds() {
        return customerIds;
    }

    public void setCustomerIds(List<Long> customerIds) {
        this.customerIds = customerIds;
    }

    public List<Long> getItemIds() {
        return itemIds;
    }

    public void setItemIds(List<Long> itemIds) {
        this.itemIds = itemIds;
    }
}
