/*
 * @(#)ItemListInfoRespDto.java 1.0 2021年09月12日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * <p>Title:ItemListInfoRespDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/12 16:02
 * @since 0.1.0
 */
@ApiModel(value = "ItemListInfoRespDto", description = "商品信息Dto对象")
public class ItemListInfoRespDto implements Serializable {

    @ApiModelProperty(name = "itemId",value = "商品ID")
    private Long itemId;

    @ApiModelProperty(name = "itemCode",value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "itemName",value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "imgPath",value = "商品主图")
    private String imgPath;

    @ApiModelProperty(name = "skuCode",value = "skuCode")
    private String skuCode;

    @ApiModelProperty(name = "channelSkuCode",value = "渠道sku编码")
    private String channelSkuCode;

    @ApiModelProperty(name = "unit",value = "商品单位")
    private String unit;

    @ApiModelProperty(name = "num",value = "组合基数")
    private Integer num;

    @ApiModelProperty(name = "type",value = "1-商品,3组合商品,4虚拟商品，5赠品商品")
    private Integer type;

    @ApiModelProperty(name = "dirId",value = "后台类目ID")
    private Long dirId;

    @ApiModelProperty(name = "dirName",value = "后台类目名称")
    private String dirName;

    @ApiModelProperty(name = "weightUnit",value = "商品单位")
    private String weightUnit;

    @ApiModelProperty(name = "composeItemId",value = "组合商品ID")
    private Long composeItemId;

    @ApiModelProperty(name = "composeItemCode",value = "组合商品编码")
    private String composeItemCode;

    @ApiModelProperty(name = "composeItemName",value = "组合商品名称")
    private String composeItemName;

    @ApiModelProperty(name = "prodLargeClass",value = "产品大类")
    private String prodLargeClass;
    @ApiModelProperty(name = "prodLargeCode",value = "产品大类编码(北鼎一级品类)")
    private String prodLargeCode;
    @ApiModelProperty(name = "prodSecClassify",value = "产品二级分类")
    private String prodSecClassify;
    @ApiModelProperty(name = "prodSecCode",value = "产品二级分类编码(北鼎二级品类)")
    private String prodSecCode;
    @ApiModelProperty(name = "prodThrClassify",value = "产品三级分类(北鼎三级品类描述)")
    private String prodThrClassify;
    @ApiModelProperty(name = "prodThrCode",value = "产品三级分类编码(北鼎三级品类)")
    private String prodThrCode;
    @ApiModelProperty(name = "prodClassCode",value = "产品型号")
    private String prodClassCode;
    @ApiModelProperty(name = "prodClassName",value = "产品名称")
    private String prodClassName;
    @ApiModelProperty(name = "virtualType",value = "BD50:玻璃险虚拟商品 BD51:无物料商品 BD52:等蜂来 BD53:分快递费虚拟商品/借贷项等其他虚拟商品")
    private String virtualType;
    @ApiModelProperty(name = "specsUnit",value = "规格单位")
    private String specsUnit;
    @ApiModelProperty(name = "grossWeight",value = "毛重")
    private String grossWeight;
    @ApiModelProperty(name = "grossWeightUnit",value = "毛重单位")
    private String grossWeightUnit;
    @ApiModelProperty(name = "netWeight",value = "净重")
    private String netWeight;
    @ApiModelProperty(name = "netWeightUnit",value = "净重单位")
    private String netWeightUnit;
    @ApiModelProperty(name = "skuSerial",value = "skuId")
    private String skuSerial;
    @ApiModelProperty(name = "vitrual",value = "虚拟商品")
    private Boolean vitrual;


    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public String getComposeItemCode() {
        return composeItemCode;
    }

    public void setComposeItemCode(String composeItemCode) {
        this.composeItemCode = composeItemCode;
    }

    public String getComposeItemName() {
        return composeItemName;
    }

    public void setComposeItemName(String composeItemName) {
        this.composeItemName = composeItemName;
    }

    public String getWeightUnit() {
        return weightUnit;
    }

    public void setWeightUnit(String weightUnit) {
        this.weightUnit = weightUnit;
    }


    public Long getComposeItemId() {
        return composeItemId;
    }

    public void setComposeItemId(Long composeItemId) {
        this.composeItemId = composeItemId;
    }

    public String getChannelSkuCode() {
        return channelSkuCode;
    }

    public void setChannelSkuCode(String channelSkuCode) {
        this.channelSkuCode = channelSkuCode;
    }

    public String getProdLargeClass() {
        return prodLargeClass;
    }

    public void setProdLargeClass(String prodLargeClass) {
        this.prodLargeClass = prodLargeClass;
    }

    public String getProdLargeCode() {
        return prodLargeCode;
    }

    public void setProdLargeCode(String prodLargeCode) {
        this.prodLargeCode = prodLargeCode;
    }

    public String getProdSecClassify() {
        return prodSecClassify;
    }

    public void setProdSecClassify(String prodSecClassify) {
        this.prodSecClassify = prodSecClassify;
    }

    public String getProdSecCode() {
        return prodSecCode;
    }

    public void setProdSecCode(String prodSecCode) {
        this.prodSecCode = prodSecCode;
    }

    public String getProdThrClassify() {
        return prodThrClassify;
    }

    public void setProdThrClassify(String prodThrClassify) {
        this.prodThrClassify = prodThrClassify;
    }

    public String getProdThrCode() {
        return prodThrCode;
    }

    public void setProdThrCode(String prodThrCode) {
        this.prodThrCode = prodThrCode;
    }

    public String getProdClassCode() {
        return prodClassCode;
    }

    public void setProdClassCode(String prodClassCode) {
        this.prodClassCode = prodClassCode;
    }

    public String getProdClassName() {
        return prodClassName;
    }

    public void setProdClassName(String prodClassName) {
        this.prodClassName = prodClassName;
    }

    public String getVirtualType() {
        return virtualType;
    }

    public void setVirtualType(String virtualType) {
        this.virtualType = virtualType;
    }

    public String getImgPath() {
        return imgPath;
    }

    public void setImgPath(String imgPath) {
        this.imgPath = imgPath;
    }

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public String getSpecsUnit() {
        return specsUnit;
    }

    public void setSpecsUnit(String specsUnit) {
        this.specsUnit = specsUnit;
    }

    public String getGrossWeight() {
        return grossWeight;
    }

    public void setGrossWeight(String grossWeight) {
        this.grossWeight = grossWeight;
    }

    public String getGrossWeightUnit() {
        return grossWeightUnit;
    }

    public void setGrossWeightUnit(String grossWeightUnit) {
        this.grossWeightUnit = grossWeightUnit;
    }

    public String getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(String netWeight) {
        this.netWeight = netWeight;
    }

    public String getNetWeightUnit() {
        return netWeightUnit;
    }

    public void setNetWeightUnit(String netWeightUnit) {
        this.netWeightUnit = netWeightUnit;
    }

    public String getSkuSerial() {
        return skuSerial;
    }

    public void setSkuSerial(String skuSerial) {
        this.skuSerial = skuSerial;
    }

    public Boolean getVitrual() {
        return vitrual;
    }

    public void setVitrual(Boolean vitrual) {
        this.vitrual = vitrual;
    }
}
