package com.dtyunxi.yundt.cube.center.item.api.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author jack
 * @version 1.0
 * @date 27/08/2022 09:05
 **/
public class UnitFormatUtils {

    private static final UnitFormatService ceilingFormatService = (val, origLarge, targetLager) -> Optional.ofNullable(val).orElse(BigDecimal.ZERO).multiply(BigDecimal.valueOf(origLarge)).divide(BigDecimal.valueOf(targetLager), 8, RoundingMode.CEILING);
    private static final UnitFormatService evenFormatService = (val, origLarge, targetLager) -> Optional.ofNullable(val).orElse(BigDecimal.ZERO).multiply(BigDecimal.valueOf(origLarge)).divide(BigDecimal.valueOf(targetLager), 0, RoundingMode.HALF_EVEN);

    public static BigDecimal formatVolume(BigDecimal val, String origUnit, String targetUnit){
        VolumeEnum volumeEnum = VolumeEnum.forCode(origUnit);
        VolumeEnum targetEnum = VolumeEnum.forCode(targetUnit);
        if (volumeEnum==null || targetEnum==null){
            return BigDecimal.ZERO;
        }
        return ceilingFormatService.format(val, volumeEnum.getLargeNum(), targetEnum.largeNum);
    }

    public static Long formatDate(Long val, String origUnit, String targetUnit){
        DateEnum volumeEnum = DateEnum.forCode(origUnit);
        DateEnum targetEnum = DateEnum.forCode(targetUnit);
        if (volumeEnum==null || targetEnum==null){
            return 0L;
        }
        return evenFormatService.format(new BigDecimal(val), volumeEnum.getLargeNum(), targetEnum.largeNum).longValue();
    }




    public enum DateEnum{
        /**
         * 体积
         */
        DAY("日", 1L),
        MONTH("月", 30L),
        YEAR("年", 365L),
        ;

        /**
         * 单位名称
         */
        private final String name;

        /**
         * 单位系数
         */
        private final Long largeNum;

        DateEnum(String name, Long largeNum) {
            this.name = name;
            this.largeNum = largeNum;
        }

        public static final Map<String, DateEnum> CODE_LOOKUP = Arrays.stream(values()).collect(Collectors.toMap(DateEnum::getName, thisEnum -> thisEnum));

        public String getName() {
            return name;
        }

        public Long getLargeNum() {
            return largeNum;
        }

        public static DateEnum forCode(String code) {
            return CODE_LOOKUP.get(code);
        }


    }



    public enum VolumeEnum{
        /**
         * 体积
         */
        CM("立方厘米", 1L),
        MM("立方分米", 1000L),
        M("立方米", 1000000L),
        ;

        /**
         * 单位名称
         */
        private final String name;

        /**
         * 单位系数
         */
        private final Long largeNum;

        VolumeEnum(String name, Long largeNum) {
            this.name = name;
            this.largeNum = largeNum;
        }

        public static final Map<String, VolumeEnum> CODE_LOOKUP = Arrays.stream(values()).collect(Collectors.toMap(VolumeEnum::getName, thisEnum -> thisEnum));

        public String getName() {
            return name;
        }

        public Long getLargeNum() {
            return largeNum;
        }

        public static VolumeEnum forCode(String code) {
            return CODE_LOOKUP.get(code);
        }


    }


    @FunctionalInterface
    public interface UnitFormatService{

        /**
         * 转换
         * @param val 当前值
         * @param origLarge 原值系数
         * @param targetLager 目标系数
         * @return 转换值
         */
        BigDecimal format(BigDecimal val, Long origLarge, Long targetLager);

    }
}
