/*
 * @(#)ItemSkuRespDto.java 1.0 2018-09-03
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * sku信息
 * @author  惜笔 | 林五弟
 * @date  2021/11/18 17:35
 * @version 1.0.0
 */
@ApiModel(value = "ItemSkuQueryRespDto", description = "ItemSkuQueryRespDto")
public class ItemSkuQueryRespDto extends BaseVo {

    @ApiModelProperty(name = "shopId", value = "所属店铺id，大B专有字段")
    private Long shopId;

    @ApiModelProperty(name = "itemOrgId", value = "商品所属组织id")
    private Long itemOrgId;

    @ApiModelProperty(name = "itemOrgName", value = "商品所属组织名字")
    private String itemOrgName;

    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "itemPic", value = "商品主图")
    private String itemPic;

    @ApiModelProperty(name = "itemName", value = "商品名字")
    private String itemName;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "brandId", value = "品牌id")
    private Long brandId;

    @ApiModelProperty(name = "brandName", value = "品牌名字")
    private String brandName;

    @ApiModelProperty(name = "dirId", value = "商品类目")
    private Long dirId;

    @ApiModelProperty(name = "dirName", value = "商品类目名字")
    private String dirName;

    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "giftBox", value = "商品礼盒，0-是，1-否")
    private Integer giftBox;

    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;

    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;

    @ApiModelProperty(name = "skuAttr", value = "sku规格值json")
    private String skuAttr;

    @ApiModelProperty(name = "unitId", value = "单位id")
    private Long unitId;

    @ApiModelProperty(name = "unitName", value = "单位名称")
    private String unitName;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    private List<Long> brandIds;

    public List<Long> getBrandIds() {
        return brandIds;
    }

    public void setBrandIds(List<Long> brandIds) {
        this.brandIds = brandIds;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public Long getItemOrgId() {
        return itemOrgId;
    }

    public void setItemOrgId(Long itemOrgId) {
        this.itemOrgId = itemOrgId;
    }

    public String getItemOrgName() {
        return itemOrgName;
    }

    public void setItemOrgName(String itemOrgName) {
        this.itemOrgName = itemOrgName;
    }

    public String getItemPic() {
        return itemPic;
    }

    public void setItemPic(String itemPic) {
        this.itemPic = itemPic;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public Integer getGiftBox() {
        return giftBox;
    }

    public void setGiftBox(Integer giftBox) {
        this.giftBox = giftBox;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuAttr() {
        return skuAttr;
    }

    public void setSkuAttr(String skuAttr) {
        this.skuAttr = skuAttr;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }
}
