/*
 * @(#)InventoryException.java 1.0 2018-08-28
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

/**
 * 经营屏蔽 保存 dto
 * Created by sumo on 2020/11/6 0006
 *
 * @author sumo
 */
@ApiModel(value = "ManagementBlockSaveReqDto", description = "经营屏蔽 保存,支持批量保存")
public class ManagementBlockSaveReqDto {


    @ApiModelProperty(name = "skuIdIds", value = "批量保存skuIdIds")
    private List<Long> skuIds =new ArrayList<>();

    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;

    @ApiModelProperty(name = "isAllArea", value = "是否全部区域归属(1:全部 0:部分)",required = true)
    @NotNull(message = "是否全部归属区域不能为空")
    @Range(min = 0, max = 1, message = "是否全部归属区域范围为0至1")
    private Integer isAllArea;

    @ApiModelProperty(name = "isAllCustomer", value = "是否全部客户类型(1:全部 0:部分)",required = true)
    @NotNull(message = "是否全部客户类型不能为空")
    @Range(min = 0, max = 1, message = "是否全部客户类型范围为0至1")
    private Integer isAllCustomer;

    @ApiModelProperty(name = "customerTypeIds", value = "客户类型IDS")
    private List<Long> customerTypeIds;

    @ApiModelProperty(name = "areaGroupIds", value = "区域分组IDS")
    private List<String> areaCodes;

    @ApiModelProperty(name = "customerIds", value = "客户IDS")
    private List<Long> customerIds;

    public List<Long> getSkuIds() {
        return skuIds;
    }

    public void setSkuIds(List<Long> skuIds) {
        this.skuIds = skuIds;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Integer getIsAllArea() {
        return isAllArea;
    }

    public void setIsAllArea(Integer isAllArea) {
        this.isAllArea = isAllArea;
    }

    public Integer getIsAllCustomer() {
        return isAllCustomer;
    }

    public void setIsAllCustomer(Integer isAllCustomer) {
        this.isAllCustomer = isAllCustomer;
    }

    public List<Long> getCustomerTypeIds() {
        return customerTypeIds;
    }

    public void setCustomerTypeIds(List<Long> customerTypeIds) {
        this.customerTypeIds = customerTypeIds;
    }

    public List<String> getAreaCodes() {
        return areaCodes;
    }

    public void setAreaCodes(List<String> areaCodes) {
        this.areaCodes = areaCodes;
    }

    public List<Long> getCustomerIds() {
        return customerIds;
    }

    public void setCustomerIds(List<Long> customerIds) {

        this.customerIds = customerIds;
    }
}