/**
 * @(#) ItemDirQueryRespDto.java 1.0 2018-12-27
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 商品目录关系响应Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ItemDirQueryRespDto", description = "商品目录关系响应Dto")
public class DirItemRelativeQueryRespDto extends BaseRespDto {

    @ApiModelProperty(name = "itemId", value = "商品id，必填")
    private Long itemId;

    @ApiModelProperty(name = "skuId", value = "规格Id，选填，填写时只下架该规格")
    private Long skuId;


    @ApiModelProperty(name = "shopId", value = "店铺id，必填")
    private Long shopId;
    /**
     * 类目类型
     */
    @ApiModelProperty(name = "dirType", value = "类目类型")
    private String dirType;
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;

    /**
     * 目录id
     */
    @ApiModelProperty(name = "dirId", value = "类目id")
    private Long dirId;

    @ApiModelProperty(name = "dirName", value = "类目名称")
    private String dirName;

    @ApiModelProperty(name = "sellerId", value = "商家id")
    private Long sellerId;

    @ApiModelProperty(name = "busType", value = "业务类型")
    private Integer busType;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDirType() {
        return dirType;
    }

    public void setDirType(String dirType) {
        this.dirType = dirType;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }
}
