/**
 * @(#)PropGroupRestDto 1.0 2018-12-3
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 属性组响应dto
 *
 * @author 双清
 */
@ApiModel(value = "PropGroupRespDto", description = "属性组响应dto")
public class PropGroupRespDto extends BaseRespDto {
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;

    @ApiModelProperty(name = "code", value = "分组编码")
    private String code;

    @ApiModelProperty(name = "name", value = "分组名称")
    private String name;

    @ApiModelProperty(name = "description", value = "描述")
    private String description;

    @ApiModelProperty(name = "tenantId", value = "租户id")
    private Long tenantId;

    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    @ApiModelProperty(name = "propNameReqDto", value = "属性名实体")
    private List<PropNameRespDto> propNameRespDtos;

    @ApiModelProperty(name = "dirPropDtoList", value = "目录列表")
    private List<DirPropDto> dirPropDtoList;

    @ApiModelProperty(name = "propGroupUsageType", value = "属性组在类目下的用用途类型: 0 基础属性 1 销售属性")
    private Integer propGroupUsageType;

    public Integer getPropGroupUsageType() {
        return propGroupUsageType;
    }

    public void setPropGroupUsageType(Integer propGroupUsageType) {
        this.propGroupUsageType = propGroupUsageType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public List<PropNameRespDto> getPropNameRespDtos() {
        return propNameRespDtos;
    }

    public void setPropNameRespDtos(List<PropNameRespDto> propNameRespDtos) {
        this.propNameRespDtos = propNameRespDtos;
    }

    public List<DirPropDto> getDirPropDtoList() {
        return dirPropDtoList;
    }

    public void setDirPropDtoList(List<DirPropDto> dirPropDtoList) {
        this.dirPropDtoList = dirPropDtoList;
    }
}