package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
* 商品转换关系记录表Eo对象
*
* @author author
* @since 2022-09-02
*/
@ApiModel(value = "ItemUnitConversionRecordReqDto", description = "商品转换关系记录表Eo对象")
public class ItemUnitConversionRecordReqDto extends RequestDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  单据编码
    */
    @ApiModelProperty(name = "documentCode", value = "单据编码")
    private String documentCode;
    /**
    *  商品编码
    */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    /**
    *  批次
    */
    @ApiModelProperty(name = "itemBatch", value = "批次")
    private String itemBatch;
    /**
    *  商品数量
    */
    @ApiModelProperty(name = "itemNum", value = "商品数量")
    private Integer itemNum;
    /**
    *  商品单位
    */
    @ApiModelProperty(name = "itemUnit", value = "商品单位")
    private String itemUnit;
    /**
    *  本方换算数量
    */
    @ApiModelProperty(name = "conversionNum", value = "本方换算数量")
    private Integer conversionNum;
    /**
    *  本方换算单位
    */
    @ApiModelProperty(name = "conversionUnit", value = "本方换算单位")
    private String conversionUnit;
    /**
    *  本方基本单位数量
    */
    @ApiModelProperty(name = "baseUnitNum", value = "本方基本单位数量")
    private Integer baseUnitNum;
    /**
    *  他方换算数量
    */
    @ApiModelProperty(name = "toConversionNum", value = "他方换算数量")
    private Integer toConversionNum;
    /**
    *  他方换算单位
    */
    @ApiModelProperty(name = "toConversionUnit", value = "他方换算单位")
    private String toConversionUnit;
    /**
    *  他方基本单位数量
    */
    @ApiModelProperty(name = "toBaseUnitNum", value = "他方基本单位数量")
    private Integer toBaseUnitNum;
    /**
    *  他方商品数量
    */
    @ApiModelProperty(name = "toItemNum", value = "他方商品数量")
    private Integer toItemNum;
    /**
    *  他方商品单位
    */
    @ApiModelProperty(name = "toItemUnit", value = "他方商品单位")
    private String toItemUnit;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setDocumentCode(String documentCode){
    this.documentCode = documentCode;
    }
    public String getDocumentCode(){
    return this.documentCode;
    }
    public void setItemCode(String itemCode){
    this.itemCode = itemCode;
    }
    public String getItemCode(){
    return this.itemCode;
    }
    public void setItemBatch(String itemBatch){
    this.itemBatch = itemBatch;
    }
    public String getItemBatch(){
    return this.itemBatch;
    }
    public void setItemNum(Integer itemNum){
    this.itemNum = itemNum;
    }
    public Integer getItemNum(){
    return this.itemNum;
    }
    public void setItemUnit(String itemUnit){
    this.itemUnit = itemUnit;
    }
    public String getItemUnit(){
    return this.itemUnit;
    }
    public void setConversionNum(Integer conversionNum){
    this.conversionNum = conversionNum;
    }
    public Integer getConversionNum(){
    return this.conversionNum;
    }
    public void setConversionUnit(String conversionUnit){
    this.conversionUnit = conversionUnit;
    }
    public String getConversionUnit(){
    return this.conversionUnit;
    }
    public void setBaseUnitNum(Integer baseUnitNum){
    this.baseUnitNum = baseUnitNum;
    }
    public Integer getBaseUnitNum(){
    return this.baseUnitNum;
    }
    public void setToConversionNum(Integer toConversionNum){
    this.toConversionNum = toConversionNum;
    }
    public Integer getToConversionNum(){
    return this.toConversionNum;
    }
    public void setToConversionUnit(String toConversionUnit){
    this.toConversionUnit = toConversionUnit;
    }
    public String getToConversionUnit(){
    return this.toConversionUnit;
    }
    public void setToBaseUnitNum(Integer toBaseUnitNum){
    this.toBaseUnitNum = toBaseUnitNum;
    }
    public Integer getToBaseUnitNum(){
    return this.toBaseUnitNum;
    }
    public void setToItemNum(Integer toItemNum){
    this.toItemNum = toItemNum;
    }
    public Integer getToItemNum(){
    return this.toItemNum;
    }
    public void setToItemUnit(String toItemUnit){
    this.toItemUnit = toItemUnit;
    }
    public String getToItemUnit(){
    return this.toItemUnit;
    }

    public ItemUnitConversionRecordReqDto(){

    }

    /**
     * 设置参数
     * @param documentCode 单据编码
     * @param itemCode  商品编码
     * @param itemBatch 批次编号
     * @param itemNum 商品数量
     * @param itemUnit 商品单位
     */
    public ItemUnitConversionRecordReqDto(String documentCode, String itemCode, String itemBatch, Integer itemNum, String itemUnit){
        this.documentCode = documentCode;
        this.itemCode = itemCode;
        this.itemBatch = itemBatch;
        this.itemNum = itemNum;
        this.itemUnit = itemUnit;
    }
}
