package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemConversionRecordReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemUnitRecordReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemConversionRecordRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemUnitConversionDataRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemUnitConversionRecordRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Set;

/**
* 商品转换关系记录表服务接口
*
* @author author
* @since 2022-09-02
*/
@Api(tags = {"商品转换关系记录表服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemUnitConversionRecord",
        url = "${yundt.cube.center.item.api:}")
public interface IItemUnitConversionRecordQueryApi {

    /**
    * 根据id查询商品转换关系记录表
    *
    * @param id 商品转换关系记录表id
    * @return   商品转换关系记录表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询商品转换关系记录表", notes = "根据id查询商品转换关系记录表")
    RestResponse<ItemUnitConversionRecordRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 商品转换关系记录表分页数据
    *
    * @param filter   商品转换关系记录表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 商品转换关系记录表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "商品转换关系记录表分页数据", notes = "根据filter查询条件查询商品转换关系记录表数据，filter=ItemUnitConversionRecordReqDto")
    RestResponse<PageInfo<ItemUnitConversionRecordRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询商品（记录查询数据）
     * 例:箱 -> 商品基本单位
     * @param reqDtoList 请求参数
     * @return 返回结果
     */
    @PostMapping("/queryItemUnitConversion")
    @ApiOperation(value = "商品转换关系记录表数据 箱 -> 商品基本单位", notes = "商品转换关系记录表数据 箱 -> 商品基本单位")
    RestResponse<List<ItemUnitConversionDataRespDto>> selectItemUnitConversion(@Validated @RequestBody List<ItemUnitRecordReqDto> reqDtoList);

    /**
     * 单位转换（记录查询数据）
     * 例:基本单位 -> 商品原单位
     * @param reqDtoList 请求参数
     * @return 返回结果
     */
    @PostMapping("/queryItemOriginalUnit")
    @ApiOperation(value = "商品转换关系记录表数据 基本单位 -> 商品原单位", notes = "商品转换关系记录表数据 基本单位 -> 商品原单位")
    RestResponse<List<ItemUnitConversionRecordRespDto>> selectItemOriginalUnit(@Validated @RequestBody List<ItemUnitRecordReqDto> reqDtoList);

    /**
     * 查询商品（记录查询数据）
     * 例:商品 传入单位 -> 其他单位
     * @param reqDtoList 请求参数
     * @return 返回结果
     */
    @PostMapping("/queryItemUnitByCode")
    @ApiOperation(value = "商品转换关系记录表数据 传入单位 -> 其他单位", notes = "商品转换关系记录表数据 传入单位 -> 其他单位")
    RestResponse<List<ItemUnitConversionRecordRespDto>> selectItemUnitByCode(@Validated @RequestBody List<ItemUnitRecordReqDto> reqDtoList);

    /**
     * 查询商品（记录查询数据）
     * @param reqDto 请求参数
     * @return 返回结果
     */
    @PostMapping("/queryItemUnitByParams")
    @ApiOperation(value = "商品转换关系记录表数据", notes = "商品转换关系记录表数据")
    RestResponse<List<ItemUnitConversionRecordRespDto>> selectItemUnitByParams(@Validated ItemUnitRecordReqDto reqDto);

    //Added by zhonglang at 2022.10.17
    @PostMapping("/queryItemUnitByDocumentCodes")
    @ApiOperation(value = "批量商品转换关系记录表数据", notes = "批量商品转换关系记录表数据")
    RestResponse<List<ItemUnitConversionRecordRespDto>> queryItemUnitByDocumentCodes(@Validated Set<String> documentCodeSet);

    /**
     * 商品单位转换 转 基本单位
     * @param reqDtoList 请求参数
     * @return 返回结果
     */
    @PostMapping("/queryItemConversionRecord")
    @ApiOperation(value = "商品转换关系 转 基本单位", notes = "商品转换关系 转 基本单位")
    RestResponse<List<ItemConversionRecordRespDto>> selectItemConversionRecord(@Validated @RequestBody List<ItemConversionRecordReqDto> reqDtoList);

    /**
     * 商品单位转换 转 销售单位
     * @param reqDtoList 请求参数
     * @return 返回结果
     */
    @PostMapping("/queryItemSaleConversionRecord")
    @ApiOperation(value = "商品转换关系 转 销售单位", notes = "商品转换关系 转 销售单位")
    RestResponse<List<ItemConversionRecordRespDto>> selectItemSaleConversionRecord(@Validated @RequestBody List<ItemConversionRecordReqDto> reqDtoList);

    /**
     * 商品单位转换 转 销售单位
     * @param reqDtoList 请求参数
     * @return 返回结果
     */
    @PostMapping("/selectItemSaleBox")
    @ApiOperation(value = "商品转换关系 转 销售单位", notes = "商品转换关系 转 CV")
    RestResponse<List<ItemConversionRecordRespDto>> selectItemSaleBox(@Validated @RequestBody List<ItemConversionRecordReqDto> reqDtoList);

    /**
     * 商品单位转换 转 判断CV不存在，查销售单位，不存在，
     * 查询下单单位，不存在，返回原数据
     * @param reqDto 请求参数
     * @return 返回结果
     */
    @PostMapping("/selectItemConversion")
    @ApiOperation(value = "物料单位换算:判断CV不存在，查销售单位，不存在，查询下单单位，不存在，返回原数据", notes = "商品转换关系 转 CV")
    RestResponse<List<ItemConversionRecordRespDto>> selectItemConversion(@Validated @RequestBody ItemUnitRecordReqDto reqDto);

    /**
     * 批量查询记录
     * @param reqDtoList 请求参数
     * @return 返回结果
     */
    @PostMapping("/batchSelect")
    @ApiOperation(value = "批量查询记录", notes = "批量查询记录")
    RestResponse<List<ItemUnitConversionRecordRespDto>> batchSelect(@Validated @RequestBody List<ItemUnitRecordReqDto> reqDtoList);
}
