package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * AuditItemDto
 *
 * @author 风影
 * @since 2.0.0$
 */
@ApiModel(value = "ItemAuditReqDto", description = "商品审核请求信息")
public class ItemAuditReqDto extends BaseReqDto {

    @NotNull(message = "商品id")
    @ApiModelProperty(name = "itemId" , value = "商品id")
    private Long itemId;
    /**
     * 版本状态 3审核失败、4审核通过
     */
    @NotNull(message = "版本状态不能为null")
    @ApiModelProperty(name = "status", value = "shen")
    private Integer status;
    /**
     * 审核Id
     */
    @ApiModelProperty(name = "id", value = "审核Id，不填")
    private Long id;
    /**
     * 品牌商id
     */
    @ApiModelProperty(name = "version", value = "商品版本，选填")
    private String version;
    /**
     * 品牌商code
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码，选填")
    private String itemCode;
    /**
     * 审核结果
     */
    @ApiModelProperty(name = "result", value = "审核结果，选填")
    private String result;
    /**
     * 审核意见
     */
    @ApiModelProperty(name = "auditDesc", value = "审核意见，选填")
    private String auditDesc;
    /**
     * 审核人ID
     */
    @ApiModelProperty(name = "auditPerson", value = "审核人ID，选填")
    private Long auditPerson;
    /**
     * 审核人名
     */
    @ApiModelProperty(name = "auditPerson", value = "审核人名，选填(推荐填)")
    private String auditPersonName;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getAuditDesc() {
        return auditDesc;
    }

    public void setAuditDesc(String auditDesc) {
        this.auditDesc = auditDesc;
    }

    public Long getAuditPerson() {
        return auditPerson;
    }

    public void setAuditPerson(Long auditPerson) {
        this.auditPerson = auditPerson;
    }

    public String getAuditPersonName() {
        return auditPersonName;
    }

    public void setAuditPersonName(String auditPersonName) {
        this.auditPersonName = auditPersonName;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
