/*
 * @(#)ItemChannelRelationReqDto.java 1.0 2021年09月14日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * <p>Title:ItemChannelRelationReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/14 18:19
 * @since 0.1.0
 */
@ApiModel(value = "ItemChannelRelationReqDto", description = "渠道商品对照关系Dto对象")
public class ItemChannelRelationReqDto extends RequestDto {


    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
     *  所属渠道编码
     */
    @ApiModelProperty(name = "channelCode", value = "所属渠道编码(平台)")
    private String channelCode;
    /**
     *  所属渠道名称
     */
    @ApiModelProperty(name = "channelName", value = "所属渠道名称(平台)")
    private String channelName;
    /**
     *  所属店铺编码
     */
    @ApiModelProperty(name = "shopCode", value = "所属店铺编码")
    private String shopCode;

    /**
     *  店铺名称
     */
    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;

    /**
     *  店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    /**
     *  渠道商品编码
     */
    @ApiModelProperty(name = "channelItemCode", value = "渠道商品编码")
    private String channelItemCode;
    /**
     *  渠道商品名称
     */
    @ApiModelProperty(name = "channelItemName", value = "渠道商品名称")
    private String channelItemName;
    /**
     *  渠道sku编码
     */
    @ApiModelProperty(name = "channelSkuCode", value = "渠道sku编码")
    private String channelSkuCode;
    /**
     *  渠道状态，0-关闭，1-开启
     */
    @ApiModelProperty(name = "channelStatus", value = "渠道状态，0-关闭，1-开启")
    private Integer channelStatus;
    /**
     *  商品编码
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    /**
     *  sku编码
     */
    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;
    /**
     *  对照类型：0商品，1套餐
     */
    @ApiModelProperty(name = "relationType", value = "对照类型：0商品，1套餐")
    private Integer relationType;

    @ApiModelProperty(name = "skuId", value = "平台SKUID")
    private String skuId;

    /**
     *  渠道备注
     */
    @ApiModelProperty(name = "channelRemark")
    private String channelRemark;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getChannelItemCode() {
        return channelItemCode;
    }

    public void setChannelItemCode(String channelItemCode) {
        this.channelItemCode = channelItemCode;
    }

    public String getChannelItemName() {
        return channelItemName;
    }

    public void setChannelItemName(String channelItemName) {
        this.channelItemName = channelItemName;
    }

    public String getChannelSkuCode() {
        return channelSkuCode;
    }

    public void setChannelSkuCode(String channelSkuCode) {
        this.channelSkuCode = channelSkuCode;
    }

    public Integer getChannelStatus() {
        return channelStatus;
    }

    public void setChannelStatus(Integer channelStatus) {
        this.channelStatus = channelStatus;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Integer getRelationType() {
        return relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

    public String getSkuId() {
        return skuId;
    }

    public void setSkuId(String skuId) {
        this.skuId = skuId;
    }

    public String getChannelRemark() {
        return channelRemark;
    }

    public void setChannelRemark(String channelRemark) {
        this.channelRemark = channelRemark;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
}
