/**
 * @(#) ItemDetailRespDto.java 1.0 2018-08-23
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPropGroupDto;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 商品详情响应Dto
 *
 * @author 黑马
 * @since 1.0.0
 */
@ApiModel(value = "ItemDetailRespDto", description = "商品详情响应Dto")
public class ItemDetailRespDto extends BaseRespDto {
    private static final long serialVersionUID = 2640349351287115046L;

    /**
     * 商品信息
     */
    @ApiModelProperty(name = "point", value = "商品信息")
    private ItemRespDto item;

    /**
     * 商品SKU
     */
    @ApiModelProperty(name = "itemSkuList", value = "商品SKU")
    private List<ItemSkuRespDto> itemSkuList = Lists.newArrayList();

    /**
     * 商品属性
     */
    @ApiModelProperty(name = "itemAttributesList", value = "商品属性")
    private List<ItemAttributesRespDto> itemAttributesList = Lists.newArrayList();

    @ApiModelProperty(name = "propGroupDtoList", value = "商品的基础属性组信息")
    private List<ItemPropGroupDto> propGroupDtoList = Lists.newArrayList();

    /**
     * 商品多媒体
     */
    @ApiModelProperty(name = "itemMediasList", value = "商品多媒体")
    private List<ItemMediasRespDto> itemMediasList = Lists.newArrayList();

    /**
     * 商品目录
     */
    @ApiModelProperty(name = "dirsItemsList", value = "商品目录")
    private List<DirsItemsRespDto> dirsItemsList = Lists.newArrayList();

    /**
     * 定时上下架任务列表
     */
    @ApiModelProperty(name = "shelfTaskList", value = "定时上下架任务")
    private List<ShelfTaskRespDto> shelfTaskRespDtoList = Lists.newArrayList();

    @ApiModelProperty(name = "itemPropRelationRespDtos", value = "商品属性关联dto")
    private List<ItemPropRelationRespDto> itemPropRelationRespDtos;

    @ApiModelProperty(name = "saleChannels", value = "可售渠道，1-H5商城，2-小程序商城，3-OMS系统")
    private List<String> saleChannels;

    @ApiModelProperty(value = "店铺类目ID")
    private Long shopDirId;
    @ApiModelProperty(value = "店铺类目名称")
    private String shopDirName;

    public List<ItemPropGroupDto> getPropGroupDtoList() {
        return propGroupDtoList;
    }

    public void setPropGroupDtoList(List<ItemPropGroupDto> propGroupDtoList) {
        this.propGroupDtoList = propGroupDtoList;
    }

    public ItemRespDto getItem() {
        return item;
    }

    public void setItem(ItemRespDto item) {
        this.item = item;
    }

    public List<ItemSkuRespDto> getItemSkuList() {
        return itemSkuList;
    }

    public void setItemSkuList(List<ItemSkuRespDto> itemSkuList) {
        this.itemSkuList = itemSkuList;
    }

    public List<ItemAttributesRespDto> getItemAttributesList() {
        return itemAttributesList;
    }

    public void setItemAttributesList(List<ItemAttributesRespDto> itemAttributesList) {
        this.itemAttributesList = itemAttributesList;
    }

    public List<ItemMediasRespDto> getItemMediasList() {
        return itemMediasList;
    }

    public void setItemMediasList(List<ItemMediasRespDto> itemMediasList) {
        this.itemMediasList = itemMediasList;
    }

    public List<DirsItemsRespDto> getDirsItemsList() {
        return dirsItemsList;
    }

    public void setDirsItemsList(List<DirsItemsRespDto> dirsItemsList) {
        this.dirsItemsList = dirsItemsList;
    }

    public List<ShelfTaskRespDto> getShelfTaskRespDtoList() {
        return shelfTaskRespDtoList;
    }

    public void setShelfTaskRespDtoList(List<ShelfTaskRespDto> shelfTaskRespDtoList) {
        this.shelfTaskRespDtoList = shelfTaskRespDtoList;
    }

    public List<ItemPropRelationRespDto> getItemPropRelationRespDtos() {
        return itemPropRelationRespDtos;
    }

    public void setItemPropRelationRespDtos(List<ItemPropRelationRespDto> itemPropRelationRespDtos) {
        this.itemPropRelationRespDtos = itemPropRelationRespDtos;
    }

    public List<String> getSaleChannels() {
        return saleChannels;
    }

    public void setSaleChannels(List<String> saleChannels) {
        this.saleChannels = saleChannels;
    }

    public Long getShopDirId() {
        return shopDirId;
    }

    public void setShopDirId(Long shopDirId) {
        this.shopDirId = shopDirId;
    }

    public String getShopDirName() {
        return shopDirName;
    }

    public void setShopDirName(String shopDirName) {
        this.shopDirName = shopDirName;
    }

    @Override
    public String toString() {
        return "ItemDetailRespDto{" +
                "item=" + item +
                ", itemSkuList=" + itemSkuList +
                ", itemAttributesList=" + itemAttributesList +
                ", propGroupDtoList=" + propGroupDtoList +
                ", itemMediasList=" + itemMediasList +
                ", dirsItemsList=" + dirsItemsList +
                ", shelfTaskRespDtoList=" + shelfTaskRespDtoList +
                ", itemPropRelationRespDtos=" + itemPropRelationRespDtos +
                ", saleChannels=" + saleChannels +
                ", shopDirId=" + shopDirId +
                ", shopDirName='" + shopDirName + '\'' +
                ", extFields=" + extFields +
                '}';
    }
}
