package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import com.dtyunxi.annotation.LogicColumn;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemMediasReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 商品扩展参数表Eo对象  
 *
 * @author yuangui
 * @since 2022-05-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ItemExtendReqDto", description = "商品扩展参数表Eo对象")
public class ItemExtendReqDto extends RequestDto{
    /**
     *
     */
    @ApiModelProperty(name = "id", value = "")
    private Long id;

    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;
    /**
     *  编码
     */
    @ApiModelProperty(name = "itemCode", value = "编码")
    @LogicColumn
    private String itemCode;

    /**
     * e3物料编码
     */
    @ApiModelProperty(name = "e3ItemCode", value = "e3物料编码")
    private String e3ItemCode;

    /**
     *  旧批文
     */
    @ApiModelProperty(name = "oldApproval", value = "旧批文")
    private String oldApproval;

    /**
     *  旧货品名称
     */
    @ApiModelProperty(name = "oldItemName", value = "旧货品名称")
    private String oldItemName;

    /**
     *  启用日期
     */
    @ApiModelProperty(name = "enableDate", value = "启用日期")
    private Date enableDate;

    /**
     *  停用日期
     */
    @ApiModelProperty(name = "disableDate", value = "停用日期")
    private Date disableDate;


    private String barCode;
    /**
     *  编码列表
     */
    @ApiModelProperty(name = "itemCodeList", value = "编码列表")
    private List<String> itemCodeList;
    /**
     *  长度
     */
    @ApiModelProperty(name = "length", value = "长度")
    private BigDecimal length;
    /**
     *  高度
     */
    @ApiModelProperty(name = "height", value = "高度")
    private BigDecimal height;
    /**
     *  宽度
     */
    @ApiModelProperty(name = "width", value = "宽度")
    private BigDecimal width;
    /**
     *  长单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
     */
    @ApiModelProperty(name = "lengthUnit", value = "长单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String lengthUnit;
    /**
     *  高单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
     */
    @ApiModelProperty(name = "heightUnit", value = "高单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String heightUnit;
    /**
     *  宽单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
     */
    @ApiModelProperty(name = "widthUnit", value = "宽单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String widthUnit;
    /**
     *  体积
     */
    @ApiModelProperty(name = "volume", value = "体积")
    private BigDecimal volume;
    /**
     *  体积单独
     */
    @ApiModelProperty(name = "volumnUnit", value = "体积单位")
    private String volumnUnit;
    /**
     *  毛重
     */
    @ApiModelProperty(name = "grossWeight", value = "毛重")
    private BigDecimal grossWeight;
    /**
     *  毛重单位
     */
    @ApiModelProperty(name = "grossWeightUnit", value = "毛重单位")
    private String grossWeightUnit;
    /**
     *  净重
     */
    @ApiModelProperty(name = "netWeight", value = "净重")
    private BigDecimal netWeight;
    /**
     *  净重单位
     */
    @ApiModelProperty(name = "netWeightUnit", value = "净重单位")
    private String netWeightUnit;
    /**
     *  重量
     */
    @ApiModelProperty(name = "quantity", value = "重量")
    private BigDecimal quantity;
    /**
     *  重量单位
     */
    @ApiModelProperty(name = "quantityUnit", value = "重量单位")
    private String quantityUnit;
    /**
     *  大包系数
     */
    @ApiModelProperty(name = "bigRatio", value = "大包系数")
    private Long bigRatio;
    /**
     *  中包系数
     */
    @ApiModelProperty(name = "middleRatio", value = "中包系数")
    private Long middleRatio;
    /**
     *  小包系数
     */
    @ApiModelProperty(name = "smallRatio", value = "小包系数")
    private Long smallRatio;
    /**
     *  防伪码
     */
    @ApiModelProperty(name = "securityCode", value = "防伪码")
    private String securityCode;
    /**
     *  保质期
     */
    @ApiModelProperty(name = "expirationDate", value = "保质期")
    private String expirationDate;

    @ApiModelProperty(name = "zhTrayNum", value = "珠海仓托盘数")
    private String zhTrayNum;
    /**
     *  保质期单位
     */
    @ApiModelProperty(name = "expirationUnit", value = "保质期单位")
    private String expirationUnit;
    /**
     *  是否免检
     */
    @ApiModelProperty(name = "exemption", value = "是否免检")
    private String exemption;

    private String specifications;

    private BigDecimal recommendPrice;

    private String imeiCodeFlag;

    /**
     *  标准批文
     */
    private String standardApproval;
    private String cfproducers;

    private String itemDrug;
    private String unitId;

    @ApiModelProperty(name = "packageSpecification", value = "包装规格")
    private String packageSpecification;

    @ApiModelProperty(name = "baseUnit", value = "基本计量单位")
    private String baseUnit;

    @ApiModelProperty(name = "itemType", value = "商品类型")
    private String itemType;

    @ApiModelProperty(name = "typeDescribe", value = "类型描述")
    private String typeDescribe;

    @ApiModelProperty(name = "imeiBatchFlag", value = "是否批次管理")
    private String imeiBatchFlag;

    @ApiModelProperty(name = "productGroup", value = "商品组")
    private String productGroup;//'商品组',

    @ApiModelProperty(name = "productGroupDesc", value = "商品组描述")
    private String productGroupDesc;//'商品组描述',

    @ApiModelProperty(name = "productLine", value = "产品线")
    private String productLine;// '产品线',

    @ApiModelProperty(name = "productType", value = "产品类")
    private String productType;//'产品类',

    @ApiModelProperty(name = "productUse", value = "产品用途")
    private String productUse;//'产品用途',

    @ApiModelProperty(name = "model", value = "物料型号")
    private String model;//'物料型号',

    @ApiModelProperty(name = "texture", value = "物料材质")
    private String texture;//'物料材质',

    @ApiModelProperty(name = "taste", value = "物料口味")
    private String taste;//'物料口味',

    @ApiModelProperty(name = "taxRate", value = "税分类")
    private String taxRate;

    @ApiModelProperty(name = "storageCondition", value = "存储条件")
    private String storageCondition;

    @ApiModelProperty(name = "saleUnit", value = "销售单位")
    private String saleUnit;

    /**
     *  大包箱数
     */
    @ApiModelProperty(name = "bigBox",value = "大包箱数")
    private Long bigBox;
    /**
     *  中包系数
     */
    @ApiModelProperty(name = "middleMax",value = "中包箱数")
    private Long middleMax;
    /**
     *  小包箱数
     */
    @ApiModelProperty(name = "smallBox",value = "小包箱数")
    private Long smallBox;

    /**
     *  索赔价格
     */
    @ApiModelProperty(name = "claimPrice", value = "索赔价格")
    private BigDecimal claimPrice;

    @ApiModelProperty(name = "stockUnit", value = "单位")
    private String stockUnit;

    /**
     * 过敏原
     */
    @ApiModelProperty(name = "pictureNumber",value = "过敏原")
    private String pictureNumber;

    /**
     * 添加剂
     */
    @ApiModelProperty(name = "cfadditive",value = "添加剂")
    private String cfadditive;

    /**
     * 货品属性 成品/半成品
     */
    @ApiModelProperty(name = "property",value = "货品属性 成品/半成品")
    private String property;

    /**
     * 预警期 天
     */
    @ApiModelProperty(name = "alertLeadingDays",value = "预警期 天")
    private Integer alertLeadingDays;

    /**
     * 销售投保单价
     */
    @ApiModelProperty(name = "saleInsurePrice",value = "销售投保单价")
    private BigDecimal saleInsurePrice;

    /**
     * 进口代码
     */
    @ApiModelProperty(name = "importsCode",value = "进口代码")
    private String importsCode;


    /**
     * 码盘箱数
     */
    @ApiModelProperty(name = "palletSoildQuantity",value = "码盘箱数")
    private Integer palletSoildQuantity;

    /**
     * 物料描述
     */
    @ApiModelProperty(name = "description",value = "物料描述")
    private String description;

    // ==== 北鼎字段start ====

    @ApiModelProperty(name = "name", value = "物料名称")
    private String name;

    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    @NotNull(message = "商品名称不能为空!")
    @Length(max = 100,message = "商品名称不能超过100个字符")
    private String itemName;

    @ApiModelProperty(name = "dirPrefixIds", value = "前台类目数组")
    private List<String> dirPrefixIds;

    @ApiModelProperty(name = "dirId", value = "后台类目id")
    private Long dirId;

    @ApiModelProperty(name = "dirPrefixId", value = "前台类目id")
    private Long dirPrefixId;

    @ApiModelProperty(name = "calcu_unit",value = "计量单位")
    private String calcuUnit;

    @ApiModelProperty(name = "principalPerson", value = "负责人")
    private String principalPerson;

    @ApiModelProperty(name = "enCode", value = "EAN码")
    private String enCode;

    @ApiModelProperty(name = "weightUnit",value = "重量单位")
    private String weightUnit;

    @ApiModelProperty(name = "specsUnit",value = "规格单位")
    private String specsUnit;

    @ApiModelProperty(name = "pc_specs",value = "内包装规格（PC长宽高）")
    private String pcSpecs;

    @ApiModelProperty(name = "car_specs",value = "外包装规格（CAR长宽高）")
    private String carSpecs;

    @ApiModelProperty(name = "matrixing",value = "换算因子")
    private String matrixing;

    @ApiModelProperty(name = "domesticB2b",value = "国内B2B卖点")
    private String domesticB2b;

    @ApiModelProperty(name = "internalB2b",value = "国外B2B卖点")
    private String internalB2b;

    @ApiModelProperty(name = "details", value = "介绍:富文本格式，选填")
    private String detail;

    @ApiModelProperty(name = "specs",value = "规格")
    private String specs;

    @ApiModelProperty(name = "medias", value = "商品多媒体，选填，商品的多媒体信息")
    private List<ItemMediasReqDto> medias;

    @ApiModelProperty(name = "brief", value = "描述”，富文本格式，选填")
    private String brief;

    @ApiModelProperty(name = "specContent", value = "规格")
    private String specContent;
    /**
     *  虚拟商品
     */
    @ApiModelProperty(name = "vitrual", value = "虚拟商品")
    private String vitrual;
    // ==== 北鼎字段end ====

    @ApiModelProperty(name = "expiryYear", value = "保质年数")
    private String expiryYear;

    @ApiModelProperty(name = "expiryMonth", value = "保质月份")
    private String expiryMonth;

    @ApiModelProperty(name = "validPeriod", value = "保质天数")
    private String validPeriod;

    @ApiModelProperty(name = "extension", value = "扩展字段")
    private String extension;


}
