package com.dtyunxi.yundt.cube.center.item.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ItemUnitConversionDataRespDto", description = "商品转换关系记录表Eo对象")
public class ItemUnitConversionDataRespDto extends BaseRespDto {
    /**
     *  主键
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
     *  单据编码
     */
    @ApiModelProperty(name = "documentCode", value = "单据编码")
    private String documentCode;
    /**
     *  商品编码
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    /**
     *  批次
     */
    @ApiModelProperty(name = "itemBatch", value = "批次")
    private String itemBatch;
    /**
     *  商品数量-原始数量
     */
    @ApiModelProperty(name = "itemNum", value = "商品数量-原始数量")
    private BigDecimal itemNum;
    /**
     *  商品单位-原始单位
     */
    @ApiModelProperty(name = "itemUnit", value = "商品单位-原始单位")
    private String itemUnit;
    /**
     *  商品单价-原始单价
     */
    @ApiModelProperty(name = "itemPrice", value = "商品单价-原始单价")
    private BigDecimal itemPrice;
    /**
     *  他方商品数量-换算后数量
     */
    @ApiModelProperty(name = "toItemNum", value = "他方商品数量-换算后数量")
    private BigDecimal toItemNum;
    /**
     *  他方商品单位-换算后后单位
     */
    @ApiModelProperty(name = "toItemUnit", value = "他方商品单位-换算后后单位")
    private String toItemUnit;
    /**
     *  他方商品单位-换算后后单位
     */
    @ApiModelProperty(name = "toItemPrice", value = "他方商品单价-换算后单价")
    private BigDecimal toItemPrice;
}
