package com.dtyunxi.yundt.cube.center.item.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ImportDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemBundlesReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.RItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.BundlesRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 服务接口
*
* @author yiyun
* @since 2021-09-15
*/
@Api(tags = {"商品中心：组合商品定义服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-item-api-IRItemBundleApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/item/bundle",
    url = "${yundt.cube.center.item.api:}"
)
public interface IRItemBundleApi {

/**
* 新增
*
* @param addReqDto 请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增", notes = "新增")
RestResponse<Long> addRItemBundle(@RequestBody RItemBundleReqDto addReqDto);

    /**
    * 修改
    *
    * @param modifyReqDto 请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> modifyRItemBundle(@RequestBody RItemBundleReqDto modifyReqDto);

    /**
    * 删除
    *
    * @param ids        删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> removeRItemBundle(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);

    /**
     * 新增
     *
     * @param itemExtBundleReqDto 请求对象
     * @return 处理结果
     */
    @Deprecated
    @PostMapping("/addItemBundle")
    @ApiOperation(value = "新增组合商品", notes = "新增组合商品")
    RestResponse<Void> addItemBundle(@RequestBody ItemExtBundleReqDto itemExtBundleReqDto);

    /**
     * 新增组合商品信息
     * @param reqDto
     * @return
     */
    @PostMapping("/addItemExtBundles")
    @ApiOperation(value = "新增组合商品信息", notes = "新增组合商品信息")
    RestResponse<BundlesRespDto> addItemExtBundles(@RequestBody ItemBundlesReqDto reqDto);

    /**
     * 编辑组合商品信息
     * @param reqDto
     * @return
     */
    @PostMapping("/editItemExtBundles")
    @ApiOperation(value = "编辑组合商品信息", notes = "编辑组合商品信息")
    RestResponse<Void> editItemExtBundles(@RequestBody ItemBundlesReqDto reqDto);

    /**
     * 删除组合商品信息
     * @param id
     * @param itemId
     * @return
     */
    @DeleteMapping("/removeBundleItem")
    @ApiOperation(value = "删除组合商品信息", notes = "删除组合商品信息")
    RestResponse<Void> removeBundleItem(@RequestParam("id") Long id, @RequestParam("itemId") Long itemId);

    /**
     * 删除华帝组合商品信息
     * @param id
     * @return
     */
    @DeleteMapping("/removeVattiBundleItem")
    @ApiOperation(value = "删除华帝组合商品信息", notes = "删除华帝组合商品信息")
    RestResponse<String> removeVattiBundleItem(@RequestParam("id") Long id);


    /**
     * 导入组合商品，上架
     * @param importDto
     * @return
     */
    @PostMapping("/importAndShelfItem")
    @ApiOperation(value = "批量导入组合商品，上架", notes = "批量导入组合商品，上架")
    RestResponse<String> importAndShelfItem(@RequestBody @Validated ImportDto importDto);


    /**
     * 根据商品编码，查询itemId,skuId,设置默认前台类目批量上架（初始化数据时使用）
     * @param codes
     * @return
     */
    @PostMapping("/batchShelfItemByCode")
    @ApiOperation(value = "根据商品编码，查询itemId,skuId,设置默认前台类目批量上架（初始化数据时使用）", notes = "根据商品编码，查询itemId,skuId,设置默认前台类目批量上架（初始化数据时使用）")
    RestResponse<Void> batchShelfItemByCode(@RequestBody List<String> codes);

    @PostMapping("/batchImportBundleItem")
    @ApiOperation(value = "批量导入组合商品(不上架)", notes = "批量导入组合商品(不上架)")
    RestResponse<Void> batchImportBundleItem(@RequestBody List<ItemBundlesReqDto> reqDtos);

}
