package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 商品关系sku的信息请求dto
 *
 * @ClassName ItemRelationSkuReqDto
 * @Author chunjiu
 * @Date 2020/12/23 20:07
 */
@ApiModel(value = "ItemRelationSkuReqDto", description = "商品关系sku的信息请求dto")
public class ItemRelationSkuReqDto {
    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;

    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;

    /**
     * 商品编码
     */
    @ApiModelProperty(name = "itemId", value = "商品Id")
    private String itemId;

    /**
     * 商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    /**
     * 商品编码
     */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    /**
     * 目录Id
     */
    @ApiModelProperty(name = "dirId", value = "后台类目Id")
    private Long dirId;

    @ApiModelProperty(name = "dirName", value = "后台类目名称")
    private String dirName;

    @ApiModelProperty(name = "attr", value = "属性")
    private String attr;

    @ApiModelProperty(name = "unitPrice", value = "单价")
    private BigDecimal unitPrice;

    @ApiModelProperty(name = "retailPrice", value = "零售价")
    private BigDecimal retailPrice;

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getItemId() {
        return itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public String getAttr() {
        return attr;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public BigDecimal getRetailPrice() {
        return retailPrice;
    }

    public void setRetailPrice(BigDecimal retailPrice) {
        this.retailPrice = retailPrice;
    }
}
