/**
 * @(#)ItemShelfRespDto.java 1.0 2020/1/8
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 商品上架信息响应dto
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "ItemShelfRespDto", description = "商品上架信息响应dto")
public class ItemShelfRespDto extends BaseRespDto {

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    /**
     * 店铺ID
     */
    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    /**
     * 版本
     */
    @ApiModelProperty(name = "versionId", value = "版本")
    private Long versionId;

    /**
     * 商品id
     */
    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    /**
     * skuId
     */
    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;

    /**
     * 0 待上架 1已上架 2已下架
     */
    @ApiModelProperty(name = "status", value = "状态：0 待上架 1已上架 2已下架")
    private Integer status;

    /**
     * 上架时间
     */
    @ApiModelProperty(name = "shelfTime", value = "上架时间")
    private Date shelfTime;

    /**
     * 价格
     */
    @ApiModelProperty(name = "price", value = "价格")
    private BigDecimal price;

    /**
     * 商户id
     */
    @ApiModelProperty(name = "sellerId", value = "商户id")
    private Long sellerId;
    @ApiModelProperty(name = "type", value = "上架类型：1普通上架 2周期购上架,3积分上架")
    private Integer type;
    @ApiModelProperty(name = "itemType", value = "商品类型：1普通商品 2积分商品")
    private Integer itemType;
    @ApiModelProperty(name = "busType", value = "上架业务类型：0普通商品 2 积分商品")
    private Integer busType;
    @ApiModelProperty(name = "shelfIntegral", value = "商品类型：上架类型")
    private ShelfIntegralRespDto shelfIntegral;
    @ApiModelProperty(name = "distribution", value = "是否分销：1是，0否, 默认0")
    private Integer distribution;
    @ApiModelProperty(name = "freightTemplateId",value = "运费模板id")
    private Long freightTemplateId;

    @ApiModelProperty(name = "pointsDeduction", value = "是否有积分扣减配置")
    private Integer pointsDeduction;
    @ApiModelProperty(name = "pointsDeductionRespDto", value = "积分扣减配置信息")
    private PointsDeductionRespDto pointsDeductionRespDto;

    @ApiModelProperty(name = "stockDisplay", value = "库存显示,1:显示可用库存数量;2:显示库存充足;3:不显示库存")
    private Integer stockDisplay;

    @ApiModelProperty(name = "limitMin", value = "起订量;limit_min_mode的值为1就为固定值;2就为最小包装数倍数")
    private Integer limitMin;

    @ApiModelProperty(name = "limitMinMode", value = "起订量计算方式,1:自定义设置(固定值);2:最小包装数倍数(按最小包装数倍数起订，起订量=最小包装数*最小包装数倍数)")
    private Integer limitMinMode;

    @ApiModelProperty(name = "multipleStatus", value = "订购倍数控制,0:关闭;1:开启(开启时，下单商品数量必须等于起订量的倍数)")
    private Integer multipleStatus;

    @ApiModelProperty(name = "homePageDisplay",value = "首页推荐 0 H5商城 1 Web商城(多选用','分割)")
    private String homePageDisplay;

    public Integer getStockDisplay() {
        return stockDisplay;
    }

    public void setStockDisplay(Integer stockDisplay) {
        this.stockDisplay = stockDisplay;
    }

    public Integer getLimitMin() {
        return limitMin;
    }

    public void setLimitMin(Integer limitMin) {
        this.limitMin = limitMin;
    }

    public Integer getLimitMinMode() {
        return limitMinMode;
    }

    public void setLimitMinMode(Integer limitMinMode) {
        this.limitMinMode = limitMinMode;
    }

    public Integer getMultipleStatus() {
        return multipleStatus;
    }

    public void setMultipleStatus(Integer multipleStatus) {
        this.multipleStatus = multipleStatus;
    }

    public Integer getPointsDeduction() {
        return pointsDeduction;
    }

    public void setPointsDeduction(Integer pointsDeduction) {
        this.pointsDeduction = pointsDeduction;
    }

    public PointsDeductionRespDto getPointsDeductionRespDto() {
        return pointsDeductionRespDto;
    }

    public void setPointsDeductionRespDto(PointsDeductionRespDto pointsDeductionRespDto) {
        this.pointsDeductionRespDto = pointsDeductionRespDto;
    }

    public Long getFreightTemplateId() {
        return freightTemplateId;
    }

    public void setFreightTemplateId(Long freightTemplateId) {
        this.freightTemplateId = freightTemplateId;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public ShelfIntegralRespDto getShelfIntegral() {
        return shelfIntegral;
    }

    public void setShelfIntegral(ShelfIntegralRespDto shelfIntegral) {
        this.shelfIntegral = shelfIntegral;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getVersionId() {
        return versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getShelfTime() {
        return shelfTime;
    }

    public void setShelfTime(Date shelfTime) {
        this.shelfTime = shelfTime;
    }

    public Integer getDistribution() {
        return distribution;
    }

    public void setDistribution(Integer distribution) {
        this.distribution = distribution;
    }

    public String getHomePageDisplay() {
        return homePageDisplay;
    }

    public void setHomePageDisplay(String homePageDisplay) {
        this.homePageDisplay = homePageDisplay;
    }
}
