/**
 * @(#)PropGroupDto 1.0 2019/4/26
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 查询属性使用，属性组基本信息（不含属性信息，含挂靠的目录信息）
 *
 * @author shuangqing  2019/4/26
 */
@ApiModel(value = "PropGroupDto", description = "属性组基本信息（不含属性信息，含挂靠的目录信息）")
public class PropGroupDto extends BaseRespDto {
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;

    @ApiModelProperty(name = "code", value = "分组编码")
    private String code;

    @ApiModelProperty(name = "name", value = "分组名称")
    private String name;

    @ApiModelProperty(name = "description", value = "描述")
    private String description;

    @ApiModelProperty(name = "tenantId", value = "租户id")
    private Long tenantId;

    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    @ApiModelProperty(name = "dirPropDtoList", value = "属性组挂靠的目录列表")
    private List<DirPropDto> dirPropDtoList;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public List<DirPropDto> getDirPropDtoList() {
        return dirPropDtoList;
    }

    public void setDirPropDtoList(List<DirPropDto> dirPropDtoList) {
        this.dirPropDtoList = dirPropDtoList;
    }
}
