/*
 * @(#)DirItemRelativeReqDto.java 1.0 2020-07-31
 *
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;


/**
 * @author 简树
 * @since 2.0.0
 */
@ApiModel(value = "DirItemRelativeReqDto", description = "目录上架记录查询")
public class DirItemRelativeReqDto {
    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "skuId", value = "规格Id，")
    private Long skuId;


    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;
    /**
     * 类目类型
     */
    @ApiModelProperty(name = "dirType", value = "类目类型")
    private String dirType;

    /**
     * 类目ids
     */
    @ApiModelProperty(name = "dirIds", value = "类目类型")
    private List<Long> dirIds;


    /**
     * 商户id
     */
    @ApiModelProperty(name = "sellerId", value = "商户id")
    private Long sellerId;

    @ApiModelProperty(name = "busType", value = "业务类型")
    private Integer busType;

    public String getDirType() {
        return dirType;
    }

    public void setDirType(String dirType) {
        this.dirType = dirType;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public List<Long> getDirIds() {
        return dirIds;
    }

    public void setDirIds(List<Long> dirIds) {
        this.dirIds = dirIds;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }
}