/*
 * @(#)DirectoryReqDto.java 1.0 2018-09-17
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 目录Dto
 *
 * @author 诺克
 * @since 2.0.0
 */
@ApiModel(value = "DirectoryReqDto", description = "目录项请求信息")
public class DirectoryReqDto extends BaseReqDto {

    @ApiModelProperty(name = "id", value = "目录项ID：新增操作不要填写此项，后台自动生成主键")
    private Long id;

    @NotNull
    @ApiModelProperty(name = "code", value = "编码，选填")
    private String code;

    //    @NotNull
    @ApiModelProperty(name = "rootId", value = "根节点，选填")
    private Long rootId;

    @NotNull
    @ApiModelProperty(name = "parentId", value = "父ID，选填")
    private Long parentId;

    @ApiModelProperty(name = "name", value = "目录名，必填")
    @NotNull
    private String name;

    @ApiModelProperty(name = "link", value = "引用目录，选填")
    private Long link;

    @ApiModelProperty(name = "links", value = "引用目录集合，选填")
    private List<Long> links;

    @ApiModelProperty(name = "attrs", value = "其他属性，选填")
    private String attrs;

    @ApiModelProperty(name = "ownerId", value = "创建人ID，选填")
    private Long ownerId;

    @ApiModelProperty(name = "status", value = "状态 0禁用1启用，选填")
    private Integer status;
    /**
     * 前台类目关联后台类目
     */
    @ApiModelProperty(name = "frontRelationBack",value = "前台类目关联后台类目")
    private String frontRelationBack;
    @ApiModelProperty(name = "shopId",value = "店铺id")
    private Long shopId;

    @ApiModelProperty(name = "ids", value = "商品授权专用字段")
    private List<Long> ids;

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    /**
     * 店铺类目关联后台类目
     */
//    @ApiModelProperty(name = "shopRelationBack",value = "店铺类目关联后台类目")
//    private String shopRelationBack;

    public String getFrontRelationBack() {
        return frontRelationBack;
    }

    public void setFrontRelationBack(String frontRelationBack) {
        this.frontRelationBack = frontRelationBack;
    }

//    public String getShopRelationBack() {
//        return shopRelationBack;
//    }
//
//    public void setShopRelationBack(String shopRelationBack) {
//        this.shopRelationBack = shopRelationBack;
//    }

    @ApiModelProperty(name = "description", value = "描述")
    private String description;

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getRootId() {
        return rootId;
    }

    public void setRootId(Long rootId) {
        this.rootId = rootId;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getLink() {
        return link;
    }

    public void setLink(Long link) {
        this.link = link;
    }

    public List<Long> getLinks() {
        return links;
    }

    public void setLinks(List<Long> links) {
        this.links = links;
    }

    public String getAttrs() {
        return attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
