package com.dtyunxi.yundt.cube.center.item.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * <p>Title:ItemShelfQueryReqDto</p>
 * <p>Description: </p>
 *
 * @author yiyun
 * @date 2021/9/1 16:01
 * @since 0.1.0
 */
@ApiModel(value = "ItemShelfQueryReqDto", description = "商品列表定义Dto对象")
public class ItemShelfQueryReqDto implements Serializable {

    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;

    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "dirId", value = "后台类目")
    private Long dirId;

    @ApiModelProperty(name = "dirName", value = "后台类目名称")
    private String dirName;

    @ApiModelProperty(name = "dirPrefixId", value = "前台类目")
    private Long dirPrefixId;

    @ApiModelProperty(name = "dirPrefixName", value = "前台类目名称")
    private String dirPrefixName;

    @ApiModelProperty(name = "updateBeginTime", value = "更新开始时间")
    private String updateBeginTime;

    @ApiModelProperty(name = "updateEndTime", value = "更新结束时间")
    private String updateEndTime;

    @ApiModelProperty(name = "createBeginTime", value = "创建开始时间")
    private String createBeginTime;

    @ApiModelProperty(name = "createEndTime", value = "创建结束时间")
    private String createEndTime;

    @ApiModelProperty(name = "status", value = "上下架状态")
    private Integer status;

    @ApiModelProperty(name = "type", value = "1-商品，2.产品 3组合商品 4虚拟商品 5赠品商品")
    private Integer type;

    @ApiModelProperty(name = "typeFlag", value = "后台判断标识，用于商品列表查询使用")
    private String typeFlag;

    @ApiModelProperty(name = "forward", value = "商城查询标识判断查询推荐商品与爆款商品,forward=statistics:推荐商品，forward=stat：爆款商品")
    private String forward;

    @ApiModelProperty(name = "keywords", value = "关键字")
    private String keywords;
    @ApiModelProperty(name = "itemIds", value = "商品id列表")
    private List<Long> itemIds;
    @ApiModelProperty(name = "sort", value = "排序值1综合倒序，2销量倒序,3价格升序排，4价格倒序")
    private Integer sort = 1;
    @ApiModelProperty(name = "shelfAddress", value = "上架地址(0:国内B2B商城,1:国外B2B商城)")
    private String shelfAddress;
    @ApiModelProperty(name = "priceIdentify", value = "价格标识(0:国内价格标识,1:国外价格标识)")
    private String priceIdentify;
    @ApiModelProperty(name = "currency", value = "币种,0:人民币 1:美元 2:日元 3:欧元 4:英镑 5:澳元 6:港元 7:澳门元")
    private Integer currency;

    @ApiModelProperty(name = "customerId", value = "客户id")
    private Long customerId;
    @ApiModelProperty(name = "userId", value = "商城业务员登录后，选择经销商后返回的userId")
    private Long userId;
    @ApiModelProperty(name = "customerType", value = "客户类型")
    private Integer customerType;
    @ApiModelProperty(name = "isGroupBuy", value = "是否选择团购")
    private Boolean isGroupBuy;

    @ApiModelProperty(
            name = "pageNum",
            value = "当前页"
    )
    private Integer pageNum = 1;
    @ApiModelProperty(
            name = "pageSize",
            value = "每页数"
    )
    private Integer pageSize = 10;

    @ApiModelProperty(name = "prodLargeClass", value = "产品大类(北鼎一级品类描述)")
    private String prodLargeClass;
    @ApiModelProperty(name = "prodLargeCode", value = "产品大类编码(北鼎一级品类)")
    private String prodLargeCode;
    @ApiModelProperty(name = "prodSecClassify", value = "产品二级分类(北鼎二级品类描述)")
    private String prodSecClassify;
    @ApiModelProperty(name = "prodSecCode", value = "产品二级分类编码(北鼎二级品类)")
    private String prodSecCode;
    @ApiModelProperty(name = "prodThrClassify", value = "产品三级分类(北鼎三级品类描述)")
    private String prodThrClassify;
    @ApiModelProperty(name = "prodThrCode", value = "产品三级分类编码(北鼎三级品类)")
    private String prodThrCode;
    @ApiModelProperty(name = "prodClassCode", value = "产品型号")
    private String prodClassCode;
    @ApiModelProperty(name = "prodClassName", value = "产品名称")
    private String prodClassName;
    @ApiModelProperty(name = "saleGroup", value = "组合商品")
    private List<String> saleGroup;

    /**
     * 仅用于创建活动时查询的标识。true：查询商品、组合商品、赠品，false-组合商品
     */
    private Boolean activitySearch = false;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public Long getDirPrefixId() {
        return dirPrefixId;
    }

    public void setDirPrefixId(Long dirPrefixId) {
        this.dirPrefixId = dirPrefixId;
    }

    public String getDirPrefixName() {
        return dirPrefixName;
    }

    public void setDirPrefixName(String dirPrefixName) {
        this.dirPrefixName = dirPrefixName;
    }

    public String getUpdateBeginTime() {
        return updateBeginTime;
    }

    public void setUpdateBeginTime(String updateBeginTime) {
        this.updateBeginTime = updateBeginTime;
    }

    public String getUpdateEndTime() {
        return updateEndTime;
    }

    public void setUpdateEndTime(String updateEndTime) {
        this.updateEndTime = updateEndTime;
    }

    public String getCreateBeginTime() {
        return createBeginTime;
    }

    public void setCreateBeginTime(String createBeginTime) {
        this.createBeginTime = createBeginTime;
    }

    public String getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(String createEndTime) {
        this.createEndTime = createEndTime;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public List<Long> getItemIds() {
        return itemIds;
    }

    public void setItemIds(List<Long> itemIds) {
        this.itemIds = itemIds;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getShelfAddress() {
        return shelfAddress;
    }

    public void setShelfAddress(String shelfAddress) {
        this.shelfAddress = shelfAddress;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getTypeFlag() {
        return typeFlag;
    }

    public void setTypeFlag(String typeFlag) {
        this.typeFlag = typeFlag;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getCustomerType() {
        return customerType;
    }

    public void setCustomerType(Integer customerType) {
        this.customerType = customerType;
    }

    public Boolean getGroupBuy() {
        return isGroupBuy;
    }

    public void setGroupBuy(Boolean groupBuy) {
        isGroupBuy = groupBuy;
    }

    public String getPriceIdentify() {
        return priceIdentify;
    }

    public void setPriceIdentify(String priceIdentify) {
        this.priceIdentify = priceIdentify;
    }

    public String getProdLargeClass() {
        return prodLargeClass;
    }

    public void setProdLargeClass(String prodLargeClass) {
        this.prodLargeClass = prodLargeClass;
    }

    public String getProdLargeCode() {
        return prodLargeCode;
    }

    public void setProdLargeCode(String prodLargeCode) {
        this.prodLargeCode = prodLargeCode;
    }

    public String getProdSecClassify() {
        return prodSecClassify;
    }

    public void setProdSecClassify(String prodSecClassify) {
        this.prodSecClassify = prodSecClassify;
    }

    public String getProdSecCode() {
        return prodSecCode;
    }

    public void setProdSecCode(String prodSecCode) {
        this.prodSecCode = prodSecCode;
    }

    public String getProdThrClassify() {
        return prodThrClassify;
    }

    public void setProdThrClassify(String prodThrClassify) {
        this.prodThrClassify = prodThrClassify;
    }

    public String getProdThrCode() {
        return prodThrCode;
    }

    public void setProdThrCode(String prodThrCode) {
        this.prodThrCode = prodThrCode;
    }

    public String getProdClassCode() {
        return prodClassCode;
    }

    public void setProdClassCode(String prodClassCode) {
        this.prodClassCode = prodClassCode;
    }

    public String getProdClassName() {
        return prodClassName;
    }

    public void setProdClassName(String prodClassName) {
        this.prodClassName = prodClassName;
    }

    public String getForward() {
        return forward;
    }

    public void setForward(String forward) {
        this.forward = forward;
    }

    public Integer getCurrency() {
        return currency;
    }

    public void setCurrency(Integer currency) {
        this.currency = currency;
    }

    public Boolean getActivitySearch() {
        return activitySearch;
    }

    public void setActivitySearch(Boolean activitySearch) {
        this.activitySearch = activitySearch;
    }

    public List<String> getSaleGroup() {
        return saleGroup;
    }

    public void setSaleGroup(List<String> saleGroup) {
        this.saleGroup = saleGroup;
    }
}
