/*
 * @(#)IICategoryQueryApi.java 1.0 2021年09月22日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.cube.commons.dto.TreeDto;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.DirCategoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.DirCategoryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemCategoryRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>Title:IICategoryQueryApi</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/22 11:37
 * @since 0.1.0
 */
@Api(tags = {"商品中心：目录服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-item-api-query-IICategoryQueryApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/category/item",
        url = "${yundt.cube.center.item.api:}"
)
public interface IICategoryQueryApi {

    @GetMapping("/getCategoryList/")
    @ApiOperation(value = "查询类目信息", notes = "查询类目信息")
    RestResponse<List<ItemCategoryRespDto>> getCategoryList();

    @GetMapping("/queryDirectoryByCode/{code}")
    @ApiOperation(value = "根据类目编码查询类目", notes = "根据类目编码查询类目")
    RestResponse<DirectoryItemRespDto> queryDirectoryByCode(@PathVariable("code") String code);


    @PostMapping("/getParentCategoryList")
    @ApiOperation(value = "根据后台类目查询商品信息-支持查询类目的上下级查询", notes = "根据后台类目先查询类目的上下级类目，再查询类目关联的商品信息")
    RestResponse<PageInfo<ItemRespDto>> getItemByDirCategory(@Validated @RequestBody DirCategoryReqDto reqDto);

    /**
     * 据后台类目查询商品信息-支持查询类目的上下级查询
     * @param reqDto
     * @return
     */
    @PostMapping("/getBackDirCategory")
    @ApiOperation(value = "根据后台类目查询商品信息-支持查询类目的上下级查询(有缓存)", notes = "根据后台类目先查询类目的上下级类目，再查询类目关联的商品信息(有缓存)")
    RestResponse<List<ItemRespDto>> getBackDirCategory(@Validated @RequestBody DirCategoryReqDto reqDto);

    @PostMapping("/getItemByFrontCategory")
    @ApiOperation(value = "根据前台类目查询商品信息-支持查询类目的上下级查询", notes = "根据后台类目先查询类目的上下级类目，支持任意前台类目查询")
    RestResponse<PageInfo<ItemRespDto>> getItemByFrontCategory(@RequestBody DirCategoryReqDto reqDto);

    /**
     * 任意后台目录Id查询商品信息
     * @param dirId
     * @return
     */
    @PostMapping("/queryItemByDirCategoryId")
    @ApiOperation(value = "任意后台目录Id查询商品信息", notes = "任意后台目录Id查询商品信息")
    RestResponse<PageInfo<ItemRespDto>> queryItemByDirCategoryId(@RequestParam("dirId") Long dirId,
                                                                 @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                 @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @GetMapping({"/tree"})
    @ApiOperation(
            value = "根据条件查询目录树,不会返回目录索引信息",
            notes = "目录查询接口:rootId:根目录ID集合：{dirUsage=?},filter=RootDirectoryReqDto"
    )
    RestResponse<List<TreeDto<DirectoryItemRespDto>>> queryDirectoryTreeByFilter(@RequestParam("filter") String filter);

    /**
     * 任意后台目录Id查询商品信息
     * @param id
     * @return
     */
    @PostMapping("/queryParentCategorys")
    @ApiOperation(value = "根据类目ID查询父级类目", notes = "根据类目ID查询父级类目")
    RestResponse<List<DirCategoryRespDto>> queryParentCategorys(@RequestParam("id") Long id);

    /**
     * 根据类目ID查询子级类目
     * @param id
     * @return
     */
    @PostMapping("/queryChildCategorys")
    @ApiOperation(value = "根据类目ID查询子级类目", notes = "根据类目ID查询子级类目")
    RestResponse<List<DirCategoryRespDto>> queryChildCategorys(@RequestParam("id") Long id);

    @PostMapping("/queryDirByCodes")
    @ApiOperation(value = "根据类目code查询类目", notes = "根据类目code查询类目")
    RestResponse<List<DirectoryItemRespDto>> queryDirByCodes(@RequestParam("codes") List<String> codes);

}
