/*
 * @(#)IItemPresentQueryApi.java 1.0 2021年09月12日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemMainReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * <p>Title:IItemPresentQueryApi</p>
 * <p>Description: </p>
 *
 * @author yiyun.lkh
 * @date 2021/9/12 23:35
 * @since 0.1.0
 */
@Api(tags = {"商品中心：赠品管理服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-item-api-query-IItemPresentQueryApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/present/item",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemPresentQueryApi {

    /**
     * 分页查询赠品商品列表
     * @param mainReqDto
     * @return
     */
    @GetMapping("/presentItemPage")
    @ApiOperation(value = "分页查询赠品商品列表", notes = "分页查询赠品商品列表")
    RestResponse<PageInfo<ItemRespDto>> presentItemsByPage(@ModelAttribute ItemMainReqDto mainReqDto);

    @PostMapping("/presentItemPages")
    @ApiOperation(value = "分页查询赠品商品列表", notes = "分页查询赠品商品列表")
    RestResponse<PageInfo<ItemRespDto>> presentItemPage(@RequestBody ItemMainReqDto mainReqDto);

    /**
     * 查询非组合商品列表
     * @param mainReqDto
     * @return
     */
    @GetMapping("/page")
    @ApiOperation(value = "查询非组合商品列表", notes = "查询非组合商品列表")
    RestResponse<PageInfo<ItemRespDto>> queryByPage(@ModelAttribute ItemMainReqDto mainReqDto);



}
