package com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 客户商品授权规则Eo对象
 *
 * @author cijian
 * @since 2022-11-14
 */
@Data
@ApiModel(value = "AuthItemRuleReqDto", description = "客户商品授权规则Eo对象")
public class AuthItemRuleReqDto extends RequestDto {
    /**
     * 主键
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
     * 客户Id
     */
    @ApiModelProperty(name = "customerId", value = "客户Id")
    private Long customerId;
    /**
     * 客户名称
     */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;
    /**
     * 客户编号
     */
    @ApiModelProperty(name = "customerCode", value = "客户编号")
    private String customerCode;
    /**
     * 授权方式,0.全部商品，1.指定品类，2.指定商品
     */
    @ApiModelProperty(name = "authType", value = "授权方式,0.全部商品，1.指定品类，2.指定商品")
    private Integer authType;
    /**
     * 指定商品类型，1.商品，2.赠品，3.物料，多个逗号隔开
     */
    @ApiModelProperty(name = "subType", value = "指定商品类型，1.商品，2.赠品，3.物料，多个逗号隔开")
    private String subType;
    /**
     * 指定商品品牌,多个逗号隔开
     */
    @ApiModelProperty(name = "brandId", value = "指定商品品牌,多个逗号隔开")
    private String brandId;

    @ApiModelProperty(name = "blackAuthItemReqDtos", value = "黑名单商品（当authType为1时可能存在）")
    private List<BlackAuthItemReqDto> blackAuthItemReqDtos;

    @ApiModelProperty(name = "customerAuthItemReqDtos", value = "指定授权商品（当authType为2时不能为空）")
    private List<CustomerAuthItemReqDto> customerAuthItemReqDtos;

    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    private Integer PageNum = 1;

    private Integer PageSize = 10;

}
