/**
 * @(#) ItemStorageQueryReqDto.java 1.0 2018-12-04
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.List;

/**
 * 商品库存查询Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ItemStorageBranchQueryReqDto", description = "商品库存批量查询Dto")
public class ItemStorageBranchQueryReqDto extends BaseReqDto {


    /**
     * skuId集合
     */
    @ApiModelProperty(name = "shelfList", value = "库存上架查询集合")
    private List<ShelfReqDto>  shelfList;

    public List<ShelfReqDto> getShelfList() {
        return shelfList;
    }

    public void setShelfList(List<ShelfReqDto> shelfList) {
        this.shelfList = shelfList;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
