package com.yx.tcbj.center.api;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.api.dto.request.SellerSkuPriceReqDto;
import com.yx.tcbj.center.api.dto.response.ProductPriceRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

import java.util.List;

/**
* 供应商和产品的供货价格服务接口
*
* @author 迪迦
* @since 2021-09-10
*/
@Api(tags = {"供应商和产品的供货价格服务"})
@FeignClient(
    contextId = "com-yx-tcbj-center-item-api-ISellerSkuPriceApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/sellerSkuPrice",
    url = "${yundt.cube.center.item.api:}"
)
public interface ISellerSkuPriceApi {

    /**
    * 新增供应商和产品的供货价格
    *
    * @param addReqDto 供应商和产品的供货价格请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增供应商和产品的供货价格", notes = "新增供应商和产品的供货价格")
    RestResponse<Long> addSellerSkuPrice(@RequestBody SellerSkuPriceReqDto addReqDto);

    /**
    * 修改供应商和产品的供货价格
    *
    * @param modifyReqDto 供应商和产品的供货价格请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改供应商和产品的供货价格", notes = "修改供应商和产品的供货价格")
    RestResponse<Void> modifySellerSkuPrice(@RequestBody SellerSkuPriceReqDto modifyReqDto);

    /**
    * 删除供应商和产品的供货价格
    *
    * @param ids        供应商和产品的供货价格删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除供应商和产品的供货价格", notes = "删除供应商和产品的供货价格")
    RestResponse<Void> removeSellerSkuPrice(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);


    /**
     * 新增供应商和产品的价格
     * @param productPriceRespDto 产品详情
     * @return 处理结果
     */
    @PostMapping("/addPrice")
    @ApiOperation(value = "初始化供应商和产品的价格", notes = "初始化供应商和产品的价格")
    public RestResponse<Boolean> addPrice(@RequestBody ProductPriceRespDto productPriceRespDto);

    /**
     * 更新供应商和产品的价格
     * @param productPriceRespDto 产品详情
     * @return 处理结果
     */
    @PostMapping("/updatePrice")
    @ApiOperation(value = "更新供应商和产品的价格", notes = "更新供应商和产品的价格")
    public RestResponse<Boolean> updatePrice(@RequestBody ProductPriceRespDto productPriceRespDto);

    /**
     * 批量新增供应商和产品的价格
     * @param productPriceRespDto
     * @return
     */
    @PostMapping("/addNewPrice")
    @ApiOperation(value = "批量新增供应商和产品的价格", notes = "批量新增供应商和产品的价格")
    public RestResponse<Boolean> addNewPrice(@RequestBody List<ProductPriceRespDto> productPriceRespDto);

    /**
     * 更新供应商和产品的价格
     * @param productPriceRespDto 产品详情
     * @return 处理结果
     */
    @PostMapping("/updatePriceList")
    @ApiOperation(value = "更新供应商和产品的价格列表", notes = "更新供应商和产品的价格列表")
    public RestResponse<Boolean> updatePriceList(@RequestBody List<ProductPriceRespDto> productPriceRespDto);

    /**
     * 更新供应商和产品的价格
     * @param productPriceRespDto 产品详情
     * @return 处理结果
     */
    @PostMapping("/updatePriceListExt")
    @ApiOperation(value = "更新供应商和产品的价格列表", notes = "更新供应商和产品的价格列表")
    void updatePriceExt(@RequestBody ProductPriceRespDto productPriceRespDto);

}
