package com.yx.tcbj.center.api;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.api.dto.response.ItemBlackAuthRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 供应商和产品的供货价格服务接口
 *
 * @author jianshi
 * @since 2021-11-11
 */
@Api(tags = {"商品中心:商品授权相关"})
@FeignClient(
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/item/black",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemBlackExtApi {


    @GetMapping("/import/black/item")
    @ApiOperation(value = "导入商品列表", notes = "导入商品列表")
    RestResponse<ItemBlackAuthRespDto> importBlackItem(@RequestParam("url") String url);

    @GetMapping("/import/shop/item")
    @ApiOperation(value = "导入店铺商品", notes = "导入店铺商品")
    RestResponse<ItemBlackAuthRespDto> importShopItem(@RequestParam("url") String url);

}
