package com.yx.tcbj.center.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailBaseInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuInfoRespDto;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.api.dto.request.*;
import com.yx.tcbj.center.api.dto.response.ItemExportQueryRespDto;
import com.yx.tcbj.center.api.dto.response.ItemPricePageRespDto;
import com.yx.tcbj.center.api.dto.response.ItemSkuExcludeRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author 迪迦
 * @date 2021-09-26
 */
@Api(tags = {"商品中心查询"})
@FeignClient(
        contextId = "com-yx-tcbj-center-item-api-query-IItemCenterQueryApi",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemCenter",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemCenterQueryApi {

    /**
     * 商品价格列表分页数据
     *
     * @param filter   商品价格列表分页数据查询条件
     * @return 商品价格列表分页数据分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "商品价格列表分页数据", notes = "商品价格列表分页数据，filter=ItemPricePageReqDto")
    RestResponse<PageInfo<ItemPricePageRespDto>> queryPriceByPage(@RequestBody ItemPricePageReqDto filter);

    @PostMapping({"/sku/exclude/page"})
    @ApiOperation(
            value = "查询sku排除分页",
            notes = "免费赠品额度商品排除查询，filter=ItemReqDto"
    )
    RestResponse<PageInfo<ItemSkuExcludeRespDto>> findItemSkuExclude(@RequestBody ItemSkuExcludeReqDto itemSkuExcludeReqDto);

    @PostMapping("/queryShopItemList")
    @ApiOperation(value = "根据商品编码查询店铺商品列表", notes = "根据商品编码查询店铺商品列表")
    RestResponse<List<ItemDetailBaseInfoRespDto>> queryShopItemList(@RequestBody ItemShopQueryReqDto itemShopQueryReqDto);


    /**
     * 根据自定义条件查询商品信息
     * @param reqDto 自定义条件查询商品请求dto
     * @return
     */
    @PostMapping({"/queryItemSkuInfo"})
    @ApiOperation(value = "根据自定义条件查询商品信息", notes = "根据自定义条件查询商品信息")
    RestResponse<List<ItemSkuInfoRespDto>> queryItemSkuInfo(@RequestBody ItemSkuInfoReqDto reqDto);


    @ApiOperation(value = "分页查询商品上下架列表(商品导出查询专用)", notes = "分页查询商品上下架列表(商品导出查询专用)")
    @PostMapping("/queryExportPage")
    RestResponse<PageInfo<ItemExportQueryRespDto>> queryExportPage(@RequestBody ItemExportQueryReqDto reqDto);

}
