package com.yx.tcbj.center.api.dto.base;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 基础参数
 *
 * @author gongsun
 * @version 0.1.0
 * @date 2019/7/26
 */
@Data
public class BaseReqDto extends BaseVo {

    /**
     *  页数
     */
    @ApiModelProperty(name = "pageNum", value = "页数")
    protected Integer pageNum = 1;

    /**
     *  每页条数
     */
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    protected Integer pageSize = 10;

    /**
     *  创建开始时间
     */
    @ApiModelProperty(name = "createStartTime", value = "创建开始时间")
    private Date createStartTime;

    /**
     *  创建结束时间
     */
    @ApiModelProperty(name = "createEndTime", value = "创建结束时间")
    private Date createEndTime;

    /**
     *  更新开始时间
     */
    @ApiModelProperty(name = "updateStartTime", value = "更新开始时间")
    private Date updateStartTime;

    /**
     *  更新结束时间
     */
    @ApiModelProperty(name = "updateEndTime", value = "更新结束时间")
    private Date updateEndTime;

    /**
     *  操作人
     */
    @ApiModelProperty(name = "updatePerson", value = "操作人")
    private String updatePerson;

    /**
     *  创建人
     */
    @ApiModelProperty(name = "createPerson", value = "创建人")
    private String createPerson;

    /**
     *  是否分页 0分页 1不分页
     */
    @ApiModelProperty(name = "pageFlag", value = "是否分页，0分页 1不分页")
    private Integer pageFlag;
}
