package com.yx.tcbj.center.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel(value = "PcpItemQueryDto", description = "查询Dto")
public class PcpItemQueryDto extends RequestDto {
    /**
     * 商品长编码集合查询
     */
    @ApiModelProperty(name = "longCodeList", value = "商品长编码集合查询")
    private List<String> longCodeList;
    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
     * 商品长编码
     */
    @ApiModelProperty(name = "code", value = "商品编码")
    private String code;
    /**
     * 1-有效 0-无效
     */
    @ApiModelProperty(name = "itemStatus", value = "1-有效 0-无效")
    private Long itemStatus;
    /**
     * 商品剂型 1-粉剂
     */
    @ApiModelProperty(name = "itemDrug", value = "商品剂型 1-粉剂")
    private Long itemDrug;
    /**
     * 1-产品 2-赠品 3-促销物料
     */
    @ApiModelProperty(name = "itemType", value = "1-产品 2-赠品 3-促销物料")
    private Long itemType;
    /**
     * 商品名称
     */
    @ApiModelProperty(name = "name", value = "商品名称")
    private String name;

    @ApiModelProperty(name = "pageNum", value = "页码")
    private Integer pageNum;
    @ApiModelProperty(name = "pageSize", value = "每页条数")
    private Integer pageSize;
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照createTime降序")
    private String orderByDesc = "createTime";

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public Long getItemStatus() {
        return itemStatus;
    }

    public void setItemStatus(Long itemStatus) {
        this.itemStatus = itemStatus;
    }

    public Long getItemDrug() {
        return itemDrug;
    }

    public void setItemDrug(Long itemDrug) {
        this.itemDrug = itemDrug;
    }

    public Long getItemType() {
        return itemType;
    }

    public void setItemType(Long itemType) {
        this.itemType = itemType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<String> getLongCodeList() {
        return longCodeList;
    }

    public void setLongCodeList(List<String> longCodeList) {
        this.longCodeList = longCodeList;
    }
}
