package com.yx.tcbj.center.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @Author: xiuji
 * @Date: 2022/5/11 2:59 PM
 */
@ApiModel(value = "ItemAuthBatchReqDto", description = "批量客户商品授权请求DTO")
public class ItemAuthBatchReqDto {

    @ApiModelProperty(
            name = "targetType",
            value = "目标类型，1-客户，2-店铺",
            required = true
    )
    private Integer targetType;
    @ApiModelProperty(
            name = "targetId",
            value = "目标id(根据target_type)，如客户id，店铺id",
            required = true
    )
    private List<Long> targetIdList;

    @ApiModelProperty(
            name = "businessType",
            value = "业务类型（CATEGORY：类目、BRAND：品牌、SKU：商品sku、BANSKU：禁止的商品sku）",
            required = true
    )
    private String businessType;

    @ApiModelProperty(
            name = "businessIdList",
            value = "业务ID（类目，品牌，商品sku，禁止的商品sku等ID）",
            required = true
    )
    private List<Long> businessIdList;

    public Integer getTargetType() {
        return targetType;
    }

    public void setTargetType(Integer targetType) {
        this.targetType = targetType;
    }

    public List<Long> getTargetIdList() {
        return targetIdList;
    }

    public void setTargetIdList(List<Long> targetIdList) {
        this.targetIdList = targetIdList;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public List<Long> getBusinessIdList() {
        return businessIdList;
    }

    public void setBusinessIdList(List<Long> businessIdList) {
        this.businessIdList = businessIdList;
    }

    @Override
    public String toString() {
        return "ItemAuthBatchReqDto{" +
                "targetType=" + targetType +
                ", targetIdList=" + targetIdList +
                ", businessType='" + businessType + '\'' +
                ", businessIdList=" + businessIdList +
                '}';
    }
}
