package com.dtyunxi.yundt.cube.center.item.api.b2b.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerAuthItemPageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemNumRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 客户指定授权商品查询接口
 */
@FeignClient(name = "${feign.item.name:yundt-cube-center-item}")
@Api(tags = "客户指定授权商品查询接口")
public interface ICustomerAuthItemQueryExtApi {
    
    /**
     * 查看客户已授权商品
     *
     * @param customerAuthItemPageReqDto 商品授权-客户指定授权商品查询条件
     * @return 商品授权-客户指定授权商品分页数据
     */
    @ApiOperation(value = "查看客户已授权商品")
    @PostMapping("/v1/customerAuthItemExt/auth/page")
    RestResponse<PageInfo<CustomerAuthItemRespDto>> queryAuthItemPage(@RequestBody CustomerAuthItemPageReqDto customerAuthItemPageReqDto);
    
    /**
     * 统计客户已授权商品/未授权商品数量
     *
     * @param customerAuthItemPageReqDto 商品授权-客户指定授权商品查询条件
     * @return 客户已授权商品/未授权商品数量
     */
    @ApiOperation(value = "统计客户已授权商品/未授权商品数量")
    @PostMapping("/v1/customerAuthItemExt/auth/num")
    RestResponse<CustomerAuthItemNumRespDto> queryAuthItemNum(@RequestBody CustomerAuthItemPageReqDto customerAuthItemPageReqDto);
    
    /**
     * 根据SKU ID列表查询客户授权商品
     *
     * @param skuIds SKU ID列表
     * @return 客户授权商品列表
     */
    @ApiOperation(value = "根据SKU ID列表查询客户授权商品")
    @PostMapping("/v1/customerAuthItemExt/auth/bySkuIds/{orgId}")
    RestResponse<List<CustomerAuthItemRespDto>> queryAuthItemBySkuIds(@RequestBody List<Long> skuIds, @PathVariable("orgId") Long orgId);
} 