/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemControlPriceDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemControlPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemControlPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemPriceControlReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemPriceLogReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemPriceControlRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemPriceControlService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemPriceLogService;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemPriceControlDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemPriceControlEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemPriceControlServiceImpl
implements IItemPriceControlService {
    @Resource
    private ItemPriceControlDas itemPriceControlDas;
    @Resource
    private IItemPriceLogService iItemPriceLogService;

    @Override
    public Long addItemPriceControl(ItemPriceControlReqDto addReqDto) {
        ItemPriceControlEo itemPriceControlEo = new ItemPriceControlEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemPriceControlEo);
        this.itemPriceControlDas.insert((BaseEo)itemPriceControlEo);
        return itemPriceControlEo.getId();
    }

    @Override
    public void batchAddItemPriceControl(List<ItemPriceControlReqDto> addReqDtoList) {
        ArrayList<ItemPriceControlEo> controlEos = new ArrayList<ItemPriceControlEo>();
        ArrayList<ItemPriceControlEo> modifyEos = new ArrayList<ItemPriceControlEo>();
        if (CollectionUtils.isNotEmpty(addReqDtoList)) {
            for (ItemPriceControlReqDto reqDto : addReqDtoList) {
                List<ItemPriceControlEo> controlEoList = this.getItemPriceControl(reqDto.getType(), reqDto.getCode(), reqDto.getProductCode(), reqDto.getProductUnit());
                if (CollectionUtils.isNotEmpty(controlEoList)) {
                    ItemPriceControlEo controlEo = controlEoList.get(0);
                    controlEo.setType(reqDto.getType());
                    controlEo.setSpecification(reqDto.getProductUnit());
                    controlEo.setPrice(reqDto.getPrice());
                    controlEo.setOrganizationCode(reqDto.getOrganizationCode());
                    controlEo.setOrganizationName(reqDto.getOrganizationName());
                    controlEo.setCode(reqDto.getCode());
                    controlEo.setName(reqDto.getName());
                    controlEo.setProductCode(reqDto.getProductCode());
                    controlEo.setProductName(reqDto.getProductName());
                    modifyEos.add(controlEo);
                    continue;
                }
                ItemPriceControlEo itemPriceControlEo = new ItemPriceControlEo();
                DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)itemPriceControlEo);
                itemPriceControlEo.setType(reqDto.getType());
                itemPriceControlEo.setSpecification(reqDto.getProductUnit());
                itemPriceControlEo.setPrice(reqDto.getPrice());
                controlEos.add(itemPriceControlEo);
            }
        }
        if (CollectionUtils.isNotEmpty(modifyEos)) {
            this.itemPriceControlDas.batchModifyControlPrice(modifyEos);
        }
        if (CollectionUtils.isNotEmpty(controlEos)) {
            this.itemPriceControlDas.insertBatch(controlEos);
        }
    }

    @Override
    public void batchModifyItemPriceControl(ItemControlPriceDto controlPriceDto) {
        if (null == controlPriceDto.getType()) {
            throw new BizException("\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)controlPriceDto.getProductCode())) {
            throw new BizException("\u5546\u54c1\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)controlPriceDto.getProductUnit())) {
            throw new BizException("\u5546\u54c1\u5355\u4f4d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)controlPriceDto.getTrenchDtoList())) {
            throw new BizException("\u5546\u54c1\u4ef7\u683c\u5217\u8868\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<ItemPriceControlEo> controlEos = new ArrayList<ItemPriceControlEo>();
        ArrayList<ItemPriceLogReqDto> priceLogReqDtoList = new ArrayList<ItemPriceLogReqDto>();
        List trenchDtoList = controlPriceDto.getTrenchDtoList();
        for (ItemControlPriceDto.TrenchDto trenchDto : trenchDtoList) {
            List<ItemPriceControlEo> controlEoList;
            if (null != trenchDto.getTogether() && trenchDto.getTogether().booleanValue() && null != trenchDto.getPrice()) {
                controlEoList = this.getItemPriceControl(controlPriceDto.getType(), null, controlPriceDto.getProductCode(), controlPriceDto.getProductUnit());
                ArrayList<ItemPriceLogReqDto> itemPriceLogReqDtoList = new ArrayList<ItemPriceLogReqDto>();
                if (CollectionUtils.isNotEmpty(controlEoList)) {
                    for (ItemPriceControlEo itemPriceControlEo : controlEoList) {
                        ItemPriceLogReqDto itemPriceLogReqDto = new ItemPriceLogReqDto();
                        itemPriceLogReqDto.setCode(trenchDto.getCode());
                        itemPriceLogReqDto.setName(trenchDto.getName());
                        itemPriceLogReqDto.setProductCode(controlPriceDto.getProductCode());
                        itemPriceLogReqDto.setProductUnit(controlPriceDto.getProductUnit());
                        itemPriceLogReqDto.setAfterPrice(itemPriceControlEo.getPrice());
                        itemPriceLogReqDto.setCurrentPrice(trenchDto.getPrice());
                        itemPriceLogReqDto.setTogether(trenchDto.getTogether());
                        itemPriceLogReqDto.setRemark(trenchDto.getRemark());
                        itemPriceLogReqDtoList.add(itemPriceLogReqDto);
                        itemPriceControlEo.setPrice(trenchDto.getPrice());
                        itemPriceControlEo.setExtension(trenchDto.getRemark());
                    }
                }
                controlEos.addAll(controlEoList);
                priceLogReqDtoList.addAll(itemPriceLogReqDtoList);
                continue;
            }
            controlEoList = this.getItemPriceControl(controlPriceDto.getType(), trenchDto.getCode(), controlPriceDto.getProductCode(), controlPriceDto.getProductUnit());
            ItemPriceControlEo controlEo = controlEoList.get(0);
            ItemPriceLogReqDto itemPriceLogReqDto = new ItemPriceLogReqDto();
            itemPriceLogReqDto.setCode(trenchDto.getCode());
            itemPriceLogReqDto.setName(trenchDto.getName());
            itemPriceLogReqDto.setProductUnit(controlPriceDto.getProductUnit());
            itemPriceLogReqDto.setProductCode(controlPriceDto.getProductCode());
            itemPriceLogReqDto.setTogether(trenchDto.getTogether());
            itemPriceLogReqDto.setAfterPrice(controlEo.getPrice());
            itemPriceLogReqDto.setCurrentPrice(trenchDto.getPrice());
            itemPriceLogReqDto.setRemark(trenchDto.getRemark());
            priceLogReqDtoList.add(itemPriceLogReqDto);
            controlEo.setPrice(trenchDto.getPrice());
            controlEo.setExtension(trenchDto.getRemark());
            controlEos.add(controlEo);
        }
        if (CollectionUtils.isNotEmpty(controlEos)) {
            this.itemPriceControlDas.batchModifyControlPrice(controlEos);
        }
        if (CollectionUtils.isNotEmpty(priceLogReqDtoList)) {
            this.iItemPriceLogService.batchAddItemPriceLog(priceLogReqDtoList);
        }
    }

    @Override
    public void modifyItemPriceControl(ItemPriceControlReqDto modifyReqDto) {
        ItemPriceControlEo itemPriceControlEo = new ItemPriceControlEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemPriceControlEo);
        this.itemPriceControlDas.updateSelective((BaseEo)itemPriceControlEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemPriceControl(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemPriceControlDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ItemPriceControlRespDto queryById(Long id) {
        ItemPriceControlEo itemPriceControlEo = (ItemPriceControlEo)this.itemPriceControlDas.selectByPrimaryKey(id);
        ItemPriceControlRespDto itemPriceControlRespDto = new ItemPriceControlRespDto();
        DtoHelper.eo2Dto((BaseEo)itemPriceControlEo, (BaseVo)itemPriceControlRespDto);
        return itemPriceControlRespDto;
    }

    @Override
    public PageInfo<ItemPriceControlRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemPriceControlReqDto itemPriceControlReqDto = (ItemPriceControlReqDto)JSON.parseObject((String)filter, ItemPriceControlReqDto.class);
        ItemPriceControlEo itemPriceControlEo = new ItemPriceControlEo();
        DtoHelper.dto2Eo((BaseVo)itemPriceControlReqDto, (BaseEo)itemPriceControlEo);
        PageInfo eoPageInfo = this.itemPriceControlDas.selectPage((BaseEo)itemPriceControlEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemPriceControlRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ItemPriceControlRespDto> queryByPage(ItemControlPriceReqDto reqDto) {
        if (Objects.isNull(reqDto.getPageNum()) || Objects.isNull(reqDto.getPageSize())) {
            throw new BizException("\u5206\u9875\u9875\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper wrapper = new QueryWrapper();
        if (null != reqDto.getType()) {
            wrapper.eq((Object)"type", (Object)reqDto.getType());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCode())) {
            wrapper.eq((Object)"code", (Object)reqDto.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getName())) {
            wrapper.like((Object)"name", (Object)("%" + reqDto.getName() + "%"));
        }
        if (Objects.nonNull(reqDto.getProductCode())) {
            wrapper.eq((Object)"product_code", (Object)reqDto.getProductCode());
        }
        if (Objects.nonNull(reqDto.getProductName())) {
            wrapper.like((Object)"product_name", (Object)("%" + reqDto.getProductName() + "%"));
        }
        if (Objects.nonNull(reqDto.getProductUnit())) {
            wrapper.eq((Object)"product_unit", (Object)reqDto.getProductUnit());
        }
        wrapper.eq((Object)"dr", (Object)0);
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        List selectList = this.itemPriceControlDas.queryListByPage(wrapper);
        PageInfo selectPage = new PageInfo(selectList);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList csItemRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)selectList, (Collection)csItemRespDtos, ItemPriceControlRespDto.class);
        pageInfo.setList((List)csItemRespDtos);
        return pageInfo;
    }

    @Override
    public List<ItemPriceControlRespDto> queryItemPriceByCode(ItemControlPriceQueryReqDto reqDto) {
        QueryWrapper wrapper = new QueryWrapper();
        if (null != reqDto.getType()) {
            wrapper.eq((Object)"type", (Object)reqDto.getType());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCode())) {
            wrapper.eq((Object)"code", (Object)reqDto.getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getProductCode())) {
            wrapper.eq((Object)"product_code", (Object)reqDto.getProductCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getProductCodeList())) {
            wrapper.in((Object)"product_code", (Collection)reqDto.getProductCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getProductUnitList())) {
            wrapper.in((Object)"product_unit", (Collection)reqDto.getProductUnitList());
        }
        List priceControlEoList = this.itemPriceControlDas.queryListByCode(wrapper);
        ArrayList<ItemPriceControlRespDto> respDtoList = new ArrayList<ItemPriceControlRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)priceControlEoList)) {
            Map<String, List<ItemPriceControlEo>> priceGroup = priceControlEoList.stream().collect(Collectors.groupingBy(ItemPriceControlEo2 -> ItemPriceControlEo2.getProductCode()));
            reqDto.getProductCodeList().forEach(product -> {
                List priceControlEos = (List)priceGroup.get(product);
                if (CollectionUtils.isNotEmpty((Collection)priceControlEos)) {
                    respDtoList.addAll(this.setListData(priceControlEos));
                }
            });
        }
        return respDtoList;
    }

    private ItemPriceControlRespDto setData(ItemPriceControlEo controlEo) {
        ItemPriceControlRespDto respDto = new ItemPriceControlRespDto();
        respDto.setId(controlEo.getId());
        respDto.setType(Long.valueOf(controlEo.getType().intValue()));
        respDto.setCode(controlEo.getCode());
        respDto.setName(controlEo.getName());
        respDto.setProductCode(controlEo.getProductCode());
        respDto.setProductName(controlEo.getProductName());
        respDto.setPrice(controlEo.getPrice());
        respDto.setProductUnit(controlEo.getProductUnit());
        return respDto;
    }

    private List<ItemPriceControlRespDto> setListData(List<ItemPriceControlEo> controlEoList) {
        ArrayList<ItemPriceControlRespDto> respDtoList = new ArrayList<ItemPriceControlRespDto>();
        if (CollectionUtils.isNotEmpty(controlEoList)) {
            for (ItemPriceControlEo controlEo : controlEoList) {
                ItemPriceControlRespDto respDto = new ItemPriceControlRespDto();
                respDto.setId(controlEo.getId());
                respDto.setType(Long.valueOf(controlEo.getType().intValue()));
                respDto.setCode(controlEo.getCode());
                respDto.setName(controlEo.getName());
                respDto.setProductCode(controlEo.getProductCode());
                respDto.setProductName(controlEo.getProductName());
                respDto.setPrice(controlEo.getPrice());
                respDto.setProductUnit(controlEo.getProductUnit());
                respDtoList.add(respDto);
            }
        }
        return respDtoList;
    }

    private List<ItemPriceControlEo> getItemPriceControl(Integer type, String code, String productCode, String productUnit) {
        ItemPriceControlEo queryEo = new ItemPriceControlEo();
        if (null != type) {
            queryEo.setType(type);
        }
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            queryEo.setCode(code);
        }
        if (StringUtils.isNotEmpty((CharSequence)productCode)) {
            queryEo.setProductCode(productCode);
        }
        if (StringUtils.isNotEmpty((CharSequence)productUnit)) {
            queryEo.setProductUnit(productUnit);
        }
        return this.itemPriceControlDas.select((BaseEo)queryEo);
    }
}

