/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.query.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailBaseInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemPricePageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemShopQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemSkuExcludeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemPricePageRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemSkuExcludeRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.SpecsPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryItemService;
import com.dtyunxi.yundt.cube.center.item.biz.service.query.IItemCenterQueryService;
import com.dtyunxi.yundt.cube.center.item.dao.ItemExtVo;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.ItemAuthDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemAttributesDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemExtDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.SellerSkuPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.ItemAuthEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemPriceEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdDirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdDirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemPriceEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ItemCenterQueryServiceImpl
implements IItemCenterQueryService {
    private static final Logger log = LoggerFactory.getLogger(ItemCenterQueryServiceImpl.class);
    @Resource
    private ItemDas itemDas;
    @Resource
    private DirDas dirDas;
    @Resource
    private ItemAttributesDas itemAttributesDas;
    @Resource
    private SellerSkuPriceDas sellerSkuPriceDas;
    @Resource
    private IDirectoryItemService directoryItemService;
    @Resource
    private DirItemRelationDas dirItemRelationDas;
    @Resource
    private IDirService dirService;
    @Resource
    private ItemPriceDas itemPriceDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemAuthDas itemAuthDas;
    @Resource
    private ShelfDas shelfDas;
    @Resource
    private ItemMediasDas itemMediasDas;
    @Resource
    private ItemExtDas itemExtDas;

    @Override
    public ItemRespDto queryByLongCode(String longCode) {
        ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"long_code", (Object)longCode)).one();
        ItemRespDto itemRespDto = new ItemRespDto();
        DtoHelper.eo2Dto((BaseEo)itemEo, (BaseVo)itemRespDto);
        return itemRespDto;
    }

    @Override
    public List<ItemRespDto> queryByLongCodeList(List<String> longCodeList) {
        List list = ((ExtQueryChainWrapper)this.itemDas.filter().in((Object)"long_code", longCodeList)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<ItemRespDto>(0);
        }
        ArrayList<ItemRespDto> itemRespDtoList = new ArrayList<ItemRespDto>();
        DtoHelper.eoList2DtoList((Collection)list, itemRespDtoList, ItemRespDto.class);
        return itemRespDtoList;
    }

    @Override
    public PageInfo<ItemPricePageRespDto> queryPriceByPage(ItemPricePageReqDto filter) {
        if (CollectionUtils.isNotEmpty((Collection)filter.getDirIds())) {
            List rootIds;
            List rootEos;
            DirEo rootEo;
            HashSet dirIds = new HashSet();
            if (filter.getDirIds().size() == 2) {
                DirEo parentEo = new DirEo();
                parentEo.setId((Long)filter.getDirIds().get(1));
                List parentEoEos = this.dirDas.select((BaseEo)parentEo);
                if (CollectionUtils.isNotEmpty((Collection)parentEoEos)) {
                    List parentIds = parentEoEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                    dirIds.addAll(parentIds);
                }
            } else if (filter.getDirIds().size() == 1) {
                rootEo = new DirEo();
                rootEo.setParentId((Long)filter.getDirIds().get(0));
                rootEos = this.dirDas.select((BaseEo)rootEo);
                if (CollectionUtils.isNotEmpty((Collection)rootEos)) {
                    rootIds = rootEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                    dirIds.addAll(rootIds);
                }
            } else {
                rootEo = new DirEo();
                rootEo.setRootId((Long)filter.getDirIds().get(0));
                rootEos = this.dirDas.select((BaseEo)rootEo);
                if (CollectionUtils.isNotEmpty((Collection)rootEos)) {
                    rootIds = rootEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                    dirIds.addAll(rootIds);
                }
                DirEo parentEo = new DirEo();
                parentEo.setParentId((Long)filter.getDirIds().get(0));
                List parentEoEos = this.dirDas.select((BaseEo)parentEo);
                if (CollectionUtils.isNotEmpty((Collection)parentEoEos)) {
                    List parentIds = parentEoEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                    dirIds.addAll(parentIds);
                }
            }
            filter.getDirIds().addAll(dirIds);
        }
        if (Objects.isNull(filter.getPageFlag()) || filter.getPageFlag().equals(0)) {
            PageHelper.startPage((int)filter.getPageNum(), (int)filter.getPageSize());
        }
        PageInfo eoPageInfo = this.sellerSkuPriceDas.queryPriceByPage(filter);
        log.info("========>:{}", (Object)eoPageInfo);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemPricePageRespDto.class);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            List<Long> dirIds = dtoList.stream().map(ItemPricePageRespDto::getDirId).distinct().collect(Collectors.toList());
            List<Object> dirLevels = new ArrayList();
            if (CollectionUtils.isNotEmpty(dirIds)) {
                dirLevels = this.directoryItemService.queryDirLevels(dirIds);
            }
            for (ItemPricePageRespDto dto : dtoList) {
                ArrayList<SpecsPriceRespDto> specsPriceRespDtos = new ArrayList<SpecsPriceRespDto>();
                if (StringUtils.isNotEmpty((String)dto.getSkuIds())) {
                    List<String> skuIdList = Arrays.asList(dto.getSkuIds().split(","));
                    List<String> list = Arrays.asList(dto.getAttr().split(","));
                    if (dto.getPrice() != null && dto.getSupplyPrice() != null) {
                        List<String> priceList = Arrays.asList(dto.getPrice().split(","));
                        List<String> supplyPriceList = Arrays.asList(dto.getSupplyPrice().split(","));
                        if (skuIdList.size() == list.size() && skuIdList.size() == priceList.size() && skuIdList.size() == supplyPriceList.size()) {
                            for (int i = 0; i < skuIdList.size(); ++i) {
                                SpecsPriceRespDto specsPriceRespDto = new SpecsPriceRespDto();
                                specsPriceRespDto.setSkuId(Long.valueOf(skuIdList.get(i)));
                                specsPriceRespDto.setSpecs(list.get(i));
                                specsPriceRespDto.setRetailPrice(new BigDecimal(priceList.get(i)));
                                specsPriceRespDto.setSupplyPrice(new BigDecimal(supplyPriceList.get(i)));
                                specsPriceRespDtos.add(specsPriceRespDto);
                            }
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty(specsPriceRespDtos)) {
                    TreeSet<SpecsPriceRespDto> specs = new TreeSet<SpecsPriceRespDto>((o1, o2) -> o1.getSkuId().compareTo(o2.getSkuId()));
                    specs.addAll(specsPriceRespDtos);
                    ArrayList arrayList = new ArrayList(specs);
                    dto.setSpecsPriceRespDtos(arrayList);
                } else {
                    dto.setSpecsPriceRespDtos(specsPriceRespDtos);
                }
                if (!Objects.nonNull(dto.getDirId())) continue;
                for (List list : dirLevels) {
                    if (!dto.getDirId().equals(((DirectoryItemRespDto)list.get(list.size() - 1)).getId())) continue;
                    ArrayList<String> dirName = new ArrayList<String>();
                    dto.setDirectoryItemRespDtos(list);
                    for (int i = 0; i < list.size(); ++i) {
                        if (i <= 0) continue;
                        dirName.add(((DirectoryItemRespDto)list.get(i)).getName());
                    }
                    dto.setDirNameList(dirName);
                    log.info("dirName===>:{}", dirName);
                }
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ItemSkuExcludeRespDto> findItemSkuExclude(ItemSkuExcludeReqDto itemSkuExcludeReqDto) {
        List itemPriceEos;
        if (CollectionUtils.isNotEmpty((Collection)itemSkuExcludeReqDto.getDirIds())) {
            List<Long> dirIdList = this.dirService.getLinkAndChildDirIdList(itemSkuExcludeReqDto.getDirIds(), itemSkuExcludeReqDto.getInstanceId(), itemSkuExcludeReqDto.getTenantId());
            if (CollectionUtils.isEmpty(dirIdList)) {
                return null;
            }
            itemSkuExcludeReqDto.setDirIds(dirIdList);
        }
        if (CollectionUtils.isNotEmpty((Collection)itemSkuExcludeReqDto.getBackDirIds())) {
            List<Long> backDirIds = this.dirService.getLinkAndChildDirIdList(itemSkuExcludeReqDto.getBackDirIds(), itemSkuExcludeReqDto.getInstanceId(), itemSkuExcludeReqDto.getTenantId());
            if (CollectionUtils.isEmpty(backDirIds)) {
                return null;
            }
            itemSkuExcludeReqDto.setBackDirIds(backDirIds);
        }
        List<ItemExtVo> itemEoList = this.pageItemSkuExclude(itemSkuExcludeReqDto);
        ArrayList<ItemSkuExcludeRespDto> managementBlockRespDtos = new ArrayList<ItemSkuExcludeRespDto>();
        Set itemIds = itemEoList.stream().map(ItemVo::getItemId).collect(Collectors.toSet());
        List dirItemRelationEos = this.dirItemRelationDas.selectByItemIdsAndDirType((List)Lists.newArrayList(itemIds), "front");
        Map groupDirItemEo = dirItemRelationEos.stream().collect(Collectors.groupingBy(StdDirItemRelationEo::getItemId, Collectors.toList()));
        HashSet allFrontDirIdSet = Sets.newHashSet();
        HashMap<Long, ArrayList> frontDirIdsMap = new HashMap<Long, ArrayList>();
        for (Map.Entry groupDirItemEntry : groupDirItemEo.entrySet()) {
            Long key = groupDirItemEntry.getKey();
            itemPriceEos = groupDirItemEntry.getValue();
            HashSet frontDirIdSet = Sets.newHashSet();
            for (DirItemRelationEo dirItemRelationEo : itemPriceEos) {
                frontDirIdSet.add(dirItemRelationEo.getDirId());
            }
            allFrontDirIdSet.addAll(frontDirIdSet);
            frontDirIdsMap.put(key, Lists.newArrayList((Iterable)frontDirIdSet));
        }
        List frontDirEos = this.dirDas.selectByIds((List)Lists.newArrayList((Iterable)allFrontDirIdSet));
        Map<Long, String> frontDirNameMap = frontDirEos.stream().collect(Collectors.toMap(BaseEo::getId, StdDirEo::getName, (e1, e2) -> e1));
        List skuIds = itemEoList.stream().filter(bean -> null != bean.getSkuId()).map(ItemVo::getSkuId).collect(Collectors.toList());
        itemPriceEos = this.itemPriceDas.selectBySkuIds(skuIds);
        Map group = itemPriceEos.stream().collect(Collectors.groupingBy(StdItemPriceEo::getSkuId, Collectors.toList()));
        List collectDirId = itemEoList.stream().filter(bean -> null != bean.getDirId()).map(ItemVo::getDirId).collect(Collectors.toList());
        List dirEos = this.dirDas.selectByIds(collectDirId);
        Map groupDirEo = dirEos.stream().collect(Collectors.groupingBy(BaseEo::getId, Collectors.toList()));
        Iterator<ItemExtVo> var21 = itemEoList.iterator();
        while (true) {
            List frontDirIds;
            if (!var21.hasNext()) {
                PageInfo result = new PageInfo();
                CubeBeanUtils.copyProperties((Object)result, (Object)new PageInfo(itemEoList), (String[])new String[]{"list", "navigatepageNums"});
                result.setList(managementBlockRespDtos);
                return result;
            }
            ItemExtVo itemVo = var21.next();
            ItemSkuExcludeRespDto newOne = new ItemSkuExcludeRespDto();
            BeanUtils.copyProperties((Object)itemVo, (Object)newOne);
            newOne.setPath(this.getMainPic(itemVo.getItemId()));
            newOne.setShopId(itemVo.getShopId());
            managementBlockRespDtos.add(newOne);
            List itemPriceEos1 = group.get(itemVo.getSkuId());
            List selectDirEo = groupDirEo.get(itemVo.getDirId());
            if (!CollectionUtils.isEmpty(itemPriceEos1)) {
                Map collect = itemPriceEos1.stream().collect(Collectors.groupingBy(StdItemPriceEo::getPriceType, Collectors.toList()));
                ShelfEo selectItem = new ShelfEo();
                selectItem.setOrderByDesc("updateTime");
                selectItem.setSkuId(itemVo.getSkuId());
                selectItem.setStatus(Integer.valueOf(1));
                selectItem.setShopId(itemSkuExcludeReqDto.getShopId());
                selectItem.setDr(0);
                List shelfEos = this.shelfDas.selectList((BaseEo)selectItem);
                List price = collect.get("PRICE");
                newOne.setRetailPrice(CollectionUtils.isEmpty((Collection)shelfEos) ? null : ((ShelfEo)shelfEos.get(0)).getPrice());
                newOne.setSellPrice(CollectionUtils.isEmpty(price) ? null : ((ItemPriceEo)price.get(0)).getPrice());
            }
            if (!CollectionUtils.isEmpty(selectDirEo)) {
                newOne.setDirName(((DirEo)selectDirEo.get(0)).getName());
            }
            if (!CollectionUtils.isNotEmpty((Collection)(frontDirIds = (List)frontDirIdsMap.get(itemVo.getItemId())))) continue;
            newOne.setFrontDirIds(frontDirIds);
            ArrayList frontDirNames = Lists.newArrayList();
            for (Long frontDirId : frontDirIds) {
                String frontDirName = frontDirNameMap.get(frontDirId);
                frontDirNames.add(frontDirName);
            }
            newOne.setFrontDirNames((List)frontDirNames);
        }
    }

    @Override
    public List<ItemDetailBaseInfoRespDto> queryShopItemList(ItemShopQueryReqDto itemShopQueryReqDto) {
        ArrayList itemDetailBaseInfoRespDtoList = Lists.newArrayList();
        List itemCodes = itemShopQueryReqDto.getItemCodes();
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)itemCodes), (String)"100003", (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        itemCodes.removeAll(Collections.singleton(null));
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)itemCodes), (String)"100004", (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ItemEo itemEo = new ItemEo();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper((Object)itemEo).in(StdItemEo::getCode, (Collection)itemCodes);
        List itemEoList = this.itemDas.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)itemEoList)) {
            return itemDetailBaseInfoRespDtoList;
        }
        List itemIdList = itemEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        ItemSkuEo itemSkuEo = new ItemSkuEo();
        LambdaQueryWrapper skuQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper((Object)itemSkuEo).in(StdItemSkuEo::getItemId, itemIdList);
        List itemSkuEoList = this.itemSkuDas.getMapper().selectList((Wrapper)skuQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)itemSkuEoList)) {
            return itemDetailBaseInfoRespDtoList;
        }
        List skuIdList = itemSkuEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        ItemAuthEo itemAuthEo = new ItemAuthEo();
        LambdaQueryWrapper skuAuthQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper((Object)itemAuthEo).in(ItemAuthEo::getBusinessId, skuIdList)).eq(ItemAuthEo::getTargetId, (Object)itemShopQueryReqDto.getShopId())).eq(ItemAuthEo::getTargetType, (Object)itemShopQueryReqDto.getTargetType());
        List itemAuthEoList = this.itemAuthDas.getMapper().selectList((Wrapper)skuAuthQueryWrapper);
        ItemMediasEo itemMediasEo = new ItemMediasEo();
        LambdaQueryWrapper itemMediasEoQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper((Object)itemMediasEo).in(StdItemMediasEo::getItemId, itemIdList);
        List itemMediasEoList = this.itemMediasDas.getMapper().selectList((Wrapper)itemMediasEoQueryWrapper);
        Map<Long, List<ItemMediasRespDto>> itemMediaListMap = null;
        if (CollectionUtils.isNotEmpty((Collection)itemMediasEoList)) {
            ArrayList itemMediasList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)itemMediasEoList, (Collection)itemMediasList, ItemMediasRespDto.class);
            itemMediaListMap = itemMediasList.stream().collect(Collectors.groupingBy(ItemMediasRespDto::getItemId));
        }
        List businessIdList = itemAuthEoList.stream().map(ItemAuthEo::getBusinessId).collect(Collectors.toList());
        Map itemEoMap = itemEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        Map itemSkuMap = itemSkuEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        Map<Long, List<ItemMediasRespDto>> finalItemMediaListMap = itemMediaListMap;
        businessIdList.stream().distinct().forEach(businessId -> {
            ItemEo item;
            ItemSkuEo skuEo = (ItemSkuEo)itemSkuMap.get(businessId);
            if (skuEo != null && (item = (ItemEo)itemEoMap.get(skuEo.getItemId())) != null) {
                ItemDetailBaseInfoRespDto itemDetailBaseInfoRespDto = new ItemDetailBaseInfoRespDto();
                BeanUtils.copyProperties((Object)item, (Object)itemDetailBaseInfoRespDto);
                itemDetailBaseInfoRespDto.setAttrs(skuEo.getAttr());
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("subType", item.getSubType());
                itemDetailBaseInfoRespDto.setExtFields(map);
                if (finalItemMediaListMap != null) {
                    itemDetailBaseInfoRespDto.setItemMediasList((List)finalItemMediaListMap.get(item.getId()));
                }
                ArrayList itemSkuList = Lists.newArrayList();
                ItemSkuInfoRespDto itemSkuInfoRespDto = new ItemSkuInfoRespDto();
                BeanUtils.copyProperties((Object)skuEo, (Object)itemSkuInfoRespDto);
                itemSkuList.add(itemSkuInfoRespDto);
                itemDetailBaseInfoRespDto.setItemSkuList((List)itemSkuList);
                itemDetailBaseInfoRespDtoList.add(itemDetailBaseInfoRespDto);
            }
        });
        return itemDetailBaseInfoRespDtoList;
    }

    private List<ItemExtVo> pageItemSkuExclude(ItemSkuExcludeReqDto itemSkuExcludeReqDto) {
        PageHelper.startPage((int)(itemSkuExcludeReqDto.getPageNum() == null ? 1 : itemSkuExcludeReqDto.getPageNum()), (int)(itemSkuExcludeReqDto.getPageSize() == null ? 10 : itemSkuExcludeReqDto.getPageSize()));
        return this.itemExtDas.pageItemSkuExclude(itemSkuExcludeReqDto);
    }

    private String getMainPic(Long itemId) {
        List itemMediasEoList = this.itemMediasDas.selectByItemId(itemId);
        return CollectionUtils.isNotEmpty((Collection)itemMediasEoList) ? ((ItemMediasEo)itemMediasEoList.get(0)).getPath1() : null;
    }
}

