/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.TagReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.TagRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemTagQueryApi;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemTagService;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.QueryParamUtils;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.TagEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="itemTagQueryApi")
public class ItemTagQueryApiImpl
implements IItemTagQueryApi {
    @Resource
    private IItemTagService itemTagService;

    public RestResponse<PageInfo<TagRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        TagReqDto dto = new TagReqDto();
        TagEo tagEo = TagEo.newInstance((Map)dto.getExtFields());
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            dto = (TagReqDto)JSON.parseObject((String)filter, TagReqDto.class);
        }
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)tagEo);
        QueryParamUtils.fillQueryCreateStartTime(dto.getCreateBeginTime(), (BaseEo)tagEo);
        QueryParamUtils.fillQueryCreateEndTime(dto.getCreateEndTime(), (BaseEo)tagEo);
        QueryParamUtils.fillQueryUpdateStartTime(dto.getUpdateBeginTime(), (BaseEo)tagEo);
        QueryParamUtils.fillQueryUpdateEndTime(dto.getUpdateEndTime(), (BaseEo)tagEo);
        QueryParamUtils.columnLike((BaseEo)tagEo, "keywords", tagEo.getKeywords());
        PageInfo<TagEo> tagEoPageInfo = this.itemTagService.queryByPage(tagEo, pageNum, pageSize);
        PageInfo responseTagDtoPageInfo = new PageInfo();
        ArrayList tagRespDtos = new ArrayList();
        CubeBeanUtils.copyProperties((Object)responseTagDtoPageInfo, tagEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        DtoHelper.eoList2DtoList((Collection)tagEoPageInfo.getList(), tagRespDtos, TagRespDto.class);
        responseTagDtoPageInfo.setList(tagRespDtos);
        return new RestResponse((Object)responseTagDtoPageInfo);
    }

    public RestResponse<TagRespDto> queryById(Long id) {
        TagEo tagEo = this.itemTagService.queryById(id);
        if (null == tagEo) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_TAG.getCode(), ItemExceptionCode.NON_EXIST_TAG.getMsg());
        }
        TagRespDto tagRespDto = new TagRespDto();
        DtoHelper.eo2Dto((BaseEo)tagEo, (BaseVo)tagRespDto);
        return new RestResponse((Object)tagRespDto);
    }

    public RestResponse<List<TagRespDto>> queryItemTagByItemId(Long itemId) {
        List<TagEo> tagEoList = this.itemTagService.queryItemTagByItemId(itemId);
        if (CollectionUtils.isEmpty(tagEoList)) {
            return new RestResponse((Object)Lists.newArrayList());
        }
        ArrayList tagRespDtos = new ArrayList();
        DtoHelper.eoList2DtoList(tagEoList, tagRespDtos, TagRespDto.class);
        return new RestResponse(tagRespDtos);
    }
}

