/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.constants.ItemUnit;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemConversionRecordReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemUnitConversionRecordReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemUnitRecordReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemConversionRecordRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemUnitConversionDataRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemUnitConversionRecordRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemUnitConversionRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.OmsItemDetailDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemExtendService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemUnitConversionRecordService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemUnitConversionService;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemUnitConversionRecordDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemUnitConversionRecordEo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemUnitConversionRecordServiceImpl
implements IItemUnitConversionRecordService {
    private static Logger logger = LoggerFactory.getLogger(ItemUnitConversionRecordServiceImpl.class);
    @Resource
    private IItemService iItemService;
    @Resource(name="${project.domain.prefix:tcbj}ItemExtendService")
    private IItemExtendService iItemExtendService;
    @Resource
    private IItemUnitConversionService iItemUnitConversionService;
    @Resource
    private ItemUnitConversionRecordDas itemUnitConversionRecordDas;

    @Override
    public Long addItemUnitConversionRecord(ItemUnitConversionRecordReqDto addReqDto) {
        ItemUnitConversionRecordEo itemUnitConversionRecordEo = new ItemUnitConversionRecordEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemUnitConversionRecordEo);
        this.itemUnitConversionRecordDas.insert((BaseEo)itemUnitConversionRecordEo);
        return itemUnitConversionRecordEo.getId();
    }

    @Override
    public void modifyItemUnitConversionRecord(ItemUnitConversionRecordReqDto modifyReqDto) {
        ItemUnitConversionRecordEo itemUnitConversionRecordEo = new ItemUnitConversionRecordEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemUnitConversionRecordEo);
        this.itemUnitConversionRecordDas.updateSelective((BaseEo)itemUnitConversionRecordEo);
    }

    private void batchCreateItemUnitConversionRecord(List<ItemUnitConversionRecordRespDto> respDtoList) {
        ArrayList<ItemUnitConversionRecordEo> recordEoList = new ArrayList<ItemUnitConversionRecordEo>();
        if (CollectionUtils.isNotEmpty(respDtoList)) {
            for (ItemUnitConversionRecordRespDto recordRespDto : respDtoList) {
                ItemUnitConversionRecordEo itemUnitConversionRecordEo = new ItemUnitConversionRecordEo();
                DtoHelper.dto2Eo((BaseVo)recordRespDto, (BaseEo)itemUnitConversionRecordEo);
                recordEoList.add(itemUnitConversionRecordEo);
            }
        }
        if (CollectionUtils.isNotEmpty(recordEoList)) {
            this.itemUnitConversionRecordDas.insertBatch(recordEoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemUnitConversionRecord(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemUnitConversionRecordDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ItemUnitConversionRecordRespDto queryById(Long id) {
        ItemUnitConversionRecordEo itemUnitConversionRecordEo = (ItemUnitConversionRecordEo)this.itemUnitConversionRecordDas.selectByPrimaryKey(id);
        ItemUnitConversionRecordRespDto itemUnitConversionRecordRespDto = new ItemUnitConversionRecordRespDto();
        DtoHelper.eo2Dto((BaseEo)itemUnitConversionRecordEo, (BaseVo)itemUnitConversionRecordRespDto);
        return itemUnitConversionRecordRespDto;
    }

    @Override
    public PageInfo<ItemUnitConversionRecordRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemUnitConversionRecordReqDto itemUnitConversionRecordReqDto = (ItemUnitConversionRecordReqDto)JSON.parseObject((String)filter, ItemUnitConversionRecordReqDto.class);
        ItemUnitConversionRecordEo itemUnitConversionRecordEo = new ItemUnitConversionRecordEo();
        DtoHelper.dto2Eo((BaseVo)itemUnitConversionRecordReqDto, (BaseEo)itemUnitConversionRecordEo);
        PageInfo eoPageInfo = this.itemUnitConversionRecordDas.selectPage((BaseEo)itemUnitConversionRecordEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemUnitConversionRecordRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ItemUnitConversionDataRespDto> selectItemUnitConversion(List<ItemUnitRecordReqDto> reqDtoList) {
        if (CollectionUtils.isNotEmpty(reqDtoList)) {
            this.batchDeleteById(reqDtoList);
            List<String> itemCodeList = reqDtoList.stream().map(ItemUnitRecordReqDto::getItemCode).distinct().collect(Collectors.toList());
            List<OmsItemDetailDto> detailDtoList = this.iItemExtendService.queryItemDetailByListCode(itemCodeList);
            if (CollectionUtils.isNotEmpty(detailDtoList)) {
                Map<String, List<OmsItemDetailDto>> itemDetailMap = detailDtoList.stream().collect(Collectors.groupingBy(OmsItemDetailDto::getCode));
                reqDtoList.forEach(reqDto -> reqDto.setToItemUnit(((OmsItemDetailDto)((List)itemDetailMap.get(reqDto.getItemCode())).get(0)).getBaseUnit()));
                List<ItemUnitConversionRecordRespDto> respDtoList = this.selectItemData(reqDtoList);
                if (CollectionUtils.isNotEmpty(respDtoList)) {
                    this.batchCreateItemUnitConversionRecord(respDtoList);
                }
                return this.selectItemUnitData(respDtoList);
            }
        }
        return null;
    }

    @Override
    public List<ItemUnitConversionRecordRespDto> selectItemOriginalUnit(List<ItemUnitRecordReqDto> reqDtoList) {
        if (CollectionUtils.isNotEmpty(reqDtoList)) {
            List<String> itemCodeList = reqDtoList.stream().map(ItemUnitRecordReqDto::getItemCode).distinct().collect(Collectors.toList());
            List<OmsItemDetailDto> detailDtoList = this.iItemExtendService.queryItemDetailByListCode(itemCodeList);
            Map<String, List<OmsItemDetailDto>> itemDetailMap = detailDtoList.stream().collect(Collectors.groupingBy(OmsItemDetailDto::getCode));
            List<ItemUnitConversionRecordEo> recordEoList = this.selectList(reqDtoList);
            Map<String, List<ItemUnitConversionRecordEo>> recordMap = recordEoList.stream().collect(Collectors.groupingBy(ItemUnitConversionRecordEo2 -> ItemUnitConversionRecordEo2.getType() + "_" + ItemUnitConversionRecordEo2.getDocumentCode() + "_" + ItemUnitConversionRecordEo2.getItemCode()));
            reqDtoList.forEach(reqDto -> {
                reqDto.setItemUnit(((OmsItemDetailDto)((List)itemDetailMap.get(reqDto.getItemCode())).get(0)).getBaseUnit());
                StringBuilder key = new StringBuilder();
                if (StringUtils.isNotEmpty((String)reqDto.getType())) {
                    key.append(reqDto.getType());
                }
                if (StringUtils.isNotEmpty((String)reqDto.getDocumentCode())) {
                    key.append("_" + reqDto.getDocumentCode());
                }
                if (StringUtils.isNotEmpty((String)reqDto.getItemCode())) {
                    key.append("_" + reqDto.getItemCode());
                }
                if (null != ((List)recordMap.get(key.toString())).get(0)) {
                    reqDto.setToItemUnit(((ItemUnitConversionRecordEo)((List)recordMap.get(key.toString())).get(0)).getItemUnit());
                }
            });
            return this.selectItemData(reqDtoList);
        }
        return null;
    }

    @Override
    public List<ItemUnitConversionRecordRespDto> selectItemUnitByCode(List<ItemUnitRecordReqDto> reqDtoList) {
        if (CollectionUtils.isNotEmpty(reqDtoList)) {
            for (ItemUnitRecordReqDto reqDto : reqDtoList) {
                if (StringUtils.isEmpty((String)reqDto.getItemCode())) {
                    throw new BizException("\u5546\u54c1code\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == reqDto.getItemNum() || reqDto.getItemNum().compareTo(BigDecimal.ZERO) < 0) {
                    throw new BizException("\u5546\u54c1\u6570\u91cf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((String)reqDto.getItemUnit())) {
                    throw new BizException("\u8f6c\u6362\u5355\u4f4d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!StringUtils.isEmpty((String)reqDto.getToItemUnit())) continue;
                throw new BizException("\u8f6c\u6362\u5355\u4f4d\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return this.selectItemData(reqDtoList);
        }
        return null;
    }

    @Override
    public List<ItemUnitConversionRecordRespDto> selectItemUnitByParams(ItemUnitRecordReqDto reqDto) {
        List recordEoList;
        ItemUnitConversionRecordEo recordEo = new ItemUnitConversionRecordEo();
        if (StringUtils.isNotEmpty((String)reqDto.getType())) {
            recordEo.setType(reqDto.getType());
        }
        if (StringUtils.isNotEmpty((String)reqDto.getDocumentCode())) {
            recordEo.setDocumentCode(reqDto.getDocumentCode());
        }
        if (StringUtils.isNotEmpty((String)reqDto.getItemCode())) {
            recordEo.setItemCode(reqDto.getItemCode());
        }
        if (StringUtils.isNotEmpty((String)reqDto.getItemBatch())) {
            recordEo.setItemBatch(reqDto.getItemBatch());
        }
        if (CollectionUtils.isNotEmpty((Collection)(recordEoList = this.itemUnitConversionRecordDas.select((BaseEo)recordEo)))) {
            ArrayList<ItemUnitConversionRecordRespDto> dtoList = new ArrayList<ItemUnitConversionRecordRespDto>();
            DtoHelper.eoList2DtoList((Collection)recordEoList, dtoList, ItemUnitConversionRecordRespDto.class);
            return dtoList;
        }
        return null;
    }

    @Override
    public List<ItemUnitConversionRecordRespDto> queryItemUnitByDocumentCodes(Set<String> documentCodeSet) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"document_code", documentCodeSet);
        List recordEoList = this.itemUnitConversionRecordDas.selectItemUnit(wrapper);
        if (CollectionUtils.isNotEmpty((Collection)recordEoList)) {
            ArrayList<ItemUnitConversionRecordRespDto> dtoList = new ArrayList<ItemUnitConversionRecordRespDto>();
            DtoHelper.eoList2DtoList((Collection)recordEoList, dtoList, ItemUnitConversionRecordRespDto.class);
            return dtoList;
        }
        return null;
    }

    @Override
    public List<ItemConversionRecordRespDto> selectItemConversionRecord(List<ItemConversionRecordReqDto> reqDtoList) {
        if (CollectionUtils.isEmpty(reqDtoList)) {
            return null;
        }
        for (ItemConversionRecordReqDto reqDto2 : reqDtoList) {
            if (StringUtils.isEmpty((String)reqDto2.getItemCode())) {
                throw new BizException("\u5546\u54c1\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != reqDto2.getItemNum() && reqDto2.getItemNum().compareTo(BigDecimal.ZERO) >= 0) continue;
            throw new BizException("\u5546\u54c1\u6570\u91cf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> itemCodeList = reqDtoList.stream().map(ItemConversionRecordReqDto::getItemCode).distinct().collect(Collectors.toList());
        List<OmsItemDetailDto> detailDtoList = this.iItemExtendService.queryItemDetailByListCode(itemCodeList);
        if (CollectionUtils.isNotEmpty(detailDtoList)) {
            Map<String, List<OmsItemDetailDto>> itemDetailMap = detailDtoList.stream().collect(Collectors.groupingBy(OmsItemDetailDto::getCode));
            reqDtoList.forEach(reqDto -> {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)itemDetailMap.get(reqDto.getItemCode())))) {
                    reqDto.setToItemUnit(((OmsItemDetailDto)((List)itemDetailMap.get(reqDto.getItemCode())).get(0)).getBaseUnit());
                }
            });
            return this.selectItemConversionData(reqDtoList);
        }
        return null;
    }

    @Override
    public List<ItemConversionRecordRespDto> selectItemSaleConversionRecord(List<ItemConversionRecordReqDto> reqDtoList) {
        if (CollectionUtils.isEmpty(reqDtoList)) {
            return null;
        }
        for (ItemConversionRecordReqDto reqDto2 : reqDtoList) {
            if (null == reqDto2.getItemNum() || reqDto2.getItemNum().compareTo(BigDecimal.ZERO) < 0) {
                throw new BizException("\u5546\u54c1\u6570\u91cf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)reqDto2.getItemCode())) {
                throw new BizException("\u5546\u54c1\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != reqDto2.getItemPrice() && reqDto2.getItemPrice().compareTo(BigDecimal.ZERO) >= 0) continue;
            throw new BizException("\u5546\u54c1\u5355\u4ef7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> itemCodeList = reqDtoList.stream().map(ItemConversionRecordReqDto::getItemCode).distinct().collect(Collectors.toList());
        List<OmsItemDetailDto> detailDtoList = this.iItemExtendService.queryItemDetailByListCode(itemCodeList);
        if (CollectionUtils.isNotEmpty(detailDtoList)) {
            Map<String, List<OmsItemDetailDto>> itemDetailMap = detailDtoList.stream().collect(Collectors.groupingBy(OmsItemDetailDto::getCode));
            reqDtoList.forEach(reqDto -> {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)itemDetailMap.get(reqDto.getItemCode())))) {
                    if (StringUtils.isEmpty((String)reqDto.getItemUnit())) {
                        reqDto.setItemUnit(((OmsItemDetailDto)((List)itemDetailMap.get(reqDto.getItemCode())).get(0)).getBaseUnit());
                    } else {
                        reqDto.setItemUnit(reqDto.getItemUnit());
                    }
                    if (StringUtils.isEmpty((String)((OmsItemDetailDto)((List)itemDetailMap.get(reqDto.getItemCode())).get(0)).getSaleUnit())) {
                        reqDto.setToItemUnit(((OmsItemDetailDto)((List)itemDetailMap.get(reqDto.getItemCode())).get(0)).getBaseUnit());
                    } else {
                        reqDto.setToItemUnit(((OmsItemDetailDto)((List)itemDetailMap.get(reqDto.getItemCode())).get(0)).getSaleUnit());
                    }
                }
            });
            return this.selectItemConversionData(reqDtoList);
        }
        return null;
    }

    @Override
    public List<ItemConversionRecordRespDto> selectItemSaleBox(List<ItemConversionRecordReqDto> reqDtoList) {
        if (CollectionUtils.isEmpty(reqDtoList)) {
            return null;
        }
        for (ItemConversionRecordReqDto reqDto2 : reqDtoList) {
            if (null == reqDto2.getItemNum() || reqDto2.getItemNum().compareTo(BigDecimal.ZERO) < 0) {
                throw new BizException("\u5546\u54c1\u6570\u91cf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)reqDto2.getItemCode())) {
                throw new BizException("\u5546\u54c1\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != reqDto2.getItemPrice() && reqDto2.getItemPrice().compareTo(BigDecimal.ZERO) >= 0) continue;
            throw new BizException("\u5546\u54c1\u5355\u4ef7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> itemCodeList = reqDtoList.stream().map(ItemConversionRecordReqDto::getItemCode).distinct().collect(Collectors.toList());
        List<OmsItemDetailDto> detailDtoList = this.iItemExtendService.queryItemDetailByListCode(itemCodeList);
        if (CollectionUtils.isNotEmpty(detailDtoList)) {
            Map<String, List<OmsItemDetailDto>> itemDetailMap = detailDtoList.stream().collect(Collectors.groupingBy(OmsItemDetailDto::getCode));
            reqDtoList.forEach(reqDto -> {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)itemDetailMap.get(reqDto.getItemCode())))) {
                    if (StringUtils.isEmpty((String)reqDto.getItemUnit())) {
                        reqDto.setItemUnit(((OmsItemDetailDto)((List)itemDetailMap.get(reqDto.getItemCode())).get(0)).getBaseUnit());
                    } else {
                        reqDto.setItemUnit(reqDto.getItemUnit());
                    }
                    reqDto.setToItemUnit(ItemUnit.CV.getCode());
                }
            });
            return this.selectItemCVData(reqDtoList);
        }
        return null;
    }

    @Override
    public List<ItemConversionRecordRespDto> selectItemConversion(ItemUnitRecordReqDto reqDto) {
        List<String> itemCodeList;
        List<OmsItemDetailDto> detailDtoList;
        List<ItemUnitConversionRecordRespDto> respDtoList = this.selectItemUnitByParams(reqDto);
        if (CollectionUtils.isNotEmpty(respDtoList) && CollectionUtils.isNotEmpty(detailDtoList = this.iItemExtendService.queryItemDetailByListCode(itemCodeList = respDtoList.stream().map(ItemUnitConversionRecordRespDto::getItemCode).distinct().collect(Collectors.toList())))) {
            Map<String, List<OmsItemDetailDto>> itemDetailMap = detailDtoList.stream().collect(Collectors.groupingBy(OmsItemDetailDto::getCode));
            return this.calculateItemUnitData(respDtoList, itemDetailMap);
        }
        return null;
    }

    @Override
    public List<ItemUnitConversionRecordRespDto> batchSelect(List<ItemUnitRecordReqDto> reqDtos) {
        List<ItemUnitConversionRecordEo> recordEoList = this.selectList(reqDtos);
        if (CollectionUtils.isNotEmpty(recordEoList)) {
            ArrayList<ItemUnitConversionRecordRespDto> dtoList = new ArrayList<ItemUnitConversionRecordRespDto>();
            DtoHelper.eoList2DtoList(recordEoList, dtoList, ItemUnitConversionRecordRespDto.class);
            return dtoList;
        }
        return Collections.EMPTY_LIST;
    }

    private List<ItemUnitConversionRecordRespDto> selectItemData(List<ItemUnitRecordReqDto> reqDtoList) {
        if (CollectionUtils.isEmpty(reqDtoList)) {
            return new ArrayList<ItemUnitConversionRecordRespDto>();
        }
        List<String> itemCodeList = reqDtoList.stream().map(ItemUnitRecordReqDto::getItemCode).distinct().collect(Collectors.toList());
        List<ItemUnitConversionRespDto> itemSkuEoList = this.iItemUnitConversionService.queryItemUnitByListCode(itemCodeList);
        Map<String, List<ItemUnitConversionRespDto>> itemSkuEoMap = itemSkuEoList.stream().collect(Collectors.groupingBy(ItemUnitConversionRespDto2 -> ItemUnitConversionRespDto2.getCode() + "_" + ItemUnitConversionRespDto2.getConversionUnit()));
        ArrayList<ItemUnitConversionRecordRespDto> respDtoList = new ArrayList<ItemUnitConversionRecordRespDto>();
        for (ItemUnitRecordReqDto o : reqDtoList) {
            ItemUnitConversionRecordRespDto vo = new ItemUnitConversionRecordRespDto();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            if (StringUtils.isNotEmpty((String)o.getItemUnit()) && StringUtils.isNotEmpty((String)o.getToItemUnit())) {
                ItemUnitConversionRespDto toUnitConversionRespDto;
                ItemUnitConversionRespDto unitConversionRespDto = itemSkuEoMap.get(o.getItemCode() + "_" + o.getItemUnit()).get(0);
                if (null != unitConversionRespDto && null != unitConversionRespDto.getId()) {
                    vo.setBaseUnitNum(unitConversionRespDto.getBaseUnitNum());
                    vo.setConversionNum(unitConversionRespDto.getConversionNum());
                    vo.setConversionUnit(unitConversionRespDto.getConversionUnit());
                }
                if (null != (toUnitConversionRespDto = itemSkuEoMap.get(o.getItemCode() + "_" + o.getToItemUnit()).get(0)) && null != toUnitConversionRespDto.getId()) {
                    vo.setToBaseUnitNum(toUnitConversionRespDto.getBaseUnitNum());
                    vo.setToConversionNum(toUnitConversionRespDto.getConversionNum());
                    vo.setToConversionUnit(toUnitConversionRespDto.getConversionUnit());
                }
                if (null != unitConversionRespDto && null != unitConversionRespDto.getId() && null != toUnitConversionRespDto && null != toUnitConversionRespDto.getId()) {
                    Integer conversionNum = null != unitConversionRespDto.getConversionNum() ? unitConversionRespDto.getConversionNum() : 0;
                    Integer baseUnitNum = null != unitConversionRespDto.getBaseUnitNum() ? unitConversionRespDto.getBaseUnitNum() : 0;
                    Integer toConversionNum = null != toUnitConversionRespDto.getConversionNum() ? toUnitConversionRespDto.getConversionNum() : 0;
                    Integer toBaseUnitNum = null != toUnitConversionRespDto.getBaseUnitNum() ? toUnitConversionRespDto.getBaseUnitNum() : 0;
                    try {
                        BigDecimal it = o.getItemNum().multiply(new BigDecimal(baseUnitNum)).divide(new BigDecimal(conversionNum), 10, 6);
                        BigDecimal toIt = new BigDecimal(toBaseUnitNum).divide(new BigDecimal(toConversionNum), 10, 6);
                        BigDecimal budgetItemNum = it.divide(toIt, 10, 6).setScale(3, 1);
                        logger.info("\u5355\u4f4d\u8f6c\u6362 toItemNum = {}", (Object)budgetItemNum);
                        vo.setToItemNum(budgetItemNum);
                        vo.setToItemUnit(toUnitConversionRespDto.getConversionUnit());
                        if (null != o.getItemPrice() && o.getItemPrice().compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal ip = o.getItemPrice().multiply(new BigDecimal(toConversionNum)).divide(new BigDecimal(toBaseUnitNum), 12, 6);
                            BigDecimal toIp = new BigDecimal(baseUnitNum).divide(new BigDecimal(conversionNum), 12, 6);
                            BigDecimal toItemPrice = ip.divide(toIp, 12, 6).setScale(12, 1);
                            vo.setToItemPrice(toItemPrice);
                        } else {
                            vo.setToItemPrice(BigDecimal.ZERO);
                        }
                    }
                    catch (Exception e) {
                        logger.error("error = {}", (Object)e.getMessage());
                    }
                }
            }
            respDtoList.add(vo);
        }
        return respDtoList;
    }

    private List<ItemUnitConversionDataRespDto> selectItemUnitData(List<ItemUnitConversionRecordRespDto> respDtoList) {
        if (CollectionUtils.isNotEmpty(respDtoList)) {
            List<ItemUnitConversionDataRespDto> dataRespDtoList = respDtoList.stream().map(respDto -> {
                ItemUnitConversionDataRespDto dataRespDto = new ItemUnitConversionDataRespDto();
                dataRespDto.setDocumentCode(respDto.getDocumentCode());
                dataRespDto.setItemCode(respDto.getItemCode());
                dataRespDto.setItemBatch(respDto.getItemBatch());
                dataRespDto.setItemNum(respDto.getItemNum());
                dataRespDto.setItemUnit(respDto.getItemUnit());
                dataRespDto.setItemPrice(respDto.getItemPrice());
                dataRespDto.setToItemNum(respDto.getToItemNum());
                dataRespDto.setToItemUnit(respDto.getToItemUnit());
                dataRespDto.setToItemPrice(respDto.getToItemPrice());
                return dataRespDto;
            }).collect(Collectors.toList());
            return dataRespDtoList;
        }
        return null;
    }

    private void batchDeleteById(List<ItemUnitRecordReqDto> reqDtoList) {
        List<ItemUnitConversionRecordEo> recordEoList;
        if (CollectionUtils.isNotEmpty(reqDtoList) && CollectionUtils.isNotEmpty(recordEoList = this.selectDocumentNoAndTypeList(reqDtoList.get(0)))) {
            this.itemUnitConversionRecordDas.batchDeleteItemUnitData(recordEoList);
        }
    }

    private List<ItemUnitConversionRecordEo> selectList(List<ItemUnitRecordReqDto> reqDtos) {
        if (CollUtil.isEmpty(reqDtos)) {
            return Collections.EMPTY_LIST;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        for (int i = 0; i < reqDtos.size(); ++i) {
            ItemUnitRecordReqDto reqDto = reqDtos.get(i);
            if (ObjectUtil.isEmpty((Object)reqDto)) continue;
            queryWrapper.or(wrapper -> {
                if (StringUtils.isNotEmpty((String)reqDto.getType())) {
                    wrapper.eq((Object)"type", (Object)reqDto.getType());
                }
                if (StringUtils.isNotEmpty((String)reqDto.getDocumentCode())) {
                    wrapper.eq((Object)"document_code", (Object)reqDto.getDocumentCode());
                }
                if (StringUtils.isNotEmpty((String)reqDto.getItemCode())) {
                    wrapper.eq((Object)"item_code", (Object)reqDto.getItemCode());
                }
                if (StringUtils.isNotEmpty((String)reqDto.getItemBatch())) {
                    wrapper.eq((Object)"item_batch", (Object)reqDto.getItemBatch());
                }
                if (StringUtils.isNotEmpty((String)reqDto.getToItemUnit())) {
                    wrapper.eq((Object)"to_item_unit", (Object)reqDto.getToItemUnit());
                }
            });
        }
        return this.itemUnitConversionRecordDas.list((Wrapper)queryWrapper);
    }

    private List<ItemUnitConversionRecordEo> selectDocumentNoAndTypeList(ItemUnitRecordReqDto itemUnitRecordReqDto) {
        if (StringUtils.isEmpty((String)itemUnitRecordReqDto.getType()) || StringUtils.isEmpty((String)itemUnitRecordReqDto.getDocumentCode())) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)itemUnitRecordReqDto.getType())) {
            wrapper.eq((Object)"type", (Object)itemUnitRecordReqDto.getType());
        }
        if (StringUtils.isNotEmpty((String)itemUnitRecordReqDto.getDocumentCode())) {
            wrapper.eq((Object)"document_code", (Object)itemUnitRecordReqDto.getDocumentCode());
        }
        return this.itemUnitConversionRecordDas.selectItemUnit(wrapper);
    }

    private List<ItemConversionRecordRespDto> selectItemConversionData(List<ItemConversionRecordReqDto> reqDtoList) {
        if (CollectionUtils.isEmpty(reqDtoList)) {
            return null;
        }
        List<String> itemCodeList = reqDtoList.stream().map(ItemConversionRecordReqDto::getItemCode).distinct().collect(Collectors.toList());
        List<ItemUnitConversionRespDto> itemSkuEoList = this.iItemUnitConversionService.queryItemUnitByListCode(itemCodeList);
        Map<String, List<ItemUnitConversionRespDto>> itemSkuEoMap = itemSkuEoList.stream().collect(Collectors.groupingBy(ItemUnitConversionRespDto2 -> ItemUnitConversionRespDto2.getCode() + "_" + ItemUnitConversionRespDto2.getConversionUnit()));
        ArrayList<ItemConversionRecordRespDto> respDtoList = new ArrayList<ItemConversionRecordRespDto>();
        if (null != itemSkuEoMap) {
            for (ItemConversionRecordReqDto reqDto : reqDtoList) {
                List<ItemUnitConversionRespDto> itemUnitConversionRespDtos1;
                ItemConversionRecordRespDto recordRespDto = new ItemConversionRecordRespDto();
                BeanUtils.copyProperties((Object)reqDto, (Object)recordRespDto);
                List<ItemUnitConversionRespDto> itemUnitConversionRespDtos = itemSkuEoMap.get(recordRespDto.getItemCode() + "_" + recordRespDto.getItemUnit());
                if (CollectionUtils.isEmpty(itemUnitConversionRespDtos)) continue;
                ItemUnitConversionRespDto unitConversionRespDto = itemSkuEoMap.get(recordRespDto.getItemCode() + "_" + recordRespDto.getItemUnit()).get(0);
                if (null != unitConversionRespDto && null != unitConversionRespDto.getId()) {
                    recordRespDto.setConversionNum(unitConversionRespDto.getConversionNum());
                    recordRespDto.setBaseUnitNum(unitConversionRespDto.getBaseUnitNum());
                    recordRespDto.setConversionUnit(unitConversionRespDto.getConversionUnit());
                    if (null != reqDto.getItemPrice() && BigDecimal.ZERO.compareTo(reqDto.getItemPrice()) > 0) {
                        recordRespDto.setItemPrice(reqDto.getItemPrice());
                        recordRespDto.setTotalItemPrice(recordRespDto.getItemNum().multiply(reqDto.getItemPrice()));
                    }
                }
                if (CollectionUtils.isEmpty(itemUnitConversionRespDtos1 = itemSkuEoMap.get(recordRespDto.getItemCode() + "_" + recordRespDto.getToItemUnit()))) continue;
                ItemUnitConversionRespDto toUnitConversionRespDto = itemSkuEoMap.get(recordRespDto.getItemCode() + "_" + recordRespDto.getToItemUnit()).get(0);
                if (null != toUnitConversionRespDto && null != toUnitConversionRespDto.getId()) {
                    recordRespDto.setToConversionNum(toUnitConversionRespDto.getConversionNum());
                    recordRespDto.setToBaseUnitNum(toUnitConversionRespDto.getBaseUnitNum());
                    recordRespDto.setToConversionUnit(toUnitConversionRespDto.getConversionUnit());
                }
                if (null != unitConversionRespDto && null != unitConversionRespDto.getId() && null != toUnitConversionRespDto && null != toUnitConversionRespDto.getId()) {
                    Integer baseUnitNum = null != unitConversionRespDto.getBaseUnitNum() ? unitConversionRespDto.getBaseUnitNum() : 0;
                    Integer conversionNum = null != unitConversionRespDto.getConversionNum() ? unitConversionRespDto.getConversionNum() : 0;
                    Integer toBaseUnitNum = null != toUnitConversionRespDto.getBaseUnitNum() ? toUnitConversionRespDto.getBaseUnitNum() : 0;
                    Integer toConversionNum = null != toUnitConversionRespDto.getConversionNum() ? toUnitConversionRespDto.getConversionNum() : 0;
                    BigDecimal it = reqDto.getItemNum().multiply(new BigDecimal(baseUnitNum)).divide(new BigDecimal(conversionNum), 10, 6);
                    BigDecimal toIt = new BigDecimal(toBaseUnitNum).divide(new BigDecimal(toConversionNum), 10, 6);
                    BigDecimal budgetItemNum = it.divide(toIt, 10, 6).setScale(3, 1);
                    logger.info("\u5355\u4f4d\u8f6c\u6362 toItemNum = {}", (Object)budgetItemNum);
                    recordRespDto.setToItemNum(budgetItemNum);
                    recordRespDto.setToItemUnit(toUnitConversionRespDto.getConversionUnit());
                    if (null != reqDto.getItemPrice() && reqDto.getItemPrice().compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal ip = reqDto.getItemPrice().multiply(new BigDecimal(toConversionNum)).divide(new BigDecimal(toBaseUnitNum), 12, 6);
                        BigDecimal toIp = new BigDecimal(baseUnitNum).divide(new BigDecimal(conversionNum), 12, 6);
                        BigDecimal toItemPrice = ip.divide(toIp, 12, 6).setScale(12, 1);
                        recordRespDto.setToItemPrice(toItemPrice);
                        recordRespDto.setTotalItemPrice(toItemPrice.multiply(budgetItemNum));
                    } else {
                        recordRespDto.setToItemPrice(BigDecimal.ZERO);
                        recordRespDto.setTotalItemPrice(BigDecimal.ZERO);
                    }
                }
                respDtoList.add(recordRespDto);
            }
        }
        return respDtoList;
    }

    private List<ItemConversionRecordRespDto> selectItemCVData(List<ItemConversionRecordReqDto> reqDtoList) {
        if (CollectionUtils.isEmpty(reqDtoList)) {
            return null;
        }
        List<String> itemCodeList = reqDtoList.stream().map(ItemConversionRecordReqDto::getItemCode).distinct().collect(Collectors.toList());
        List<ItemUnitConversionRespDto> itemSkuEoList = this.iItemUnitConversionService.queryItemUnitByListCode(itemCodeList);
        Map<String, List<ItemUnitConversionRespDto>> itemSkuEoMap = itemSkuEoList.stream().collect(Collectors.groupingBy(ItemUnitConversionRespDto2 -> ItemUnitConversionRespDto2.getCode() + "_" + ItemUnitConversionRespDto2.getConversionUnit()));
        ArrayList<ItemConversionRecordRespDto> respDtoList = new ArrayList<ItemConversionRecordRespDto>();
        if (null != itemSkuEoMap) {
            for (ItemConversionRecordReqDto reqDto : reqDtoList) {
                ItemConversionRecordRespDto recordRespDto = new ItemConversionRecordRespDto();
                BeanUtils.copyProperties((Object)reqDto, (Object)recordRespDto);
                List<ItemUnitConversionRespDto> itemUnitConversionRespDtos = itemSkuEoMap.get(recordRespDto.getItemCode() + "_" + recordRespDto.getItemUnit());
                if (CollectionUtils.isEmpty(itemUnitConversionRespDtos)) continue;
                if (null == itemSkuEoMap.get(recordRespDto.getItemCode() + "_" + recordRespDto.getItemUnit()).get(0)) {
                    recordRespDto.setId(Long.valueOf(1L));
                    respDtoList.add(recordRespDto);
                    continue;
                }
                ItemUnitConversionRespDto unitConversionRespDto = itemSkuEoMap.get(recordRespDto.getItemCode() + "_" + recordRespDto.getItemUnit()).get(0);
                if (null != unitConversionRespDto && null != unitConversionRespDto.getId()) {
                    recordRespDto.setConversionNum(unitConversionRespDto.getConversionNum());
                    recordRespDto.setBaseUnitNum(unitConversionRespDto.getBaseUnitNum());
                    recordRespDto.setConversionUnit(unitConversionRespDto.getConversionUnit());
                    if (null != reqDto.getItemPrice() && reqDto.getItemPrice().compareTo(BigDecimal.ZERO) > 0) {
                        recordRespDto.setItemPrice(reqDto.getItemPrice());
                        recordRespDto.setTotalItemPrice(recordRespDto.getItemNum().multiply(reqDto.getItemPrice()));
                    }
                }
                if (null == itemSkuEoMap.get(recordRespDto.getItemCode() + "_" + recordRespDto.getToItemUnit())) {
                    recordRespDto.setId(Long.valueOf(1L));
                    respDtoList.add(recordRespDto);
                    continue;
                }
                ItemUnitConversionRespDto toUnitConversionRespDto = itemSkuEoMap.get(recordRespDto.getItemCode() + "_" + recordRespDto.getToItemUnit()).get(0);
                if (null != toUnitConversionRespDto && null != toUnitConversionRespDto.getId()) {
                    recordRespDto.setToConversionNum(toUnitConversionRespDto.getConversionNum());
                    recordRespDto.setToBaseUnitNum(toUnitConversionRespDto.getBaseUnitNum());
                    recordRespDto.setToConversionUnit(toUnitConversionRespDto.getConversionUnit());
                }
                if (null != unitConversionRespDto && null != unitConversionRespDto.getId() && null != toUnitConversionRespDto && null != toUnitConversionRespDto.getId()) {
                    Integer baseUnitNum = null != unitConversionRespDto.getBaseUnitNum() ? unitConversionRespDto.getBaseUnitNum() : 0;
                    Integer conversionNum = null != unitConversionRespDto.getConversionNum() ? unitConversionRespDto.getConversionNum() : 0;
                    Integer toBaseUnitNum = null != toUnitConversionRespDto.getBaseUnitNum() ? toUnitConversionRespDto.getBaseUnitNum() : 0;
                    Integer toConversionNum = null != toUnitConversionRespDto.getConversionNum() ? toUnitConversionRespDto.getConversionNum() : 0;
                    BigDecimal it = reqDto.getItemNum().multiply(new BigDecimal(baseUnitNum)).divide(new BigDecimal(conversionNum), 10, 6);
                    BigDecimal toIt = new BigDecimal(toBaseUnitNum).divide(new BigDecimal(toConversionNum), 10, 6);
                    BigDecimal budgetItemNum = it.divide(toIt, 10, 6).setScale(3, 1);
                    logger.info("\u5355\u4f4d\u8f6c\u6362 toItemNum = {}", (Object)budgetItemNum);
                    recordRespDto.setToItemNum(budgetItemNum);
                    recordRespDto.setToItemUnit(toUnitConversionRespDto.getConversionUnit());
                    if (null != reqDto.getItemPrice() && reqDto.getItemPrice().compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal ip = reqDto.getItemPrice().multiply(new BigDecimal(toConversionNum)).divide(new BigDecimal(toBaseUnitNum), 12, 6);
                        BigDecimal toIp = new BigDecimal(baseUnitNum).divide(new BigDecimal(conversionNum), 12, 6);
                        BigDecimal toItemPrice = ip.divide(toIp, 12, 6).setScale(12, 1);
                        recordRespDto.setToItemPrice(toItemPrice);
                        recordRespDto.setTotalItemPrice(toItemPrice.multiply(budgetItemNum));
                    } else {
                        recordRespDto.setToItemPrice(BigDecimal.ZERO);
                        recordRespDto.setTotalItemPrice(BigDecimal.ZERO);
                    }
                }
                respDtoList.add(recordRespDto);
            }
        }
        return respDtoList;
    }

    private List<ItemConversionRecordRespDto> calculateItemUnitData(List<ItemUnitConversionRecordRespDto> reqDtoList, Map<String, List<OmsItemDetailDto>> itemDetailMap) {
        if (CollectionUtils.isEmpty(reqDtoList)) {
            return null;
        }
        List<String> itemCodeList = reqDtoList.stream().map(ItemUnitConversionRecordRespDto::getItemCode).distinct().collect(Collectors.toList());
        List<ItemUnitConversionRespDto> itemSkuEoList = this.iItemUnitConversionService.queryItemUnitByListCode(itemCodeList);
        Map<String, List<ItemUnitConversionRespDto>> itemSkuEoMap = itemSkuEoList.stream().collect(Collectors.groupingBy(ItemUnitConversionRespDto2 -> ItemUnitConversionRespDto2.getCode() + "_" + ItemUnitConversionRespDto2.getConversionUnit()));
        ArrayList<ItemConversionRecordRespDto> respDtoList = new ArrayList<ItemConversionRecordRespDto>();
        if (null != itemSkuEoMap) {
            for (ItemUnitConversionRecordRespDto reqDto : reqDtoList) {
                ItemUnitConversionRespDto toUnitConversionRespDto;
                ItemConversionRecordRespDto recordRespDto = new ItemConversionRecordRespDto();
                BeanUtils.copyProperties((Object)reqDto, (Object)recordRespDto);
                recordRespDto.setItemNum(reqDto.getToItemNum());
                if (null != itemSkuEoMap.get(reqDto.getItemCode() + "_" + ItemUnit.CV.getCode()).get(0)) {
                    recordRespDto.setToItemUnit(ItemUnit.CV.getCode());
                } else {
                    List<OmsItemDetailDto> detailDtos = itemDetailMap.get(reqDto.getItemCode());
                    if (CollectionUtils.isNotEmpty(detailDtos) && StringUtils.isNotEmpty((String)detailDtos.get(0).getSaleUnit())) {
                        recordRespDto.setToItemUnit(detailDtos.get(0).getSaleUnit());
                    } else {
                        respDtoList.add(recordRespDto);
                        continue;
                    }
                }
                ItemUnitConversionRespDto unitConversionRespDto = itemSkuEoMap.get(recordRespDto.getItemCode() + "_" + recordRespDto.getItemUnit()).get(0);
                if (null != unitConversionRespDto && null != unitConversionRespDto.getId()) {
                    recordRespDto.setConversionNum(unitConversionRespDto.getConversionNum());
                    recordRespDto.setBaseUnitNum(unitConversionRespDto.getBaseUnitNum());
                    recordRespDto.setConversionUnit(unitConversionRespDto.getConversionUnit());
                    if (null != reqDto.getItemPrice() && reqDto.getItemPrice().compareTo(BigDecimal.ZERO) > 0) {
                        recordRespDto.setItemPrice(reqDto.getItemPrice());
                        recordRespDto.setTotalItemPrice(recordRespDto.getItemNum().multiply(reqDto.getItemPrice()));
                    }
                }
                if (null != (toUnitConversionRespDto = itemSkuEoMap.get(recordRespDto.getItemCode() + "_" + recordRespDto.getToItemUnit()).get(0)) && null != toUnitConversionRespDto.getId()) {
                    recordRespDto.setToConversionNum(toUnitConversionRespDto.getConversionNum());
                    recordRespDto.setToBaseUnitNum(toUnitConversionRespDto.getBaseUnitNum());
                    recordRespDto.setToConversionUnit(toUnitConversionRespDto.getConversionUnit());
                }
                if (null != unitConversionRespDto && null != unitConversionRespDto.getId() && null != toUnitConversionRespDto && null != toUnitConversionRespDto.getId()) {
                    Integer baseUnitNum = null != unitConversionRespDto.getBaseUnitNum() ? unitConversionRespDto.getBaseUnitNum() : 0;
                    Integer conversionNum = null != unitConversionRespDto.getConversionNum() ? unitConversionRespDto.getConversionNum() : 0;
                    Integer toBaseUnitNum = null != toUnitConversionRespDto.getBaseUnitNum() ? toUnitConversionRespDto.getBaseUnitNum() : 0;
                    Integer toConversionNum = null != toUnitConversionRespDto.getConversionNum() ? toUnitConversionRespDto.getConversionNum() : 0;
                    BigDecimal it = reqDto.getItemNum().multiply(new BigDecimal(baseUnitNum)).divide(new BigDecimal(conversionNum), 10, 6);
                    BigDecimal toIt = new BigDecimal(toBaseUnitNum).divide(new BigDecimal(toConversionNum), 10, 6);
                    BigDecimal budgetItemNum = it.divide(toIt, 10, 6).setScale(3, 1);
                    logger.info("\u5355\u4f4d\u8f6c\u6362 toItemNum = {}", (Object)budgetItemNum);
                    recordRespDto.setToItemNum(budgetItemNum);
                    recordRespDto.setToItemUnit(toUnitConversionRespDto.getConversionUnit());
                    if (null != reqDto.getItemPrice() && reqDto.getItemPrice().compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal ip = reqDto.getItemPrice().multiply(new BigDecimal(toConversionNum)).divide(new BigDecimal(toBaseUnitNum), 12, 6);
                        BigDecimal toIp = new BigDecimal(baseUnitNum).divide(new BigDecimal(conversionNum), 12, 6);
                        BigDecimal toItemPrice = ip.divide(toIp, 12, 6).setScale(12, 1);
                        recordRespDto.setToItemPrice(toItemPrice);
                        recordRespDto.setTotalItemPrice(toItemPrice.multiply(budgetItemNum));
                    } else {
                        recordRespDto.setToItemPrice(BigDecimal.ZERO);
                        recordRespDto.setTotalItemPrice(BigDecimal.ZERO);
                    }
                }
                respDtoList.add(recordRespDto);
            }
        }
        return respDtoList;
    }
}

