/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemInfoSkuReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemUnitConversionQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemUnitConversionReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemDepartmentPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemInfoSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemUnitConversionRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.OmsItemDetailDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemDepartmentPriceService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemExtendService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemUnitConversionService;
import com.dtyunxi.yundt.cube.center.item.biz.util.LengthUnitUtils;
import com.dtyunxi.yundt.cube.center.item.biz.util.WeightUnitUtils;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemUnitConversionDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemUnitConversionEo;
import com.dtyunxi.yundt.cube.center.item.dao.mapper.ItemUnitConversionMapper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemUnitConversionServiceImpl
implements IItemUnitConversionService {
    @Resource
    private IItemService iItemService;
    @Resource(name="${project.domain.prefix:tcbj}ItemExtendService")
    private IItemExtendService iItemExtendService;
    @Resource
    private IItemDepartmentPriceService priceService;
    @Resource
    private ItemUnitConversionDas itemUnitConversionDas;
    @Resource
    private ItemUnitConversionMapper itemUnitConversionMapper;

    @Override
    public Long addItemUnitConversion(ItemUnitConversionReqDto addReqDto) {
        ItemUnitConversionEo itemUnitConversionEo = new ItemUnitConversionEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemUnitConversionEo);
        this.itemUnitConversionDas.insert((BaseEo)itemUnitConversionEo);
        return itemUnitConversionEo.getId();
    }

    @Override
    public void modifyItemUnitConversion(ItemUnitConversionReqDto modifyReqDto) {
        ItemUnitConversionEo itemUnitConversionEo = new ItemUnitConversionEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemUnitConversionEo);
        this.itemUnitConversionDas.updateSelective((BaseEo)itemUnitConversionEo);
    }

    @Override
    public void batchCreateItemUnitConversion(List<ItemUnitConversionReqDto> conversionReqDtoList) {
        ArrayList<ItemUnitConversionEo> addItemUnitList = new ArrayList<ItemUnitConversionEo>();
        ArrayList<ItemUnitConversionEo> modifyItemUnitList = new ArrayList<ItemUnitConversionEo>();
        if (CollectionUtils.isNotEmpty(conversionReqDtoList)) {
            for (ItemUnitConversionReqDto reqDto : conversionReqDtoList) {
                ItemUnitConversionEo itemUnitConversionEo;
                List<ItemUnitConversionEo> conversionEos = this.queryItemUnit(reqDto.getItemId(), reqDto.getConversionUnit());
                if (CollectionUtils.isNotEmpty(conversionEos)) {
                    itemUnitConversionEo = new ItemUnitConversionEo();
                    DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)itemUnitConversionEo);
                    itemUnitConversionEo.setId(conversionEos.get(0).getId());
                    itemUnitConversionEo.setUpdateTime(new Date());
                    modifyItemUnitList.add(itemUnitConversionEo);
                    continue;
                }
                itemUnitConversionEo = new ItemUnitConversionEo();
                DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)itemUnitConversionEo);
                addItemUnitList.add(itemUnitConversionEo);
            }
        }
        if (CollectionUtils.isNotEmpty(addItemUnitList)) {
            this.itemUnitConversionDas.insertBatch(addItemUnitList);
        }
        if (CollectionUtils.isNotEmpty(modifyItemUnitList)) {
            this.itemUnitConversionDas.batchModifyData(modifyItemUnitList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemUnitConversion(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemUnitConversionDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ItemUnitConversionRespDto queryById(Long id) {
        ItemUnitConversionEo itemUnitConversionEo = (ItemUnitConversionEo)this.itemUnitConversionDas.selectByPrimaryKey(id);
        ItemUnitConversionRespDto itemUnitConversionRespDto = new ItemUnitConversionRespDto();
        DtoHelper.eo2Dto((BaseEo)itemUnitConversionEo, (BaseVo)itemUnitConversionRespDto);
        return itemUnitConversionRespDto;
    }

    @Override
    public PageInfo<ItemUnitConversionRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemUnitConversionReqDto itemUnitConversionReqDto = (ItemUnitConversionReqDto)JSON.parseObject((String)filter, ItemUnitConversionReqDto.class);
        ItemUnitConversionEo itemUnitConversionEo = new ItemUnitConversionEo();
        DtoHelper.dto2Eo((BaseVo)itemUnitConversionReqDto, (BaseEo)itemUnitConversionEo);
        PageInfo eoPageInfo = this.itemUnitConversionDas.selectPage((BaseEo)itemUnitConversionEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemUnitConversionRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ItemUnitConversionRespDto> queryByPage(ItemUnitConversionQueryReqDto queryReqDto) {
        ItemUnitConversionEo itemUnitConversionEo = new ItemUnitConversionEo();
        if (null != queryReqDto.getItemId()) {
            itemUnitConversionEo.setItemId(queryReqDto.getItemId());
        }
        if (null != queryReqDto.getCode()) {
            itemUnitConversionEo.setCode(queryReqDto.getCode());
        }
        PageInfo eoPageInfo = this.itemUnitConversionDas.selectPage((BaseEo)itemUnitConversionEo, queryReqDto.getPageNum(), queryReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemUnitConversionRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ItemUnitConversionRespDto> queryItemUnitById(Long id) {
        return this.selectItemUnit(id, null);
    }

    @Override
    public List<ItemUnitConversionRespDto> queryItemUnitByCode(String code) {
        return this.selectItemUnit(null, code);
    }

    @Override
    public List<ItemUnitConversionRespDto> queryItemUnitByListCode(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"code", codeList);
        List selectList = this.itemUnitConversionDas.queryList(wrapper);
        if (CollectionUtils.isNotEmpty((Collection)selectList)) {
            ArrayList<ItemUnitConversionRespDto> dtoList = new ArrayList<ItemUnitConversionRespDto>();
            DtoHelper.eoList2DtoList((Collection)selectList, dtoList, ItemUnitConversionRespDto.class);
            return dtoList;
        }
        return null;
    }

    private List<ItemUnitConversionRespDto> selectItemUnit(Long id, String code) {
        List itemUnitConversionEoList;
        ItemUnitConversionEo itemUnitConversionEo = new ItemUnitConversionEo();
        if (null != id) {
            itemUnitConversionEo.setItemId(id);
        }
        if (StringUtils.isNotEmpty((String)code)) {
            itemUnitConversionEo.setCode(code);
        }
        OmsItemDetailDto detailDto = new OmsItemDetailDto();
        if (null != id) {
            detailDto = this.iItemExtendService.queryItemDetailById(id);
        }
        if (StringUtils.isNotEmpty((String)code)) {
            detailDto = this.iItemExtendService.queryItemDetailByCode(code);
        }
        if (CollectionUtils.isNotEmpty((Collection)(itemUnitConversionEoList = this.itemUnitConversionDas.select((BaseEo)itemUnitConversionEo)))) {
            ArrayList<ItemUnitConversionRespDto> dtoList = new ArrayList<ItemUnitConversionRespDto>();
            DtoHelper.eoList2DtoList((Collection)itemUnitConversionEoList, dtoList, ItemUnitConversionRespDto.class);
            ItemDepartmentPriceRespDto priceRespDto = new ItemDepartmentPriceRespDto();
            if (null != detailDto && null != detailDto.getId()) {
                priceRespDto = this.priceService.queryItemPriceByCode(detailDto.getLongCode(), detailDto.getBaseUnit());
            }
            ItemDepartmentPriceRespDto finalPriceRespDto = priceRespDto;
            dtoList.forEach(conversionRespDto -> {
                BigDecimal total = WeightUnitUtils.totalWeight(conversionRespDto.getNetWeight(), conversionRespDto.getWeightUnit());
                conversionRespDto.setWeight(null != total ? total.toString() : "0");
                BigDecimal totalVolume = LengthUnitUtils.totalVolume(conversionRespDto.getLength(), conversionRespDto.getWidth(), conversionRespDto.getHeight(), conversionRespDto.getSizeUnit());
                conversionRespDto.setVolume(totalVolume);
                if (null != finalPriceRespDto && null != finalPriceRespDto.getId()) {
                    conversionRespDto.setOutFactoryUnit(conversionRespDto.getConversionUnit());
                    BigDecimal price = new BigDecimal(conversionRespDto.getBaseUnitNum() + "").multiply(finalPriceRespDto.getItemPrice()).divide(new BigDecimal(conversionRespDto.getConversionNum() + ""), 2, RoundingMode.FLOOR);
                    conversionRespDto.setOutFactoryPrice(price);
                }
            });
            return dtoList;
        }
        return null;
    }

    @Override
    public ItemInfoSkuRespDto queryItemSkuByCode(ItemInfoSkuReqDto itemInfoSkuReqDto) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)itemInfoSkuReqDto.getCode())) {
            return null;
        }
        ItemInfoSkuRespDto respDto = new ItemInfoSkuRespDto();
        ItemRespDto itemRespDto = this.iItemService.queryByItemCode(itemInfoSkuReqDto.getCode());
        if (null != itemRespDto && null != itemRespDto.getId()) {
            OmsItemDetailDto detailDto = this.iItemExtendService.queryItemDetailById(itemRespDto.getId());
            List<ItemUnitConversionRespDto> itemSkuEoList = this.queryItemUnitById(itemRespDto.getId());
            if (CollectionUtils.isNotEmpty(itemSkuEoList)) {
                Map<String, List<ItemUnitConversionRespDto>> itemSkuEoMap = itemSkuEoList.stream().collect(Collectors.groupingBy(ItemUnitConversionRespDto::getConversionUnit));
                respDto.setId(itemRespDto.getId());
                respDto.setCode(itemRespDto.getLongCode());
                respDto.setName(itemRespDto.getName());
                respDto.setBaseUnit(detailDto.getBaseUnit());
                respDto.setSpecification(detailDto.getSpecification());
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)itemInfoSkuReqDto.getUnit())) {
                    if (null == itemSkuEoMap.get(itemInfoSkuReqDto.getUnit())) {
                        return null;
                    }
                    respDto.setConversionNum(null != itemSkuEoMap.get(itemInfoSkuReqDto.getUnit()).get(0).getBaseUnitNum() ? itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getConversionNum().toString() : null);
                    respDto.setBaseUnitNum(null != itemSkuEoMap.get(itemInfoSkuReqDto.getUnit()).get(0).getConversionNum() ? itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getBaseUnitNum().toString() : null);
                    respDto.setConversionUnit(itemSkuEoMap.get(itemInfoSkuReqDto.getUnit()).get(0).getConversionUnit());
                } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)detailDto.getBaseUnit())) {
                    respDto.setConversionNum(null != itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getBaseUnitNum() ? itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getConversionNum().toString() : null);
                    respDto.setBaseUnitNum(null != itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getConversionNum() ? itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getBaseUnitNum().toString() : null);
                    respDto.setConversionUnit(itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getConversionUnit());
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)itemInfoSkuReqDto.getToUnit())) {
                    if (null == itemSkuEoMap.get(itemInfoSkuReqDto.getToUnit())) {
                        return null;
                    }
                    respDto.setToConversionNum(null != itemSkuEoMap.get(itemInfoSkuReqDto.getToUnit()).get(0).getBaseUnitNum() ? itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getConversionNum().toString() : null);
                    respDto.setToBaseUnitNum(null != itemSkuEoMap.get(itemInfoSkuReqDto.getToUnit()).get(0).getConversionNum() ? itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getBaseUnitNum().toString() : null);
                    respDto.setToConversionUnit(itemSkuEoMap.get(itemInfoSkuReqDto.getToUnit()).get(0).getConversionUnit());
                } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)detailDto.getBaseUnit())) {
                    respDto.setToConversionNum(null != itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getBaseUnitNum() ? itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getConversionNum().toString() : null);
                    respDto.setToBaseUnitNum(null != itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getConversionNum() ? itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getBaseUnitNum().toString() : null);
                    respDto.setToConversionUnit(itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getConversionUnit());
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)itemInfoSkuReqDto.getUnit()) && null != itemInfoSkuReqDto.getNum()) {
                    Integer conversionNum = itemSkuEoMap.get(itemInfoSkuReqDto.getUnit()).get(0).getConversionNum();
                    Integer baseUnitNum = itemSkuEoMap.get(itemInfoSkuReqDto.getUnit()).get(0).getBaseUnitNum();
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)itemInfoSkuReqDto.getToUnit())) {
                        if (null == itemSkuEoMap.get(itemInfoSkuReqDto.getToUnit())) {
                            return null;
                        }
                        Integer toConversionNum = itemSkuEoMap.get(itemInfoSkuReqDto.getToUnit()).get(0).getConversionNum();
                        Integer toBaseUnitNum = itemSkuEoMap.get(itemInfoSkuReqDto.getToUnit()).get(0).getBaseUnitNum();
                        BigDecimal num = new BigDecimal(baseUnitNum).divide(new BigDecimal(conversionNum)).divide(new BigDecimal(toBaseUnitNum).divide(new BigDecimal(toConversionNum)));
                        respDto.setToNum(itemInfoSkuReqDto.getNum().multiply(num).toString());
                        respDto.setToUnit(itemSkuEoMap.get(itemInfoSkuReqDto.getToUnit()).get(0).getConversionUnit());
                    } else {
                        Integer toConversionNum = itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getConversionNum();
                        Integer toBaseUnitNum = itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getBaseUnitNum();
                        BigDecimal num = new BigDecimal(baseUnitNum).divide(new BigDecimal(conversionNum)).divide(new BigDecimal(toBaseUnitNum).divide(new BigDecimal(toConversionNum)));
                        respDto.setToNum(itemInfoSkuReqDto.getNum().multiply(num).toString());
                        respDto.setToUnit(itemSkuEoMap.get(detailDto.getBaseUnit()).get(0).getConversionUnit());
                    }
                }
            }
        }
        return respDto;
    }

    @Override
    public List<ItemUnitConversionRespDto> queryItemUnitByCodeList(List<String> codeList) {
        if (CollectionUtils.isNotEmpty(codeList)) {
            QueryWrapper itemUnitConversionEoQueryWrapper = new QueryWrapper();
            itemUnitConversionEoQueryWrapper.eq((Object)"dr", (Object)0);
            HashSet<String> codes = new HashSet<String>();
            codes.addAll(codeList);
            itemUnitConversionEoQueryWrapper.in((Object)"code", codeList);
            List itemUnitConversionEos = this.itemUnitConversionMapper.selectList((Wrapper)itemUnitConversionEoQueryWrapper);
            List collect = itemUnitConversionEos.stream().filter(e -> e.getConversionUnit().equals("CV")).collect(Collectors.toList());
            ArrayList<ItemUnitConversionRespDto> itemUnitConversionRespDtos = new ArrayList<ItemUnitConversionRespDto>();
            DtoHelper.eoList2DtoList(collect, itemUnitConversionRespDtos, ItemUnitConversionRespDto.class);
            return itemUnitConversionRespDtos;
        }
        return null;
    }

    private List<ItemUnitConversionEo> queryItemUnit(Long itemId, String unit) {
        ItemUnitConversionEo queryEo = new ItemUnitConversionEo();
        queryEo.setItemId(itemId);
        queryEo.setConversionUnit(unit);
        return this.itemUnitConversionDas.select((BaseEo)queryEo);
    }
}

