/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.apiimpl;

import cn.hutool.core.collection.CollectionUtil;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.ICollectionExtApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.CollectionItemQueryDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.CollectionItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.CollectionItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.CollectionRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.ICollectionService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemPriceService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfService;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemPriceEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CollectionExtApiImpl
implements ICollectionExtApi {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IContext context;
    @Resource(name="${project.domain.prefix:tcbj}ItemQueryApi")
    private IItemQueryApi itemQueryApi;
    @Resource
    private ICollectionService collectionService;
    @Resource(name="${project.domain.prefix:tcbj}ShelfService")
    private IShelfService shelfService;
    @Resource
    private IItemShelfService itemShelfService;
    @Resource
    private IItemPriceService itemPriceService;

    public RestResponse<CollectionItemRespDto> addItem(CollectionItemQueryDto collectionItemQueryDto) {
        Long tenantId = this.context.tenantId();
        Long instanceId = this.context.instanceId();
        Long userId = this.context.userId();
        List itemRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryByItemIds(String.join((CharSequence)",", Long.toString(collectionItemQueryDto.getItemId()))));
        if (CollectionUtils.isEmpty((Collection)itemRespDtoList)) {
            throw new BizException(ItemExceptionCode.NON_EXIST_ITEM.getCode(), "itemId=" + collectionItemQueryDto.getItemId() + "\u4e0d\u5b58\u5728");
        }
        ItemRespDto itemRespDto = (ItemRespDto)itemRespDtoList.get(0);
        CollectionRespDto collectionRespDto = this.getUserCollect(userId);
        if (null == collectionRespDto) {
            throw new BizException("\u7528\u6237\u6536\u85cf\u4e0d\u5b58\u5728");
        }
        CollectionItemReqDto collectionItemReqDto = new CollectionItemReqDto();
        collectionItemReqDto.setTenantId(tenantId);
        collectionItemReqDto.setInstanceId(instanceId);
        collectionItemReqDto.setCollectionId(collectionRespDto.getId());
        collectionItemReqDto.setItemSrc("icommerce");
        collectionItemReqDto.setItemSerial(String.valueOf(collectionItemQueryDto.getItemId()));
        collectionItemReqDto.setItemName(collectionItemQueryDto.getItemName());
        collectionItemReqDto.setShopSerial(itemRespDto.getShopId() == null ? null : Long.toString(itemRespDto.getShopId()));
        collectionItemReqDto.setShopName(collectionItemQueryDto == null ? null : collectionItemQueryDto.getShopName());
        collectionItemReqDto.setGroupKey(itemRespDto.getShopId() == null ? null : Long.toString(itemRespDto.getShopId()));
        collectionItemReqDto.setAddChannel(collectionItemQueryDto.getAddChannel());
        collectionItemReqDto.setCollectionType("item");
        return this.collectionService.addCollectionItem(collectionItemReqDto);
    }

    public RestResponse<Void> removeItem(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            throw new BizException(ItemExceptionCode.NON_EXIST_ITEM.getCode(), "ids=" + ids + "\u4e0d\u5b58\u5728");
        }
        List<String> collectionIds = Arrays.asList(ids.split(","));
        collectionIds.forEach(v -> this.collectionService.removeCollectionItem(Long.valueOf(v)));
        return new RestResponse();
    }

    public RestResponse<Void> removeSingleItem(String itemId, String shopId) {
        CollectionRespDto userCollect = this.getUserCollect(this.context.userId());
        Long collectId = userCollect.getId();
        this.collectionService.removeItem(itemId, shopId, collectId);
        return new RestResponse();
    }

    public RestResponse<Boolean> queryCollected(Long itemId, Long shopId) {
        return new RestResponse((Object)this.collectionService.queryCollected(itemId, shopId));
    }

    public RestResponse<PageInfo<ItemRespDto>> queryCollectionItem(Integer pageNum, Integer pageSize) {
        PageInfo pageInfo = new PageInfo();
        ArrayList itemRespDtos = new ArrayList();
        PageInfo<CollectionItemRespDto> CollectionItemPageInfo = this.collectionService.queryCollectionItem(this.context.userId(), pageNum, pageSize);
        List collectionItems = CollectionItemPageInfo.getList();
        if (CollectionUtil.isEmpty((Collection)collectionItems)) {
            return new RestResponse((Object)pageInfo);
        }
        List collectionItemIds = collectionItems.stream().map(CollectionItemRespDto::getId).collect(Collectors.toList());
        List shopIdStrings = collectionItems.stream().map(CollectionItemRespDto::getShopSerial).collect(Collectors.toList());
        List itemBCTimes = collectionItems.stream().map(BaseRespDto::getUpdateTime).collect(Collectors.toList());
        List shopIds = shopIdStrings.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        CubeBeanUtils.copyCollection(itemRespDtos, (Collection)collectionItems, ItemRespDto.class);
        for (int i = 0; i < itemRespDtos.size(); ++i) {
            ItemSkuRespDto itemSkuRespDto2;
            ((ItemRespDto)itemRespDtos.get(i)).setId(Long.valueOf(Long.parseLong(((CollectionItemRespDto)collectionItems.get(i)).getItemSerial())));
            ((ItemRespDto)itemRespDtos.get(i)).setItemBCId((Long)collectionItemIds.get(i));
            ((ItemRespDto)itemRespDtos.get(i)).setItemId(Long.valueOf(Long.parseLong(((CollectionItemRespDto)collectionItems.get(i)).getItemSerial())));
            ((ItemRespDto)itemRespDtos.get(i)).setName(((CollectionItemRespDto)collectionItems.get(i)).getItemName());
            ((ItemRespDto)itemRespDtos.get(i)).setShopId((Long)shopIds.get(i));
            ((ItemRespDto)itemRespDtos.get(i)).setItemBCTime((Date)itemBCTimes.get(i));
            List itemMediaList = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemMediasByItemId(((ItemRespDto)itemRespDtos.get(i)).getItemId()));
            ((ItemRespDto)itemRespDtos.get(i)).setItemMediasList(itemMediaList);
            ((ItemRespDto)itemRespDtos.get(i)).setMainPic(((ItemMediasRespDto)itemMediaList.get(0)).getPath1());
            List itemSkuList = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemSkuByItemId(((ItemRespDto)itemRespDtos.get(i)).getId()));
            for (ItemSkuRespDto itemSkuRespDto2 : itemSkuList) {
                ArrayList itemPriceDtos = Lists.newArrayList();
                ItemPriceEo itemPriceEo = new ItemPriceEo();
                itemPriceEo.setItemId(((ItemRespDto)itemRespDtos.get(i)).getItemId());
                itemPriceEo.setSkuId(itemSkuRespDto2.getId());
                List<ItemPriceEo> itemPriceEos = this.itemPriceService.queryItemPrice(itemPriceEo);
                DtoHelper.eoList2DtoList(itemPriceEos, (Collection)itemPriceDtos, ItemPriceRespDto.class);
                itemSkuRespDto2.setItemPriceList((List)itemPriceDtos);
            }
            ((ItemRespDto)itemRespDtos.get(i)).setItemSkuList(itemSkuList);
            ShelfReqDto shelfReqDto = new ShelfReqDto();
            itemSkuRespDto2 = (ItemSkuRespDto)((ItemRespDto)itemRespDtos.get(i)).getItemSkuList().get(0);
            shelfReqDto.setSkuId(itemSkuRespDto2.getId());
            shelfReqDto.setShopId(((ItemRespDto)itemRespDtos.get(i)).getShopId());
            ItemShelfRespDto itemShelfRespDto = this.shelfService.queryItemShelf(shelfReqDto);
            if (itemShelfRespDto == null) continue;
            ((ItemRespDto)itemRespDtos.get(i)).setShelfType(itemShelfRespDto.getType());
            ((ItemRespDto)itemRespDtos.get(i)).setBusType(itemShelfRespDto.getBusType());
        }
        pageInfo.setList(itemRespDtos);
        pageInfo.setPageNum(pageNum.intValue());
        pageInfo.setPageSize(pageSize.intValue());
        return new RestResponse((Object)pageInfo);
    }

    public RestResponse<PageInfo<ItemRespDto>> queryCollectionOffShelfItem(Integer pageNum, Integer pageSize) {
        PageInfo pageInfo = new PageInfo();
        ArrayList itemRespDtoList = new ArrayList();
        PageInfo itemRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData(this.queryCollectionItem(pageNum, pageSize));
        List itemRespDtos = itemRespDtoPageInfo.getList();
        if (CollectionUtil.isEmpty((Collection)itemRespDtos)) {
            return new RestResponse();
        }
        itemRespDtos.forEach(itemRespDto -> {
            boolean offShelf = this.itemShelfService.allOffShelf2(itemRespDto.getItemId(), itemRespDto.getShopId());
            if (offShelf) {
                itemRespDtoList.add(itemRespDto);
            }
        });
        pageInfo.setList(itemRespDtoList);
        return new RestResponse((Object)pageInfo);
    }

    private CollectionRespDto getUserCollect(Long userId) {
        CollectionRespDto collectionDto = (CollectionRespDto)this.collectionService.getCollection(this.context.tenantId(), this.context.instanceId(), "icommerce", String.valueOf(userId), "item", 1).getData();
        return collectionDto;
    }
}

