/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.SellerSkuPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.SellerSkuPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.service.ISellerSkuPriceService;
import com.dtyunxi.yundt.cube.center.item.dao.das.SellerSkuPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.SellerSkuPriceEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.StdSellerSkuPriceEo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SellerSkuPriceServiceImpl
implements ISellerSkuPriceService {
    private static final Logger logger = LoggerFactory.getLogger(SellerSkuPriceServiceImpl.class);
    @Resource
    private SellerSkuPriceDas sellerSkuPriceDas;

    @Override
    public Long addSellerSkuPrice(SellerSkuPriceReqDto addReqDto) {
        SellerSkuPriceEo sellerSkuPriceEo = new SellerSkuPriceEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)sellerSkuPriceEo);
        this.sellerSkuPriceDas.insert((BaseEo)sellerSkuPriceEo);
        return sellerSkuPriceEo.getId();
    }

    @Override
    public void modifySellerSkuPrice(SellerSkuPriceReqDto modifyReqDto) {
        SellerSkuPriceEo sellerSkuPriceEo = new SellerSkuPriceEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)sellerSkuPriceEo);
        this.sellerSkuPriceDas.updateSelective((BaseEo)sellerSkuPriceEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSellerSkuPrice(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.sellerSkuPriceDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SellerSkuPriceRespDto queryById(Long id) {
        SellerSkuPriceEo sellerSkuPriceEo = (SellerSkuPriceEo)this.sellerSkuPriceDas.selectByPrimaryKey(id);
        SellerSkuPriceRespDto sellerSkuPriceRespDto = new SellerSkuPriceRespDto();
        DtoHelper.eo2Dto((BaseEo)sellerSkuPriceEo, (BaseVo)sellerSkuPriceRespDto);
        return sellerSkuPriceRespDto;
    }

    @Override
    public PageInfo<SellerSkuPriceRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SellerSkuPriceReqDto sellerSkuPriceReqDto = (SellerSkuPriceReqDto)JSON.parseObject((String)filter, SellerSkuPriceReqDto.class);
        SellerSkuPriceEo sellerSkuPriceEo = new SellerSkuPriceEo();
        DtoHelper.dto2Eo((BaseVo)sellerSkuPriceReqDto, (BaseEo)sellerSkuPriceEo);
        PageInfo eoPageInfo = this.sellerSkuPriceDas.selectPage((BaseEo)sellerSkuPriceEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        return dtoPageInfo;
    }

    @Override
    public BigDecimal queryPrice(Long sellerId, Long skuId) {
        BigDecimal price = ((SellerSkuPriceEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.sellerSkuPriceDas.filter().eq((Object)"seller_id", (Object)sellerId)).eq((Object)"sku_id", (Object)skuId)).one()).getSupplyPrice();
        return price;
    }

    @Override
    public SellerSkuPriceEo queryByItemId(Long itemId) {
        return (SellerSkuPriceEo)((ExtQueryChainWrapper)this.sellerSkuPriceDas.filter().eq((Object)"item_id", (Object)itemId)).one();
    }

    @Override
    public Long updatePrice(SellerSkuPriceReqDto sellerSkuPriceReqDto) {
        SellerSkuPriceEo sellerSkuPriceEo = new SellerSkuPriceEo();
        DtoHelper.dto2Eo((BaseVo)sellerSkuPriceReqDto, (BaseEo)sellerSkuPriceEo);
        return this.sellerSkuPriceDas.updatePrice(sellerSkuPriceEo);
    }

    @Override
    public List<SellerSkuPriceRespDto> queryList(SellerSkuPriceReqDto sellerSkuPriceReqDto) {
        SellerSkuPriceEo sellerSkuPriceEo = new SellerSkuPriceEo();
        DtoHelper.dto2Eo((BaseVo)sellerSkuPriceReqDto, (BaseEo)sellerSkuPriceEo);
        sellerSkuPriceEo.setDr(0);
        List customerIdList = sellerSkuPriceReqDto.getCustomerIdList();
        List skuIdList = sellerSkuPriceReqDto.getSkuIdList();
        List itemIdList = sellerSkuPriceReqDto.getItemIdList();
        List sellerIdList = sellerSkuPriceReqDto.getSellerIdList();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)sellerSkuPriceEo);
        if (CollUtil.isNotEmpty((Collection)customerIdList)) {
            queryWrapper.in(StdSellerSkuPriceEo::getCustomerId, (Collection)customerIdList);
        }
        if (CollUtil.isNotEmpty((Collection)skuIdList)) {
            queryWrapper.in(StdSellerSkuPriceEo::getSkuId, (Collection)skuIdList);
        }
        if (CollUtil.isNotEmpty((Collection)itemIdList)) {
            queryWrapper.in(StdSellerSkuPriceEo::getItemId, (Collection)itemIdList);
        }
        if (CollUtil.isNotEmpty((Collection)sellerIdList)) {
            queryWrapper.in(StdSellerSkuPriceEo::getSellerId, (Collection)sellerIdList);
        }
        List sellerSkuPriceEos = this.sellerSkuPriceDas.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<SellerSkuPriceRespDto> dtoList = new ArrayList<SellerSkuPriceRespDto>();
        DtoHelper.eoList2DtoList((Collection)sellerSkuPriceEos, dtoList, SellerSkuPriceRespDto.class);
        return dtoList;
    }

    @Override
    public List<SellerSkuPriceRespDto> queryListByCustomerIdsAndItemIds(List<Long> customerIdList, List<Long> itemIdList) {
        SellerSkuPriceEo sellerSkuPriceEo = new SellerSkuPriceEo();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)sellerSkuPriceEo).select(new SFunction[]{StdSellerSkuPriceEo::getCustomerId, StdSellerSkuPriceEo::getItemId});
        if (CollUtil.isNotEmpty(customerIdList)) {
            queryWrapper.in(StdSellerSkuPriceEo::getCustomerId, customerIdList);
        }
        if (CollUtil.isNotEmpty(itemIdList)) {
            queryWrapper.in(StdSellerSkuPriceEo::getItemId, itemIdList);
        }
        List sellerSkuPriceEos = this.sellerSkuPriceDas.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<SellerSkuPriceRespDto> dtoList = new ArrayList<SellerSkuPriceRespDto>();
        DtoHelper.eoList2DtoList((Collection)sellerSkuPriceEos, dtoList, SellerSkuPriceRespDto.class);
        return dtoList;
    }

    @Override
    public SellerSkuPriceRespDto queryListByCustomerIdAndItemId(Long customerId, Long itemId) {
        if (customerId == null || itemId == null) {
            logger.info("\u4f9b\u5e94\u5546\u548c\u4ea7\u54c1\u7684\u4f9b\u8d27\u4ef7\u683c\uff0c\u53c2\u6570\u5f02\u5e38");
            return null;
        }
        SellerSkuPriceEo sellerSkuPriceEo = new SellerSkuPriceEo();
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)sellerSkuPriceEo);
        queryWrapper.eq(StdSellerSkuPriceEo::getCustomerId, (Object)customerId);
        queryWrapper.eq(StdSellerSkuPriceEo::getItemId, (Object)itemId);
        sellerSkuPriceEo = (SellerSkuPriceEo)this.sellerSkuPriceDas.getMapper().selectOne((Wrapper)queryWrapper);
        if (sellerSkuPriceEo == null) {
            logger.info("\u67e5\u8be2\u4ef7\u683c\u6570\u636e\u6ca1\u6709\uff0c\u8fd4\u56de\u4e3a\u7a7a");
            return null;
        }
        SellerSkuPriceRespDto sellerSkuPriceRespDto = new SellerSkuPriceRespDto();
        DtoHelper.eo2Dto((BaseEo)sellerSkuPriceEo, (BaseVo)sellerSkuPriceRespDto);
        return sellerSkuPriceRespDto;
    }

    @Override
    public void addBatchPriceList(List<SellerSkuPriceReqDto> addList) {
        ArrayList sellerSkuPriceEoList = Lists.newArrayList();
        DtoHelper.dtoList2EoList(addList, (Collection)sellerSkuPriceEoList, SellerSkuPriceEo.class);
        this.sellerSkuPriceDas.getMapper().insertBatch((List)sellerSkuPriceEoList);
    }

    @Override
    public void addBatchPriceEoList(List<SellerSkuPriceEo> addList) {
        if (CollectionUtils.isEmpty(addList)) {
            return;
        }
        this.sellerSkuPriceDas.updateOrInsert(addList);
    }

    @Override
    public void updateBatchPrice(List<SellerSkuPriceReqDto> addList) {
        ArrayList sellerSkuPriceEoList = Lists.newArrayList();
        DtoHelper.dtoList2EoList(addList, (Collection)sellerSkuPriceEoList, SellerSkuPriceEo.class);
        this.sellerSkuPriceDas.updateBatchPriceNew((List)sellerSkuPriceEoList);
    }
}

