/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.ItemAuthService;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.ItemAuthDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.ItemAuthEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBListRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.dto.request.ItemBlackReqDto;
import com.yx.tcbj.center.api.dto.request.ItemShopReqDto;
import com.yx.tcbj.center.api.dto.response.ItemBlackAuthRespDto;
import com.yx.tcbj.center.biz.service.IItemBlackExtService;
import com.yx.tcbj.center.biz.util.AssertUtil;
import com.yx.tcbj.center.biz.util.EasyPoiExportUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IItemBlackExtServiceImpl
implements IItemBlackExtService {
    private static Logger logger = LoggerFactory.getLogger(IItemBlackExtServiceImpl.class);
    @Resource
    private ItemDas itemDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemAuthDas itemAuthDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private ItemAuthService itemAuthService;

    @Override
    public ItemBlackAuthRespDto importBlackItem(String url) {
        ItemBlackAuthRespDto itemBlackRespDto = new ItemBlackAuthRespDto();
        AssertUtil.assertNotBlank(url, "\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        Long currentUserOrgId = this.getCurrentUserOrgId();
        if (currentUserOrgId == null) {
            throw new BizException("\u7ec4\u7ec7id\u4e3a\u7a7a");
        }
        List<Long> shopIdList = this.getShopIdList(currentUserOrgId);
        List itemBlackReqDtoList = null;
        long totalNum = 0L;
        try {
            InputStream is = this.getInputStream(url);
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, ItemBlackReqDto.class);
            itemBlackReqDtoList = objectExcelImportResult.getList();
            totalNum = itemBlackReqDtoList.size();
            itemBlackRespDto.setTotal(Long.valueOf(totalNum));
            if (CollectionUtils.isEmpty((Collection)itemBlackReqDtoList)) {
                itemBlackRespDto.setFailNum(Long.valueOf(totalNum));
                itemBlackRespDto.setFailFileUrl(this.uploadOssFile(itemBlackReqDtoList));
                return itemBlackRespDto;
            }
        }
        catch (Exception e2) {
            throw new BizException("\u5bfc\u5165\u5546\u54c1\u7f16\u7801\u5217\u8868\u89e3\u6790\u5931\u8d25\uff1a" + e2.getMessage());
        }
        itemBlackReqDtoList.removeAll(Collections.singleton(null));
        if (CollectionUtils.isEmpty((Collection)itemBlackReqDtoList)) {
            itemBlackRespDto.setFailNum(Long.valueOf(totalNum));
            itemBlackRespDto.setFailFileUrl(this.uploadOssFile(itemBlackReqDtoList));
            return itemBlackRespDto;
        }
        List<String> itemCodeList = itemBlackReqDtoList.stream().filter(e -> StringUtils.isNotEmpty((String)e.getItemCode())).map(ItemBlackReqDto::getItemCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemCodeList)) {
            itemBlackRespDto.setFailNum(Long.valueOf(totalNum));
            itemBlackRespDto.setFailFileUrl(this.uploadOssFile(itemBlackReqDtoList));
            return itemBlackRespDto;
        }
        List<ItemEo> itemEoList = this.queryByItemCodes(itemCodeList);
        if (CollectionUtils.isEmpty(itemEoList)) {
            itemBlackRespDto.setFailNum(Long.valueOf(totalNum));
            itemBlackRespDto.setFailFileUrl(this.uploadOssFile(itemBlackReqDtoList));
            return itemBlackRespDto;
        }
        return this.getItemBlackAuthRespDto(url, itemBlackRespDto, shopIdList, totalNum, itemCodeList, itemEoList);
    }

    @Override
    public ItemBlackAuthRespDto importShopItem(String url) {
        ItemBlackAuthRespDto itemBlackRespDto = new ItemBlackAuthRespDto();
        AssertUtil.assertNotBlank(url, "\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        Long currentUserOrgId = this.getCurrentUserOrgId();
        if (currentUserOrgId == null) {
            throw new BizException("\u7ec4\u7ec7id\u4e3a\u7a7a");
        }
        List<Long> shopIdList = this.getShopIdList(currentUserOrgId);
        List itemBlackReqDtoList = null;
        long totalNum = 0L;
        try {
            InputStream is = this.getInputStream(url);
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, ItemShopReqDto.class);
            itemBlackReqDtoList = objectExcelImportResult.getList();
            totalNum = itemBlackReqDtoList.size();
            itemBlackRespDto.setTotal(Long.valueOf(totalNum));
            if (CollectionUtils.isEmpty((Collection)itemBlackReqDtoList)) {
                itemBlackRespDto.setFailNum(Long.valueOf(totalNum));
                itemBlackRespDto.setFailFileUrl(url);
                return itemBlackRespDto;
            }
        }
        catch (Exception e2) {
            throw new BizException("\u5bfc\u5165\u5546\u54c1\u7f16\u7801\u5217\u8868\u89e3\u6790\u5931\u8d25\uff1a" + e2.getMessage());
        }
        itemBlackReqDtoList.removeAll(Collections.singleton(null));
        if (CollectionUtils.isEmpty((Collection)itemBlackReqDtoList)) {
            itemBlackRespDto.setFailNum(Long.valueOf(totalNum));
            itemBlackRespDto.setFailFileUrl(this.dealWithFailUrl(itemBlackReqDtoList));
            return itemBlackRespDto;
        }
        Map shopReqDtoMap = itemBlackReqDtoList.stream().filter(e -> StringUtils.isNotEmpty((String)e.getItemCode())).collect(Collectors.toMap(ItemShopReqDto::getItemCode, Function.identity(), (v1, v2) -> v1));
        Set<String> itemCodeSet = shopReqDtoMap.keySet();
        if (CollectionUtils.isEmpty(itemCodeSet)) {
            itemBlackRespDto.setFailNum(Long.valueOf(totalNum));
            itemBlackRespDto.setFailFileUrl(this.dealWithFailUrl(itemBlackReqDtoList));
            return itemBlackRespDto;
        }
        List<ItemEo> itemEoList = this.queryByItemCodes(Lists.newArrayList(itemCodeSet));
        if (CollectionUtils.isEmpty(itemEoList)) {
            itemBlackRespDto.setFailNum(Long.valueOf(totalNum));
            itemBlackRespDto.setFailFileUrl(this.dealWithFailUrl(itemBlackReqDtoList));
            return itemBlackRespDto;
        }
        long[] failNum = new long[]{0L};
        ArrayList failList = Lists.newArrayList();
        Map itemEoMap = itemEoList.stream().collect(Collectors.toMap(StdItemEo::getCode, Function.identity(), (v1, v2) -> v1));
        Map itemMapId = itemEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v1));
        Map<Long, ItemAuthEo> itemAuthEoMap = this.queryByAuthItem(Lists.newArrayList(itemMapId.keySet()), shopIdList.get(0));
        if (itemAuthEoMap == null) {
            itemBlackRespDto.setFailNum(Long.valueOf(totalNum));
            itemBlackRespDto.setFailFileUrl(this.dealWithFailUrl(itemBlackReqDtoList));
            return itemBlackRespDto;
        }
        shopReqDtoMap.keySet().forEach(itemCode -> {
            ItemShopReqDto itemBlackReqDto = new ItemShopReqDto();
            itemBlackReqDto.setItemCode(itemCode);
            ItemShopReqDto itemShopReqDto = (ItemShopReqDto)shopReqDtoMap.get(itemCode);
            if (StringUtils.isBlank((String)itemShopReqDto.getEasCode())) {
                failNum[0] = failNum[0] + 1L;
                itemBlackReqDto.setFailMsg("\u5916\u90e8\u7f16\u7801\u4e3a\u7a7a");
                failList.add(itemBlackReqDto);
            } else {
                ItemEo itemEo = (ItemEo)itemEoMap.get(itemCode);
                if (itemEo == null) {
                    failNum[0] = failNum[0] + 1L;
                    itemBlackReqDto.setFailMsg("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
                    failList.add(itemBlackReqDto);
                } else {
                    ItemAuthEo itemAuthEo = (ItemAuthEo)itemAuthEoMap.get(itemEo.getId());
                    if (itemAuthEo == null) {
                        failNum[0] = failNum[0] + 1L;
                        itemBlackReqDto.setFailMsg("\u5546\u54c1\u4fe1\u606f\u672a\u6388\u6743");
                        failList.add(itemBlackReqDto);
                    } else {
                        itemAuthEo.setExternalCode(itemShopReqDto.getEasCode());
                        this.itemAuthDas.updateSelective((BaseEo)itemAuthEo);
                    }
                }
            }
        });
        itemBlackRespDto.setFailNum(Long.valueOf(failNum[0]));
        itemBlackRespDto.setSuccessNum(Long.valueOf(totalNum - failNum[0]));
        if (CollectionUtils.isNotEmpty((Collection)failList)) {
            itemBlackRespDto.setFailFileUrl(this.dealWithFailUrl(failList));
        }
        return itemBlackRespDto;
    }

    private ItemBlackAuthRespDto getItemBlackAuthRespDto(String url, ItemBlackAuthRespDto itemBlackRespDto, List<Long> shopIdList, long totalNum, List<String> itemCodeList, List<ItemEo> itemEoList) {
        long failNum = 0L;
        ArrayList failList = Lists.newArrayList();
        ArrayList successItemCodeList = Lists.newArrayList();
        Map itemEoMap = itemEoList.stream().collect(Collectors.toMap(StdItemEo::getCode, Function.identity(), (v1, v2) -> v1));
        Map itemMapId = itemEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v1));
        Map<Long, ItemAuthEo> itemAuthEoMap = this.queryByAuthItem(Lists.newArrayList(itemMapId.keySet()), shopIdList.get(0));
        if (itemAuthEoMap == null) {
            itemBlackRespDto.setFailNum(Long.valueOf(totalNum));
            itemBlackRespDto.setFailFileUrl(url);
            return itemBlackRespDto;
        }
        for (String itemCode : itemCodeList) {
            ItemBlackReqDto itemBlackReqDto = new ItemBlackReqDto();
            itemBlackReqDto.setItemCode(itemCode);
            ItemEo itemEo = (ItemEo)itemEoMap.get(itemCode);
            if (itemEo == null) {
                ++failNum;
                itemBlackReqDto.setFailMsg("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
                failList.add(itemBlackReqDto);
                continue;
            }
            ItemAuthEo itemAuthEo = itemAuthEoMap.get(itemEo.getId());
            if (itemAuthEo == null) {
                ++failNum;
                itemBlackReqDto.setFailMsg("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
                failList.add(itemBlackReqDto);
                continue;
            }
            successItemCodeList.add(itemCode);
        }
        itemBlackRespDto.setFailNum(Long.valueOf(failNum));
        itemBlackRespDto.setSuccessNum(Long.valueOf(totalNum - failNum));
        if (CollectionUtils.isNotEmpty((Collection)failList)) {
            itemBlackRespDto.setFailFileUrl(this.uploadOssFile(failList));
        }
        if (CollectionUtils.isNotEmpty((Collection)successItemCodeList)) {
            ItemAuthQueryReqDto itemAuthQueryReqDto = new ItemAuthQueryReqDto();
            itemAuthQueryReqDto.setShopId(shopIdList.get(0));
            itemAuthQueryReqDto.setPageNum(Integer.valueOf(1));
            itemAuthQueryReqDto.setTargetType(Integer.valueOf(2));
            itemAuthQueryReqDto.setPageSize(Integer.valueOf(itemCodeList.size()));
            PageInfo respDtoPageInfo = this.itemAuthService.queryItemAuthPage(itemAuthQueryReqDto);
            itemBlackRespDto.setItemAuthQueryRespDtoList(respDtoPageInfo.getList());
        }
        return itemBlackRespDto;
    }

    private List<Long> getShopIdList(Long currentUserOrgId) {
        ShopToBQueryReqDto shopToBQueryReqDto = new ShopToBQueryReqDto();
        shopToBQueryReqDto.setOrganizationIdList((List)Lists.newArrayList((Object[])new Long[]{currentUserOrgId}));
        shopToBQueryReqDto.setPageNum(1);
        shopToBQueryReqDto.setPageSize(1);
        RestResponse shopRestResponse = this.shopExtQueryApi.queryPage(shopToBQueryReqDto);
        List<Long> shopIdList = ((PageInfo)RestResponseHelper.extractData((RestResponse)shopRestResponse)).getList().stream().map(ShopToBListRespDto::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(shopIdList)) {
            throw new BizException("\u5e97\u94fa\u4e0d\u5b58\u5728");
        }
        return shopIdList;
    }

    private String uploadOssFile(List<ItemBlackReqDto> failList) {
        String exportUrl = EasyPoiExportUtil.getExportUrl(failList, ItemBlackReqDto.class, null, "\u5bfc\u5165\u5546\u54c1\u5931\u8d25\u6587\u4ef6" + DateFormatUtils.format((Date)new Date(), (String)"yyMMddHHmmss"), "xls");
        return exportUrl;
    }

    private List<ItemEo> queryByItemCodes(List<String> itemCodeList) {
        ItemEo itemEo = new ItemEo();
        LambdaQueryWrapper itemEoLambdaQueryWrapper = Wrappers.lambdaQuery((Object)itemEo);
        itemEoLambdaQueryWrapper.in(StdItemEo::getCode, itemCodeList);
        return this.itemDas.getMapper().selectList((Wrapper)itemEoLambdaQueryWrapper);
    }

    public Long getCurrentUserOrgId() {
        return (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCurrentUserOrgId());
    }

    private Map<Long, ItemAuthEo> queryByAuthItem(List<Long> itemIdList, Long shopId) {
        ItemSkuEo itemSkuEo = new ItemSkuEo();
        LambdaQueryWrapper itemSkuEoLambdaQueryWrapper = Wrappers.lambdaQuery((Object)itemSkuEo);
        itemSkuEoLambdaQueryWrapper.in(StdItemSkuEo::getItemId, itemIdList);
        List itemSkuEoList = this.itemSkuDas.getMapper().selectList((Wrapper)itemSkuEoLambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)itemSkuEoList)) {
            return null;
        }
        Map longItemSkuEoMap = itemSkuEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v1));
        ArrayList skuIdList = Lists.newArrayList(longItemSkuEoMap.keySet());
        ItemAuthEo itemAuthEo = new ItemAuthEo();
        LambdaQueryWrapper itemAuthEoLambdaQueryWrapper = Wrappers.lambdaQuery((Object)itemAuthEo);
        itemAuthEoLambdaQueryWrapper.in(ItemAuthEo::getBusinessId, (Collection)skuIdList);
        itemAuthEoLambdaQueryWrapper.eq(ItemAuthEo::getTargetId, (Object)shopId);
        itemAuthEoLambdaQueryWrapper.eq(ItemAuthEo::getTargetType, (Object)2);
        List itemAuthEoList = this.itemAuthDas.getMapper().selectList((Wrapper)itemAuthEoLambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)itemAuthEoList)) {
            return null;
        }
        HashMap<Long, ItemAuthEo> itemAuthEoMap = new HashMap<Long, ItemAuthEo>();
        for (ItemAuthEo authEo : itemAuthEoList) {
            ItemSkuEo skuEo = (ItemSkuEo)longItemSkuEoMap.get(authEo.getBusinessId());
            if (skuEo == null) continue;
            itemAuthEoMap.put(skuEo.getItemId(), authEo);
        }
        return itemAuthEoMap;
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    private String dealWithFailUrl(List<ItemShopReqDto> itemBlackReqDtoList) {
        String exportUrl = EasyPoiExportUtil.getExportUrl(itemBlackReqDtoList, ItemShopReqDto.class, null, "\u5bfc\u5165\u5546\u54c1\u5931\u8d25\u6587\u4ef6" + DateFormatUtils.format((Date)new Date(), (String)"yyMMddHHmmss"), "xls");
        return exportUrl;
    }
}

