/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.AuthItemRuleTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.ItemAuthEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.AuthItemRuleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.BlackAuthItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerAuthItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthConfigReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.AuthItemRuleRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthConfigRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuListRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.IAuthItemRuleService;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.ItemAuthConfigService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdDirEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.constants.YesOrNoEnum;
import com.yx.tcbj.center.api.dto.request.ItemAuthBatchReqDto;
import com.yx.tcbj.center.api.dto.request.ItemAuthExtQueryReqDto;
import com.yx.tcbj.center.biz.service.IItemAuthExpandService;
import com.yx.tcbj.center.biz.service.impl.IItemSycnExtServiceImpl;
import com.yx.tcbj.center.biz.util.AssertUtil;
import com.yx.tcbj.center.dao.das.ItemAuthExtDas;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemAuthExpandServiceImpl
implements IItemAuthExpandService {
    private static Logger logger = LoggerFactory.getLogger(ItemAuthExpandServiceImpl.class);
    @Resource
    private IItemSycnExtServiceImpl itemSycnExtService;
    @Resource
    private IContext context;
    @Resource
    private ItemAuthExtDas itemAuthExtDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource(name="directoryItemQueryApi")
    private IDirectoryQueryApi directoryQueryApi;
    @Resource
    private DirDas dirDas;
    @Resource
    private HttpServletRequest request;
    @Resource
    private IAuthItemRuleService authItemRuleService;
    @Resource
    private IItemService itemService;
    @Resource
    private ItemAuthConfigService itemAuthConfigService;
    public static ExecutorService executorService = new ThreadPoolExecutor(12, 20, 30L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10000), new ThreadPoolExecutor.CallerRunsPolicy());
    private static final Integer batchNum = 100;

    public Long tenantId() {
        Long tenantId = this.context.tenantId();
        logger.info("tenantId >>> {}", (Object)tenantId);
        if (null == tenantId) {
            tenantId = 1L;
        }
        return tenantId;
    }

    public Long instanceId() {
        Long instanceId = this.context.instanceId();
        logger.info("instanceId >>> {}", (Object)instanceId);
        if (null == instanceId) {
            instanceId = 1254039287584232622L;
        }
        return instanceId;
    }

    public String headerOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void btachCustomerItemAuth(ItemAuthBatchReqDto itemAuthBatchReqDto) {
        logger.info("\u6279\u91cf\u5ba2\u6237\u5546\u54c1\u6388\u6743\u5165\u53c2=={}", (Object)itemAuthBatchReqDto.toString());
        AssertUtil.assertNotNull(itemAuthBatchReqDto, "\u5fc5\u4f20\u53c2\u6570DTO\u4e3a\u7a7a");
        AssertUtil.assertNotNull(itemAuthBatchReqDto.getTargetType(), "\u5fc5\u4f20\u53c2\u6570[TargetType]\u4e3a\u7a7a");
        AssertUtil.assertNotBlank(itemAuthBatchReqDto.getBusinessType(), "\u5fc5\u4f20\u53c2\u6570[BusinessType]\u4e3a\u7a7a");
        AssertUtil.assertNotEmpty(itemAuthBatchReqDto.getTargetIdList(), "\u5fc5\u4f20\u53c2\u6570[TargetIdList]\u4e3a\u7a7a");
        AssertUtil.assertNotEmpty(itemAuthBatchReqDto.getBusinessIdList(), "\u5fc5\u4f20\u53c2\u6570[BusinessIdList]\u4e3a\u7a7a");
        Long tenantId = this.tenantId();
        Long instanceId = this.instanceId();
        ArrayList updateDtoList = Lists.newArrayList();
        for (Long targetId : itemAuthBatchReqDto.getTargetIdList()) {
            for (Long businessId : itemAuthBatchReqDto.getBusinessIdList()) {
                ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
                itemAuthReqDto.setTargetType(itemAuthBatchReqDto.getTargetType());
                itemAuthReqDto.setTargetId(targetId);
                itemAuthReqDto.setBusinessType(itemAuthBatchReqDto.getBusinessType());
                itemAuthReqDto.setBusinessId(businessId);
                itemAuthReqDto.setStatus(!Objects.equals(itemAuthBatchReqDto.getStatus(), 0) ? YesOrNoEnum.YES.getCode() : YesOrNoEnum.NO.getCode());
                itemAuthReqDto.setInstanceId(instanceId);
                itemAuthReqDto.setTenantId(tenantId);
                updateDtoList.add(itemAuthReqDto);
            }
        }
        this.itemSycnExtService.updateOrInsertItemAuth(updateDtoList);
        try {
            this.updateOrInsertItemAuthRule(updateDtoList);
        }
        catch (Exception e) {
            logger.info("\u6279\u91cf\u66f4\u65b0\u5546\u54c1\u6388\u6743\u89c4\u5219\u8868\u5f02\u5e38", (Object)e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateOrInsertItemAuthRule(List<ItemAuthReqDto> dtoList) {
        logger.info("\u6279\u91cf\u66f4\u65b0\u5546\u54c1\u6388\u6743\u89c4\u5219\u8868={}", (Object)JSON.toJsonString(dtoList));
        if (CollectionUtils.isEmpty(dtoList)) {
            logger.info("\u65e0\u6570\u636e\u5904\u7406");
            return false;
        }
        Set targetIdSet = dtoList.stream().map(ItemAuthReqDto::getTargetId).collect(Collectors.toSet());
        AuthItemRuleReqDto authItemRuleReqDto = new AuthItemRuleReqDto();
        authItemRuleReqDto.setCustomerIdList(new ArrayList(targetIdSet));
        List authItemRuleRespDtos = this.authItemRuleService.queryParam(authItemRuleReqDto);
        Map<Object, Object> itemRuleMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)authItemRuleRespDtos)) {
            itemRuleMap = authItemRuleRespDtos.stream().collect(Collectors.toMap(AuthItemRuleRespDto::getCustomerId, Function.identity(), (k1, k2) -> k1));
        }
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(new ArrayList(targetIdSet)));
        Map<Object, Object> customerInfoMap = new HashMap();
        List<Object> authConfigIdList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
            customerInfoMap = customerRespDtos.stream().collect(Collectors.toMap(BaseRespDto::getId, Function.identity()));
            Set thirdParentPartyIdList = customerRespDtos.stream().map(CustomerRespDto::getThirdParentPartyId).collect(Collectors.toSet());
            ItemAuthConfigReqDto itemAuthConfigReqDto = new ItemAuthConfigReqDto();
            itemAuthConfigReqDto.setThirdPartyIdList(new ArrayList(thirdParentPartyIdList));
            List itemAuthConfigRespDtos = this.itemAuthConfigService.queryParam(itemAuthConfigReqDto);
            if (CollectionUtils.isNotEmpty((Collection)itemAuthConfigRespDtos)) {
                authConfigIdList = itemAuthConfigRespDtos.stream().map(ItemAuthConfigRespDto::getThirdPartyId).collect(Collectors.toList());
            }
        }
        Set businessIdSet = dtoList.stream().map(ItemAuthReqDto::getBusinessId).collect(Collectors.toSet());
        ItemSkuListRespDto itemSkuListRespDto = this.itemService.queryItemBySkuId(new ArrayList(businessIdSet));
        HashMap<Long, ItemRespDto> itemMap = new HashMap();
        HashMap<Long, ItemSkuRespDto> itemSkuMap = new HashMap();
        if (Objects.nonNull(itemSkuListRespDto)) {
            List itemSkuRespDtos;
            List itemRespDtos = itemSkuListRespDto.getItemRespDtos();
            if (CollectionUtils.isNotEmpty((Collection)itemRespDtos)) {
                itemMap = itemRespDtos.stream().collect(Collectors.toMap(ItemRespDto::getId, Function.identity()));
            }
            if (CollectionUtils.isNotEmpty((Collection)(itemSkuRespDtos = itemSkuListRespDto.getItemSkuRespDtos()))) {
                itemSkuMap = itemSkuRespDtos.stream().collect(Collectors.toMap(ItemSkuRespDto::getId, Function.identity()));
            }
        }
        Map<Long, List<ItemAuthReqDto>> itemAuthRuleMap = dtoList.stream().collect(Collectors.groupingBy(ItemAuthReqDto::getTargetId));
        for (Long customerId : itemAuthRuleMap.keySet()) {
            Object itemAuthReqDto2;
            AuthItemRuleReqDto authItemRuleDto = new AuthItemRuleReqDto();
            authItemRuleDto.setCustomerId(customerId);
            if (customerInfoMap.containsKey(customerId)) {
                CustomerRespDto customerRespDto = (CustomerRespDto)customerInfoMap.get(customerId);
                authItemRuleDto.setOrganizationId(customerRespDto.getMerchantId());
                authItemRuleDto.setCustomerCode(customerRespDto.getCode());
                authItemRuleDto.setCustomerName(customerRespDto.getName());
                if (!authConfigIdList.contains(customerRespDto.getThirdParentPartyId())) {
                    logger.info("\u5546\u54c1\u6388\u6743\u914d\u7f6e\u672a\u6dfb\u52a0\u8425\u9500\u4e91id={}", (Object)customerId);
                    continue;
                }
            } else {
                logger.info("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728={}", (Object)customerId);
                continue;
            }
            authItemRuleDto.setAuthType(AuthItemRuleTypeEnum.ITEM.getRuleType());
            ArrayList customerAuthItemReqDtos = Lists.newArrayList();
            List<ItemAuthReqDto> itemAuthReqDtos = itemAuthRuleMap.get(customerId);
            for (Object itemAuthReqDto2 : itemAuthReqDtos.stream().filter(r -> Objects.equals(1, r.getStatus())).collect(Collectors.toList())) {
                CustomerAuthItemReqDto customerAuthItemReqDto = this.getCustomerAuthItemReqDto(itemMap, itemSkuMap, customerId, (ItemAuthReqDto)itemAuthReqDto2);
                customerAuthItemReqDtos.add(customerAuthItemReqDto);
            }
            authItemRuleDto.setCustomerAuthItemReqDtos((List)customerAuthItemReqDtos);
            ArrayList customerAuthItemReqDtos1 = Lists.newArrayList();
            itemAuthReqDto2 = itemAuthReqDtos.stream().filter(r -> Objects.equals(0, r.getStatus())).collect(Collectors.toList()).iterator();
            while (itemAuthReqDto2.hasNext()) {
                ItemAuthReqDto itemAuthReqDto3 = (ItemAuthReqDto)itemAuthReqDto2.next();
                BlackAuthItemReqDto customerAuthItemReqDto = new BlackAuthItemReqDto();
                customerAuthItemReqDto.setItemId(itemAuthReqDto3.getBusinessId());
                customerAuthItemReqDto.setCustomerId(itemAuthReqDto3.getTargetId());
                customerAuthItemReqDtos1.add(customerAuthItemReqDto);
            }
            authItemRuleDto.setBlackAuthItemReqDtos((List)customerAuthItemReqDtos1);
            if (!itemRuleMap.isEmpty() && itemRuleMap.containsKey(customerId)) {
                AuthItemRuleRespDto authItemRuleRespDto = (AuthItemRuleRespDto)itemRuleMap.get(customerId);
                authItemRuleDto.setId(authItemRuleRespDto.getId());
                this.authItemRuleService.modifyAuthItemRule(authItemRuleDto);
                continue;
            }
            this.authItemRuleService.addAuthItemRule(authItemRuleDto);
        }
        return true;
    }

    private CustomerAuthItemReqDto getCustomerAuthItemReqDto(Map<Long, ItemRespDto> itemMap, Map<Long, ItemSkuRespDto> itemSkuMap, Long customerId, ItemAuthReqDto itemAuthReqDto) {
        CustomerAuthItemReqDto customerAuthItemReqDto = new CustomerAuthItemReqDto();
        customerAuthItemReqDto.setCustomerId(customerId);
        Long targetId = itemAuthReqDto.getTargetId();
        if (!itemSkuMap.isEmpty() && itemSkuMap.containsKey(targetId)) {
            ItemSkuRespDto itemSkuRespDto = itemSkuMap.get(targetId);
            customerAuthItemReqDto.setSkuCode(itemSkuRespDto.getCode());
            customerAuthItemReqDto.setSkuId(itemSkuRespDto.getId());
            customerAuthItemReqDto.setItemId(itemSkuRespDto.getItemId());
        }
        if (!itemMap.isEmpty() && itemMap.containsKey(customerAuthItemReqDto.getItemId())) {
            ItemRespDto itemRespDto = itemMap.get(customerAuthItemReqDto.getItemId());
            customerAuthItemReqDto.setItemCode(itemRespDto.getCode());
            customerAuthItemReqDto.setItemName(itemRespDto.getName());
        }
        return customerAuthItemReqDto;
    }

    private <T> PageInfo<T> page(ItemAuthQueryReqDto itemAuthQueryReqDto) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(itemAuthQueryReqDto.getPageNum().intValue());
        pageInfo.setPageSize(itemAuthQueryReqDto.getPageSize().intValue());
        pageInfo.setPages(0);
        pageInfo.setTotal(0L);
        return pageInfo;
    }

    public Long getCurrentUserOrgId() {
        return (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCurrentUserOrgId());
    }

    private void setDirPath(List<ItemAuthQueryRespDto> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        List dirIdList = list.stream().filter(item -> Objects.nonNull(item.getDirId())).map(ItemAuthQueryRespDto::getDirId).distinct().collect(Collectors.toList());
        if (CollUtil.isEmpty(dirIdList)) {
            return;
        }
        List dirEos = this.dirDas.selectByIds(dirIdList);
        if (CollUtil.isEmpty((Collection)dirEos)) {
            return;
        }
        List rootIdList = dirEos.stream().filter(item -> Objects.nonNull(item.getRootId())).map(StdDirEo::getRootId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DirEo.class).in(StdDirEo::getRootId, rootIdList)).eq(BaseEo::getDr, (Object)0)).ne(StdDirEo::getParentId, (Object)0);
        List dirEoList = this.dirDas.getMapper().selectList((Wrapper)queryWrapper);
        Map dirEoMap = dirEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        list.forEach(item -> {
            Long dirId = item.getDirId();
            ArrayList<String> dirNameList = new ArrayList<String>();
            while (dirEoMap.containsKey(dirId)) {
                DirEo dirEo = (DirEo)dirEoMap.get(dirId);
                dirNameList.add(dirEo.getName());
                dirId = dirEo.getParentId();
            }
            if (CollUtil.isNotEmpty(dirNameList)) {
                Collections.reverse(dirNameList);
                item.setDirName(dirNameList.stream().collect(Collectors.joining(">")));
            }
        });
    }

    @Override
    public List<ItemAuthQueryRespDto> queryShellItemList(ItemAuthExtQueryReqDto itemAuthQueryReqDto) {
        List shopBaseDtos;
        logger.info("\u5f53\u524d\u7ec4\u7ec7\u6388\u6743\u5546\u54c1\u5217\u8868\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJsonString((Object)itemAuthQueryReqDto));
        if (Objects.isNull(itemAuthQueryReqDto.getOrganizationId())) {
            String orgIdStr = this.headerOrgId();
            logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
            AssertUtil.assertNotBlank(orgIdStr, "\u8bf7\u6c42\u5934\u7f3a\u5931\u7ec4\u7ec7ID[yes-req-cus-b2b-organizationId]");
            itemAuthQueryReqDto.setOrganizationId(Long.valueOf(orgIdStr));
        }
        Long organizationId = itemAuthQueryReqDto.getOrganizationId();
        AssertUtil.assertNotNull(organizationId, "\u5fc5\u4f20\u53c2\u6570\u7ec4\u7ec7id\u4e3a\u7a7a");
        if (Objects.isNull(itemAuthQueryReqDto.getTenantId())) {
            itemAuthQueryReqDto.setTenantId(this.tenantId());
        }
        if (Objects.isNull(itemAuthQueryReqDto.getInstanceId())) {
            itemAuthQueryReqDto.setInstanceId(this.instanceId());
        }
        if (CollectionUtils.isEmpty((Collection)(shopBaseDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryShopListBySellerOrgId(organizationId))))) {
            logger.info("\u5f53\u524d\u7ec4\u7ec7\u4e0b\u672a\u67e5\u8be2\u5230\u5e97\u94fa\u4fe1\u606f,organizationId={}", (Object)organizationId);
            return Lists.newArrayList();
        }
        List shopIdList = shopBaseDtos.stream().map(ShopBaseDto::getId).collect(Collectors.toList());
        List searchTargetIdList = itemAuthQueryReqDto.getTargetIdList() == null ? Lists.newArrayList() : itemAuthQueryReqDto.getTargetIdList();
        searchTargetIdList.addAll(shopIdList);
        itemAuthQueryReqDto.setTargetIdList(searchTargetIdList);
        itemAuthQueryReqDto.setBusinessType(ItemAuthEnum.BusinessType.SKU.getCode());
        itemAuthQueryReqDto.setTargetType(ItemAuthEnum.TargetType.SHOP.getCode());
        List list = this.itemAuthExtDas.queryItemAuthExtList(itemAuthQueryReqDto);
        if (CollUtil.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    @Override
    public void syncRuleToEsAll(AuthItemRuleReqDto queryDto) {
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(1));
        Long userId = this.context.userId();
        String requestId = String.valueOf(ServiceContext.getContext().get("yes.req.requestId"));
        String finalRequestId = requestId = StringUtils.isNotEmpty((CharSequence)requestId) ? requestId : UUID.randomUUID().toString().replace("-", "");
        executorService.submit(() -> {
            logger.info("\u5f02\u6b65\u6267\u884c\u5546\u54c1\u6388\u6743\u89c4\u5219\u540c\u6b65ES");
            ServiceContext.getContext().set("yes.req.requestId", (Object)finalRequestId);
            this.context.userId(userId);
            try {
                queryDto.setPageSize(batchNum);
                List pageList = null;
                do {
                    PageInfo authItemRuleRespDtoPageInfo;
                    if (CollectionUtils.isNotEmpty((Collection)(authItemRuleRespDtoPageInfo = this.authItemRuleService.queryByPage(queryDto)).getList())) {
                        for (AuthItemRuleRespDto authItemRuleRespDto : authItemRuleRespDtoPageInfo.getList()) {
                            try {
                                this.authItemRuleService.syncRuleToEsByRuleId(authItemRuleRespDto.getId());
                            }
                            catch (Exception e) {
                                logger.info("\u5ba2\u6237={},\u540c\u6b65ES\u5931\u8d25:{}", (Object)authItemRuleRespDto.getCustomerCode(), (Object)e.getMessage());
                            }
                        }
                    }
                    pageList = authItemRuleRespDtoPageInfo.getList();
                    queryDto.setPageNum(Integer.valueOf(queryDto.getPageNum() + 1));
                } while (CollectionUtils.isNotEmpty((Collection)pageList));
            }
            catch (Exception e) {
                logger.info("\u5f02\u6b65\u6267\u884c\u5546\u54c1\u6388\u6743\u89c4\u5219\u540c\u6b65ES\u5f02\u5e38");
                e.printStackTrace();
            }
        });
    }
}

