/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.apiimpl.query;

import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.dto.request.PcpItemQueryDto;
import com.yx.tcbj.center.api.dto.response.PcpItemRespDto;
import com.yx.tcbj.center.api.query.IPcpItemQueryApi;
import com.yx.tcbj.center.biz.service.IPcpItemService;
import com.yx.tcbj.center.biz.util.LogUtils;
import com.yx.tcbj.center.dao.eo.PcpItemEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PcpItemQueryApiImpl
implements IPcpItemQueryApi {
    private static Logger logger = LoggerFactory.getLogger(PcpItemQueryApiImpl.class);
    @Resource
    private IPcpItemService pcpItemService;

    public RestResponse<PcpItemRespDto> queryById(Long id) {
        return new RestResponse((Object)this.pcpItemService.queryById(id));
    }

    public RestResponse<PageInfo<PcpItemRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.pcpItemService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<PcpItemRespDto> queryByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        Assert.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"10002", (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        return new RestResponse((Object)this.pcpItemService.queryById(id));
    }

    public RestResponse<PageInfo<PcpItemRespDto>> queryByPage(PcpItemQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto, "pageNum", "pageSize"));
        return new RestResponse(this.pcpItemService.queryByPage(queryDto));
    }

    public RestResponse<PageInfo<PcpItemRespDto>> queryPageByCondition(PcpItemQueryDto queryDto) {
        return new RestResponse(this.pcpItemService.queryByPageByCondition(queryDto));
    }

    public RestResponse<List<PcpItemRespDto>> queryByParam(PcpItemQueryDto queryDto) {
        logger.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto));
        List<PcpItemEo> result = this.pcpItemService.queryByParam(queryDto);
        ArrayList list = Lists.newArrayList();
        DtoHelper.eoList2DtoList(result, (Collection)list, PcpItemRespDto.class);
        return new RestResponse((Object)list);
    }

    public RestResponse<List<PcpItemRespDto>> queryItemByItemCodes(List<String> itemCodes) {
        return new RestResponse(this.pcpItemService.queryByItemCodes(itemCodes));
    }

    public RestResponse<List<PcpItemRespDto>> queryItemByItemLongCodes(List<String> itemLongCodes) {
        return new RestResponse(this.pcpItemService.queryByItemLongCodes(itemLongCodes));
    }
}

