/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.mq.processor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yx.tcbj.center.api.dto.request.ItemAuthConfigMessageDto;
import com.yx.tcbj.center.biz.service.IItemAuthConfigExtService;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="ITEM_AUTH_CONFIG_TAG")
public class ItemAuthConfigProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(ItemAuthConfigProcessor.class);
    @Resource
    private IItemAuthConfigExtService itemAuthConfigService;

    public MessageResponse process(MessageVo message) {
        String reqId = UUID.randomUUID().toString().replace("-", "");
        MDC.put((String)"yes.req.requestId", (String)reqId);
        MDC.put((String)"yes.req.requestId", (String)reqId);
        logger.info("\u63a5\u6536\u5230\u5546\u54c1\u6388\u6743\u914d\u7f6e\u53d8\u66f4\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)message));
        if (message.getData() == null) {
            logger.info("\u5546\u54c1\u6388\u6743\u914d\u7f6e\u53d8\u66f4\u6d88\u606f\u53c2\u6570\u5f02\u5e38");
            return MessageResponse.ERROR;
        }
        try {
            ItemAuthConfigMessageDto messageDto = (ItemAuthConfigMessageDto)JSONObject.parseObject((String)((String)message.getData()), ItemAuthConfigMessageDto.class);
            this.itemAuthConfigService.handleAuthConfigChange(messageDto);
            logger.info("\u5546\u54c1\u6388\u6743\u914d\u7f6e\u53d8\u66f4\u5904\u7406\u5b8c\u6210");
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5546\u54c1\u6388\u6743\u914d\u7f6e\u53d8\u66f4\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

