/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.dao.base.das;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRelRespDto;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.mapper.ItemMapper;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.DirShelfItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ItemSearchVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ShelfItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ItemDas
extends AbstractBaseDas<ItemEo, String> {
    @Resource
    private ItemMapper itemMapper;

    public void updateStatusByIds(List<Long> itemIds, Integer status) {
        for (Long id : itemIds) {
            this.deleteCacheByKey(id.toString());
            ItemEo itemEo = ItemEo.newInstance();
            itemEo.setId(id);
            itemEo.setStatus(status);
            this.updateSelective((BaseEo)itemEo);
        }
    }

    public List<ItemEo> selectByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        ItemEo itemEo = ItemEo.newInstance();
        itemEo.setOrderBy("id");
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        itemEo.setSqlFilters((List)sqlFilters);
        return this.select((BaseEo)itemEo);
    }

    public PageInfo<ShelfItemVo> selectByKeyword(String keyword, Integer type, List<Long> dirIds, Long brandId, List<Long> itemIds, List<Long> skuIds, Long sellerId, Long shopId, List<Long> shopIds, List<Long> sellerIds, List<Long> organizationIds, Integer pageNum, Integer pageSize, Long instanceId, Long tenantId, Integer subType, List<Integer> subTypeList, Integer busType, Integer status) {
        ItemMapper itemMapper = (ItemMapper)this.getMapper();
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<ShelfItemVo> itemEoList = itemMapper.selectByKeyword(keyword, type, dirIds, brandId, itemIds, skuIds, sellerId, shopId, shopIds, sellerIds, organizationIds, instanceId, tenantId, subType, subTypeList, busType, status);
        return new PageInfo(itemEoList);
    }

    public PageInfo<Long> querySaleOut(ItemEo query, int page, int size, List<Long> dirIdList) {
        ItemMapper mapper = (ItemMapper)this.getMapper();
        int count = mapper.querySaleOutCount(query, dirIdList);
        PageInfo info = new PageInfo();
        info.setTotal((long)count);
        info.setPageSize(size);
        info.setPageNum(page);
        if (count > 0) {
            int offset = (page - 1) * size;
            info.setList(mapper.querySaleOut(query, offset, size, dirIdList));
        }
        return info;
    }

    public void deleteCacheByKey(String key) {
        this.getCacheService().delCache(this.getCachePre() + key);
    }

    public PageInfo<ShelfItemVo> selectSelfItemByPage(ShelfItemVo shelfItemVo, Integer pageNum, Integer pageSize) {
        ItemMapper mapper = (ItemMapper)this.getMapper();
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<ShelfItemVo> shelfItemVoList = mapper.selectSelfItemByPage(shelfItemVo, pageNum, pageSize);
        return new PageInfo(shelfItemVoList);
    }

    public Long selectSelfItemCount(ShelfItemVo shelfItemVo) {
        ItemMapper mapper = (ItemMapper)this.getMapper();
        return mapper.selectSelfItems(shelfItemVo).size();
    }

    public List<ItemVo> pageItemOnSelf(ItemSearchVo managementBlockSearchVo) {
        return this.itemMapper.pageItemOnSelf(managementBlockSearchVo);
    }

    public List<DirShelfItemVo> querySkuByDirId(String name, List<Long> dirIds) {
        return this.itemMapper.querySkuByDirId(name, dirIds);
    }

    public List<ItemEo> selectByBrandId(Long brandId) {
        ItemEo param = ItemEo.newInstance();
        param.setBrandId(brandId);
        return this.select((BaseEo)param);
    }

    public ItemEo selectByItemCode(String itemCode) {
        ItemEo param = ItemEo.newInstance();
        param.setCode(itemCode);
        List list = this.select((BaseEo)param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (ItemEo)list.get(0);
        }
        return null;
    }

    public List<ItemRespDto> queryByItemLongCodes(List<String> itemCodes) {
        return this.itemMapper.queryByItemLongCodes(itemCodes);
    }

    public List<ItemSkuRelRespDto> queryItemSkuRelByCodes(List<String> itemCodes) {
        return this.itemMapper.queryItemSkuRelByCodes(itemCodes);
    }

    public List<ItemSkuRelRespDto> queryItemSkuByItemCodes(List<String> itemCodes) {
        return this.itemMapper.queryItemSkuByItemCodes(itemCodes);
    }

    public List<ItemSkuRelRespDto> queryItemSkuBySkuCodes(List<String> skuCodes) {
        return this.itemMapper.queryItemSkuBySkuCodes(skuCodes);
    }

    public List<Long> queryItemIdByKeywordAndItemIds(String keyword, List<Long> itemIds) {
        return this.itemMapper.queryItemIdByKeywordAndItemIds(keyword, itemIds);
    }

    public List<ItemEo> listByLongCode(List<String> itemCodes) {
        return this.list((Wrapper)Wrappers.lambdaQuery(ItemEo.class).in(StdItemEo::getLongCode, itemCodes));
    }
}

