/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.promotion.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.ItemSkuActivityPriceExtDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ActivityBizExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ActivityMutexExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ActivityPriceBranchExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ActivityStockExtReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.RemainingStockBatchExtReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.TargetCustomerBizExtReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.response.ActivityListBizExtRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.response.ActivityMutexExtQueryRespDto;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.IActivityBizExtService;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.IItemActivityStockExtService;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.impl.ExternalApiHelp;
import com.dtyunxi.yundt.cube.center.promotion.biz.utils.AssertUtils;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.ItemSkuActivityPriceDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.ActivityMutexQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.ActivityPriceBranchQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.RemainingStockBatchReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.TargetCustomerReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.ActivityMutexQueryRespDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.RemainingStockBatchRespDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.biz.activity.base.service.IItemActivityStockService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.ItemSkuDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IActivityExtQueryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItemActivityStockExtServiceImpl
implements IItemActivityStockExtService {
    private static final Logger log = LoggerFactory.getLogger(ItemActivityStockExtServiceImpl.class);
    @Resource
    private IItemActivityStockService itemActivityStockService;
    @Resource
    private ExternalApiHelp externalApiHelp;
    @Resource
    private IActivityExtQueryService activityExtQueryService;
    @Resource
    private IActivityBizExtService activityBizExtService;

    @Override
    public List<ItemSkuActivityPriceExtDto> queryBranchItemSkuActivityPrice(ActivityPriceBranchExtQueryReqDto queryReqDto) {
        Map<Object, Object> itemMap;
        log.info("\u6279\u91cf\u67e5\u8be2\u5546\u54c1SKU\u53ef\u7528\u7684\u6d3b\u52a8\u6700\u4f4e\u4ef7\u683c\u5217\u8868\u5165\u53c2:{}", JSON.toJSON((Object)queryReqDto));
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getItemSkuActivityPriceExtList())) {
            List<CustomerRespDto> customerRespDtos;
            List<ItemRespDto> itemRespDtos;
            List<ItemSkuRespDto> itemSkuRespDtoList;
            List<ShopDto> shopDtoList;
            List itemSkuActivityPriceExtList = queryReqDto.getItemSkuActivityPriceExtList();
            Set shopCodeSet = itemSkuActivityPriceExtList.stream().filter(d -> StringUtils.isNotEmpty((CharSequence)d.getShopCode())).map(ItemSkuActivityPriceExtDto::getShopCode).collect(Collectors.toSet());
            Set skuCodeSet = itemSkuActivityPriceExtList.stream().filter(d -> StringUtils.isNotEmpty((CharSequence)d.getSkuCode())).map(ItemSkuActivityPriceExtDto::getSkuCode).collect(Collectors.toSet());
            Set itemCodeSet = itemSkuActivityPriceExtList.stream().filter(d -> StringUtils.isNotEmpty((CharSequence)d.getItemCode())).map(ItemSkuActivityPriceExtDto::getItemCode).collect(Collectors.toSet());
            Set thirdPartyIdSet = itemSkuActivityPriceExtList.stream().filter(d -> StringUtils.isNotEmpty((CharSequence)d.getThirdPartyId())).map(ItemSkuActivityPriceExtDto::getThirdPartyId).collect(Collectors.toSet());
            Map<Object, Object> shopMap = new HashMap();
            Map<Object, Object> itemSkuMap = new HashMap();
            itemMap = new HashMap();
            Map<Object, Object> customerMap = new HashMap();
            if (CollectionUtils.isNotEmpty(shopCodeSet) && CollectionUtils.isNotEmpty(shopDtoList = this.externalApiHelp.getShopByCodes(new ArrayList<String>(shopCodeSet)))) {
                shopMap = shopDtoList.stream().collect(Collectors.toMap(ShopDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
            if (CollectionUtils.isNotEmpty(skuCodeSet) && CollectionUtils.isNotEmpty(itemSkuRespDtoList = this.externalApiHelp.getItemSkuCodes(new ArrayList<String>(skuCodeSet)))) {
                itemSkuMap = itemSkuRespDtoList.stream().collect(Collectors.toMap(ItemSkuRespDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
            if (CollectionUtils.isNotEmpty(itemCodeSet) && CollectionUtils.isNotEmpty(itemRespDtos = this.externalApiHelp.getItemByCodes(new ArrayList<String>(itemCodeSet)))) {
                itemMap = itemRespDtos.stream().collect(Collectors.toMap(ItemRespDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
            if (CollectionUtils.isNotEmpty(thirdPartyIdSet) && CollectionUtils.isNotEmpty(customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(new ArrayList<String>(thirdPartyIdSet)))) {
                customerMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getThirdPartyId, Function.identity(), (k1, k2) -> k1));
            }
            ArrayList itemSkuActivityPriceList = Lists.newArrayList();
            for (ItemSkuActivityPriceExtDto extDto : itemSkuActivityPriceExtList) {
                if (Objects.isNull(extDto.getShopId()) && StringUtils.isNotEmpty((CharSequence)extDto.getShopCode()) && shopMap.containsKey(extDto.getShopCode())) {
                    extDto.setShopId(((ShopDto)shopMap.get(extDto.getShopCode())).getId());
                }
                if (Objects.isNull(extDto.getSkuId()) && StringUtils.isNotEmpty((CharSequence)extDto.getSkuCode()) && itemSkuMap.containsKey(extDto.getSkuCode())) {
                    extDto.setSkuId(((ItemSkuRespDto)itemSkuMap.get(extDto.getSkuCode())).getId());
                }
                if (Objects.isNull(extDto.getItemId()) && StringUtils.isNotEmpty((CharSequence)extDto.getItemCode()) && itemMap.containsKey(extDto.getItemCode())) {
                    extDto.setItemId(((ItemRespDto)itemMap.get(extDto.getItemCode())).getId());
                }
                if (Objects.isNull(extDto.getCustomerId()) && StringUtils.isNotEmpty((CharSequence)extDto.getThirdPartyId()) && customerMap.containsKey(extDto.getThirdPartyId())) {
                    extDto.setCustomerId(((CustomerRespDto)customerMap.get(extDto.getThirdPartyId())).getId());
                }
                itemSkuActivityPriceList.add(extDto);
            }
            queryReqDto.setItemSkuActivityPriceList((List)itemSkuActivityPriceList);
            queryReqDto.setItemSkuActivityPriceExtList(null);
        }
        log.info("\u67e5\u8be2\u6d3b\u52a8\u5546\u54c1\u4ef7\u683c\u5165\u53c2={}", JSON.toJSON((Object)queryReqDto));
        List itemSkuActivityPriceDtos = this.itemActivityStockService.queryBranchItemSkuActivityPrice((ActivityPriceBranchQueryReqDto)queryReqDto);
        ArrayList resultList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)itemSkuActivityPriceDtos)) {
            return resultList;
        }
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)itemSkuActivityPriceDtos, ItemSkuActivityPriceExtDto.class);
        Set<Long> shopIdSet = resultList.stream().map(ItemSkuActivityPriceDto::getShopId).collect(Collectors.toSet());
        Set<Long> itemIdSet = resultList.stream().map(ItemSkuActivityPriceDto::getItemId).collect(Collectors.toSet());
        Set<Long> skuIdSet = resultList.stream().map(ItemSkuActivityPriceDto::getSkuId).collect(Collectors.toSet());
        Set<Long> customerIdSet = resultList.stream().map(ItemSkuActivityPriceDto::getCustomerId).collect(Collectors.toSet());
        Map<Long, ShopDto> shopMap = this.externalApiHelp.getShopMapById(shopIdSet);
        itemMap = this.externalApiHelp.getItemMapById(itemIdSet);
        Map<Long, ItemSkuRespDto> itemSkuMap = this.externalApiHelp.getItemSkuMapById(skuIdSet);
        Map<Long, CustomerRespDto> customerMap = this.externalApiHelp.getCustomerMap(customerIdSet);
        for (ItemSkuActivityPriceExtDto extDto : resultList) {
            if (shopMap.containsKey(extDto.getShopId())) {
                extDto.setShopCode(shopMap.get(extDto.getShopId()).getCode());
            }
            if (itemSkuMap.containsKey(extDto.getSkuId())) {
                extDto.setSkuCode(itemSkuMap.get(extDto.getSkuId()).getCode());
            }
            if (itemMap.containsKey(extDto.getItemId())) {
                extDto.setItemCode(((ItemRespDto)itemMap.get(extDto.getItemId())).getCode());
            }
            if (!customerMap.containsKey(extDto.getCustomerId())) continue;
            extDto.setThirdPartyId(customerMap.get(extDto.getCustomerId()).getThirdPartyId());
        }
        return resultList;
    }

    @Override
    public RemainingStockBatchRespDto getActivityRemainingStockBatch(RemainingStockBatchExtReqDto reqDto) {
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getActivityStockExtList())) {
            List<ItemRespDto> itemRespDtos;
            List<ShopDto> shopDtoList;
            List activityStockExtList = reqDto.getActivityStockExtList();
            Set shopCodeSet = activityStockExtList.stream().filter(d -> StringUtils.isNotEmpty((CharSequence)d.getShopCode())).map(ActivityStockExtReqDto::getShopCode).collect(Collectors.toSet());
            Set itemCodeSet = activityStockExtList.stream().filter(d -> StringUtils.isNotEmpty((CharSequence)d.getItemCode())).map(ActivityStockExtReqDto::getItemCode).collect(Collectors.toSet());
            Map<Object, Object> shopMap = new HashMap();
            Map<Object, Object> itemMap = new HashMap();
            if (CollectionUtils.isNotEmpty(shopCodeSet) && CollectionUtils.isNotEmpty(shopDtoList = this.externalApiHelp.getShopByCodes(new ArrayList<String>(shopCodeSet)))) {
                shopMap = shopDtoList.stream().collect(Collectors.toMap(ShopDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
            if (CollectionUtils.isNotEmpty(itemCodeSet) && CollectionUtils.isNotEmpty(itemRespDtos = this.externalApiHelp.getItemByCodes(new ArrayList<String>(itemCodeSet)))) {
                itemMap = itemRespDtos.stream().collect(Collectors.toMap(ItemRespDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
            ArrayList activityStockReqDtoList = Lists.newArrayList();
            for (ActivityStockExtReqDto extDto : activityStockExtList) {
                if (Objects.isNull(extDto.getShopId()) && StringUtils.isNotEmpty((CharSequence)extDto.getShopCode()) && shopMap.containsKey(extDto.getShopCode())) {
                    extDto.setShopId(((ShopDto)shopMap.get(extDto.getShopCode())).getId());
                }
                if (Objects.isNull(extDto.getItemId()) && StringUtils.isNotEmpty((CharSequence)extDto.getItemCode()) && itemMap.containsKey(extDto.getItemCode())) {
                    extDto.setItemId(((ItemRespDto)itemMap.get(extDto.getItemCode())).getId());
                }
                activityStockReqDtoList.add(extDto);
            }
            reqDto.setActivityStockList((List)activityStockReqDtoList);
            reqDto.setActivityStockExtList(null);
        }
        RemainingStockBatchRespDto activityRemainingStockBatch = this.itemActivityStockService.getActivityRemainingStockBatch((RemainingStockBatchReqDto)reqDto);
        return activityRemainingStockBatch;
    }

    @Override
    public List<Long> validateTargetCustomersAndMallTypeByThird(TargetCustomerBizExtReqDto reqDto) {
        AssertUtils.notEmpty(reqDto.getThirdPartyIdList(), "\u5ba2\u6237\u7b2c\u4e09\u65b9id\u96c6\u5408\u4e3a\u7a7a");
        AssertUtils.notEmpty(reqDto.getActivityIds(), "\u6d3b\u52a8id\u96c6\u5408\u4e3a\u7a7a");
        List<CustomerRespDto> customerList = this.externalApiHelp.getCustomerByThirdPartyIds(reqDto.getThirdPartyIdList());
        TargetCustomerReqDto targetCustomerReqDto = new TargetCustomerReqDto();
        targetCustomerReqDto.setActivityIds(reqDto.getActivityIds());
        targetCustomerReqDto.setCustomerInfoList(customerList);
        return this.itemActivityStockService.validateTargetCustomersAndMallType(targetCustomerReqDto);
    }

    @Override
    public List<ActivityMutexExtQueryRespDto> queryActivityMutexList(ActivityMutexExtQueryReqDto queryReqDto) {
        List<ItemSkuRespDto> itemSkuRespDtos;
        List<ItemRespDto> itemRespDtos;
        List<ShopDto> shopDtoList;
        AssertUtils.notEmpty(queryReqDto.getThirdPartyId(), "\u7b2c\u4e09\u65b9\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty(queryReqDto.getItemSkuExtList(), "\u5546\u54c1\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a");
        List oldActivityIdList = queryReqDto.getActivityIds();
        ActivityBizExtQueryReqDto activityBizExtQueryReqDto = new ActivityBizExtQueryReqDto();
        activityBizExtQueryReqDto.setThirdPartyId(queryReqDto.getThirdPartyId());
        activityBizExtQueryReqDto.setShopCode(((ActivityMutexExtQueryReqDto.ItemSkuExtDto)queryReqDto.getItemSkuExtList().get(0)).getShopCode());
        List<ActivityListBizExtRespDto> activityListBizExtRespDtos = this.activityBizExtService.queryExchangeActivityByCustomer(activityBizExtQueryReqDto);
        if (CollectionUtils.isNotEmpty(activityListBizExtRespDtos)) {
            List activityIdList = activityListBizExtRespDtos.stream().map(ActivityRespDto::getId).collect(Collectors.toList());
            activityIdList.addAll(oldActivityIdList);
            queryReqDto.setActivityIds(activityIdList);
        }
        HashSet<String> shopCodeSet = new HashSet<String>();
        HashSet<String> itemCodeSet = new HashSet<String>();
        HashSet<String> skuCodeSet = new HashSet<String>();
        for (ActivityMutexExtQueryReqDto.ItemSkuExtDto itemSkuExtDto : queryReqDto.getItemSkuExtList()) {
            shopCodeSet.add(itemSkuExtDto.getShopCode());
            itemCodeSet.add(itemSkuExtDto.getItemCode());
            skuCodeSet.add(itemSkuExtDto.getSkuCode());
        }
        Map<Object, Object> shopMap = new HashMap();
        Map<Object, Object> itemMap = new HashMap();
        Map<Object, Object> skuMap = new HashMap();
        if (CollectionUtils.isNotEmpty(shopCodeSet) && CollectionUtils.isNotEmpty(shopDtoList = this.externalApiHelp.getShopByCodes(new ArrayList<String>(shopCodeSet)))) {
            shopMap = shopDtoList.stream().collect(Collectors.toMap(ShopDto::getCode, Function.identity(), (k1, k2) -> k1));
        }
        if (CollectionUtils.isNotEmpty(itemCodeSet) && CollectionUtils.isNotEmpty(itemRespDtos = this.externalApiHelp.getItemByCodes(new ArrayList<String>(itemCodeSet)))) {
            itemMap = itemRespDtos.stream().collect(Collectors.toMap(ItemRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        }
        if (CollectionUtils.isNotEmpty(skuCodeSet) && CollectionUtils.isNotEmpty(itemSkuRespDtos = this.externalApiHelp.getItemSkuCodes(new ArrayList<String>(skuCodeSet)))) {
            skuMap = itemSkuRespDtos.stream().collect(Collectors.toMap(ItemSkuRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList itemSkuList = Lists.newArrayList();
        for (ActivityMutexExtQueryReqDto.ItemSkuExtDto itemSkuExtDto : queryReqDto.getItemSkuExtList()) {
            ItemSkuDto itemSkuDto = new ItemSkuDto();
            CubeBeanUtils.copyProperties((Object)itemSkuDto, (Object)itemSkuExtDto, (String[])new String[0]);
            if (shopMap.containsKey(itemSkuExtDto.getShopCode())) {
                itemSkuDto.setShopId(((ShopDto)shopMap.get(itemSkuExtDto.getShopCode())).getId());
            }
            if (itemMap.containsKey(itemSkuExtDto.getItemCode())) {
                itemSkuDto.setItemId(((ItemRespDto)itemMap.get(itemSkuExtDto.getItemCode())).getId());
            }
            if (skuMap.containsKey(itemSkuExtDto.getSkuCode())) {
                itemSkuDto.setSkuId(((ItemSkuRespDto)skuMap.get(itemSkuExtDto.getSkuCode())).getId());
            }
            itemSkuList.add(itemSkuDto);
        }
        queryReqDto.setItemSkuList((List)itemSkuList);
        log.info("\u67e5\u8be2\u4e92\u65a5\u6d3b\u52a8\u5165\u53c2={}", (Object)JSON.toJSONString((Object)queryReqDto));
        List activityMutexQueryRespDtos = this.itemActivityStockService.queryActivityMutexList((ActivityMutexQueryReqDto)queryReqDto);
        log.info("\u67e5\u8be2\u4e92\u65a5\u6d3b\u52a8\u51fa\u53c2={}", (Object)JSON.toJSONString((Object)activityMutexQueryRespDtos));
        ArrayList respDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)activityMutexQueryRespDtos)) {
            return respDtoList;
        }
        activityMutexQueryRespDtos = activityMutexQueryRespDtos.stream().filter(a -> oldActivityIdList.contains(a.getActivityId())).collect(Collectors.toList());
        CubeBeanUtils.copyCollection((Collection)respDtoList, activityMutexQueryRespDtos, ActivityMutexExtQueryRespDto.class);
        List activityIdList = respDtoList.stream().map(ActivityMutexQueryRespDto::getActivityId).collect(Collectors.toList());
        List activityListByIds = this.activityExtQueryService.queryActivityListByIds(activityIdList);
        Map<Object, Object> activity = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)activityListByIds)) {
            activity = activityListByIds.stream().collect(Collectors.toMap(ActivityRespDto::getId, Function.identity()));
        }
        for (ActivityMutexExtQueryRespDto activityMutexExtQueryRespDto : respDtoList) {
            if (activity.containsKey(activityMutexExtQueryRespDto.getActivityId())) {
                ActivityRespDto activityRespDto = (ActivityRespDto)activity.get(activityMutexExtQueryRespDto.getActivityId());
                activityMutexExtQueryRespDto.setActivityRespDto(activityRespDto);
            }
            if (!CollectionUtils.isNotEmpty((Collection)activityMutexExtQueryRespDto.getMutexActivityIds())) continue;
            List activityRespDtos = this.activityExtQueryService.queryActivityListByIds(activityMutexExtQueryRespDto.getMutexActivityIds());
            activityMutexExtQueryRespDto.setMutexActivityList(activityRespDtos);
        }
        return respDtoList;
    }
}

