/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.rebate.biz.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.CustomerInfoDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.IGiftBalanceApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftBalanceAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IBalanceService;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceAccountReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.ReturnsQuotaAccountReqDto;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceAccountEnum;
import com.yx.tcbj.center.rebate.biz.service.IOfflineBalanceAccountService;
import com.yx.tcbj.center.rebate.biz.service.IReturnsQuotaAccountService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="${icomb.common.topic.customer.change:CUSTOMER_CHANGE_TOPIC}", tag="${icomb.common.topic.customer.change:CUSTOMER_CHANGE_TOPIC}")
public class CustomerChangeProcess
implements IMessageProcessor<String> {
    private static final Logger logger = LoggerFactory.getLogger(CustomerChangeProcess.class);
    @Resource
    private IBalanceService balanceService;
    @Resource
    private IGiftBalanceApi giftBalanceApi;
    @Resource
    private IOfflineBalanceAccountService offlineBalanceAccountService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IReturnsQuotaAccountService returnsQuotaAccountService;

    public MessageResponse process(String orgInfoJson) {
        logger.info("\u63a5\u6536\u7684\u5ba2\u6237\u65b0\u589e\u548c\u4fee\u6539\u4fe1\u606f\uff1a{}", (Object)orgInfoJson);
        if (StringUtils.isEmpty((CharSequence)orgInfoJson)) {
            return MessageResponse.SUCCESS;
        }
        CustomerInfoDto dto = (CustomerInfoDto)JSON.parseObject((String)orgInfoJson, CustomerInfoDto.class);
        this.createOfflineBalanceAccount(dto);
        this.createRebateAccount(dto);
        return MessageResponse.SUCCESS;
    }

    private void createOfflineBalanceAccount(CustomerInfoDto dto) {
        try {
            logger.info("createOfflineBalanceAccount begin :{}", (Object)JSON.toJSONString((Object)dto));
            HashMap paramMap = Maps.newHashMap();
            paramMap.put("customerId", dto.getCustomerId());
            List accountList = this.offlineBalanceAccountService.queryByPage(JSON.toJSONString((Object)paramMap), null, null).getList();
            logger.info("createOfflineBalanceAccount->quereyAccountList :{}", (Object)JSON.toJSONString((Object)accountList));
            OfflineBalanceAccountReqDto offlineBalanceAccountReqDto = new OfflineBalanceAccountReqDto();
            offlineBalanceAccountReqDto.setCustomerName(dto.getCustomerName());
            offlineBalanceAccountReqDto.setCustomerCode(dto.getCustomerCode());
            offlineBalanceAccountReqDto.setCustomerCompany(dto.getOrgName());
            offlineBalanceAccountReqDto.setMerchantId(dto.getMerchantId());
            if (CollectionUtils.isNotEmpty((Collection)accountList)) {
                logger.info("createOfflineBalanceAccount->modify, params\uff1a{}", (Object)JSON.toJSONString((Object)offlineBalanceAccountReqDto));
                this.offlineBalanceAccountService.modifyOfflineBalanceAccount(offlineBalanceAccountReqDto);
            } else {
                offlineBalanceAccountReqDto.setCustomerId(dto.getCustomerId());
                offlineBalanceAccountReqDto.setAccountBalance(BigDecimal.ZERO);
                offlineBalanceAccountReqDto.setAgentUse(OfflineBalanceAccountEnum.ENABLED.getValue());
                offlineBalanceAccountReqDto.setAgentView(OfflineBalanceAccountEnum.ENABLED.getValue());
                offlineBalanceAccountReqDto.setAccountStatus("ENABLED");
                offlineBalanceAccountReqDto.setAccountCode("YEZH" + dto.getCustomerCode());
                offlineBalanceAccountReqDto.setTenantId(dto.getTenantId());
                offlineBalanceAccountReqDto.setInstanceId(dto.getInstanceId());
                logger.info("createOfflineBalanceAccount->add, params\uff1a{}", (Object)JSON.toJSONString((Object)offlineBalanceAccountReqDto));
                this.offlineBalanceAccountService.addOfflineBalanceAccount(offlineBalanceAccountReqDto);
            }
        }
        catch (Exception e) {
            logger.info("createOfflineBalanceAccount,customer id:{},error:{}", (Object)dto.getCustomerId(), (Object)e.getMessage());
        }
    }

    private void createRebateAccount(CustomerInfoDto dto) {
        try {
            GiftBalanceAddReqDto giftBalanceAddReqDto = new GiftBalanceAddReqDto();
            giftBalanceAddReqDto.setBalance(BigDecimal.ZERO);
            giftBalanceAddReqDto.setCustomerId(dto.getCustomerId());
            giftBalanceAddReqDto.setCustomerCode(dto.getCustomerCode());
            giftBalanceAddReqDto.setCustomerName(dto.getCustomerName());
            giftBalanceAddReqDto.setOrganizationId(dto.getMerchantId());
            this.giftBalanceApi.add(giftBalanceAddReqDto);
            ReturnsQuotaAccountReqDto returnsQuotaAccountReqDto = new ReturnsQuotaAccountReqDto();
            returnsQuotaAccountReqDto.setCustomerId(dto.getCustomerId());
            returnsQuotaAccountReqDto.setAdvanceQuota(BigDecimal.ZERO);
            returnsQuotaAccountReqDto.setGeneralReturnsQuota(BigDecimal.ZERO);
            returnsQuotaAccountReqDto.setAdvanceUnbackQuota(BigDecimal.ZERO);
            this.returnsQuotaAccountService.addReturnsQuotaAccount(returnsQuotaAccountReqDto);
            BalanceAddReqDto balanceAddReqDto = new BalanceAddReqDto();
            balanceAddReqDto.setUserId(dto.getCustomerId());
            balanceAddReqDto.setUserName(dto.getCustomerName());
            balanceAddReqDto.setUserType("CUSTOMER");
            balanceAddReqDto.setBalance(BigDecimal.ZERO);
            balanceAddReqDto.setInstanceId(dto.getInstanceId());
            balanceAddReqDto.setTenantId(dto.getTenantId());
            balanceAddReqDto.setBelongTo("-1");
            balanceAddReqDto.setOrganizationId(dto.getMerchantId());
            if (dto.getMerchantId() != null) {
                RestResponse response = this.organizationQueryApi.queryOrgAndOrgInfo(dto.getMerchantId());
                OrgAndOrgInfoRespDto orgAndOrgInfoRespDto = (OrgAndOrgInfoRespDto)RestResponseHelper.extractData((RestResponse)response);
                balanceAddReqDto.setOrganizationName(orgAndOrgInfoRespDto.getOrganizationDto().getName());
            }
            logger.info("createRebateAccount params:{}", (Object)JSON.toJSONString((Object)balanceAddReqDto));
            this.balanceService.addBalance(balanceAddReqDto);
        }
        catch (Exception e) {
            logger.error("createRebateAccount error: userId:{}, {}", (Object)dto.getCustomerId(), (Object)e.getMessage());
        }
    }
}

