/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.rebate.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.google.common.collect.Sets;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.CustomerDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.rebate.api.dto.request.AddReturnsAdvanceQuotaReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.ReturnQuotaAccountReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.ReturnQuotaImportReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.ReturnsQuotaAccountReqDto;
import com.yx.tcbj.center.rebate.api.dto.response.ReturnQuotaAccountRespDto;
import com.yx.tcbj.center.rebate.api.dto.response.ReturnQuotaImportRespDto;
import com.yx.tcbj.center.rebate.api.dto.response.ReturnsQuotaAccountRespDto;
import com.yx.tcbj.center.rebate.api.dto.response.ReturnsQuotaConfigGeneralRespDto;
import com.yx.tcbj.center.rebate.api.enums.ReturnsQuotaBusinessTypeEnum;
import com.yx.tcbj.center.rebate.biz.enums.ReturnsQuotaChangeTypeEnum;
import com.yx.tcbj.center.rebate.biz.enums.ReturnsQuotaTypeEnum;
import com.yx.tcbj.center.rebate.biz.service.IReturnsQuotaAccountService;
import com.yx.tcbj.center.rebate.biz.service.IReturnsQuotaConfigGeneralService;
import com.yx.tcbj.center.rebate.biz.service.IReturnsQuotaService;
import com.yx.tcbj.center.rebate.biz.utils.BeanPropertyNullUtil;
import com.yx.tcbj.center.rebate.biz.utils.EasyPoiExportUtil;
import com.yx.tcbj.center.rebate.dao.das.ReturnsQuotaAccountDas;
import com.yx.tcbj.center.rebate.dao.das.ReturnsQuotaConfigGeneralDas;
import com.yx.tcbj.center.rebate.dao.das.ReturnsQuotaConfigSpecialDas;
import com.yx.tcbj.center.rebate.dao.das.ReturnsQuotaDas;
import com.yx.tcbj.center.rebate.dao.das.ReturnsQuotaDetailDas;
import com.yx.tcbj.center.rebate.dao.eo.ReturnsQuotaAccountEo;
import com.yx.tcbj.center.rebate.dao.eo.ReturnsQuotaConfigGeneralEo;
import com.yx.tcbj.center.rebate.dao.eo.ReturnsQuotaConfigSpecialEo;
import com.yx.tcbj.center.rebate.dao.eo.ReturnsQuotaDetailEo;
import com.yx.tcbj.center.rebate.dao.eo.ReturnsQuotaEo;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReturnsQuotaAccountServiceImpl
implements IReturnsQuotaAccountService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ReturnsQuotaAccountDas returnsQuotaAccountDas;
    @Resource
    private ReturnsQuotaDas returnsQuotaDas;
    @Resource
    private ReturnsQuotaConfigGeneralDas returnsQuotaConfigGeneralDas;
    @Resource
    private ReturnsQuotaConfigSpecialDas returnsQuotaConfigSpecialDas;
    @Resource
    private IReturnsQuotaAccountService returnsQuotaAccountService;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IReturnsQuotaConfigGeneralService returnsQuotaConfigGeneralService;
    @Resource
    private IReturnsQuotaService returnsQuotaService;
    @Resource
    private ReturnsQuotaDetailDas returnsQuotaDetailDas;
    private static final String START = "startDate";
    private static final String END = "endDate";
    private static final Integer PAGE_SIZE = 1000;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addReturnsQuotaAccount(ReturnsQuotaAccountReqDto addReqDto) {
        this.logger.info("\u521b\u5efa\u9000\u8d27\u989d\u5ea6\u8d26\u6237\uff1a{}", (Object)JSONObject.toJSONString((Object)addReqDto));
        ReturnsQuotaAccountEo returnsQuotaAccountEo = new ReturnsQuotaAccountEo();
        returnsQuotaAccountEo.setCustomerId(addReqDto.getCustomerId());
        List accountEos = this.returnsQuotaAccountDas.select((BaseEo)returnsQuotaAccountEo);
        if (CollectionUtil.isNotEmpty((Collection)accountEos)) {
            this.logger.info("\u8be5\u5ba2\u6237\u5df2\u7ecf\u521b\u5efa\u5bf9\u5e94\u7684\u9000\u8d27\u989d\u5ea6\u8d26\u6237");
            return ((ReturnsQuotaAccountEo)accountEos.get(0)).getId();
        }
        List configGeneralEos = this.returnsQuotaConfigGeneralDas.selectAll();
        if (CollectionUtil.isEmpty((Collection)configGeneralEos)) {
            throw new BizException("\u672a\u8bbe\u7f6e\u901a\u7528\u914d\u7f6e\uff0c\u65e0\u6cd5\u5f00\u901a\u9000\u8d27\u989d\u5ea6\u8d26\u6237");
        }
        ReturnsQuotaConfigGeneralEo configGeneralEo = (ReturnsQuotaConfigGeneralEo)configGeneralEos.get(0);
        Map<String, Date> dateMap = this.getYearTimeRange(configGeneralEo.getYearDate());
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)returnsQuotaAccountEo);
        returnsQuotaAccountEo.setTenantId(addReqDto.getTenantId());
        returnsQuotaAccountEo.setInstanceId(addReqDto.getInstanceId());
        this.returnsQuotaAccountDas.insert((BaseEo)returnsQuotaAccountEo);
        BigDecimal defaultValue = new BigDecimal("0.00");
        ReturnsQuotaEo returnsQuotaEo = new ReturnsQuotaEo();
        returnsQuotaEo.setReturnsQuotaAccountId(returnsQuotaAccountEo.getId());
        returnsQuotaEo.setCustomerId(returnsQuotaAccountEo.getCustomerId());
        returnsQuotaEo.setYearInitialQuota(returnsQuotaAccountEo.getGeneralReturnsQuota().add(returnsQuotaAccountEo.getAdvanceQuota()));
        returnsQuotaEo.setYearInitialAdvanceQuota(returnsQuotaAccountEo.getAdvanceQuota());
        returnsQuotaEo.setYearInitialUsableAdvanceQuota(returnsQuotaAccountEo.getAdvanceUnbackQuota());
        returnsQuotaEo.setStartDate(dateMap.get(START));
        returnsQuotaEo.setEndDate(dateMap.get(END));
        returnsQuotaEo.setOrderAmount(defaultValue);
        returnsQuotaEo.setCumsumGeneralQuota(defaultValue);
        returnsQuotaEo.setCumsumUsableQuota(returnsQuotaEo.getYearInitialQuota());
        returnsQuotaEo.setCumsumUsedQuota(defaultValue);
        returnsQuotaEo.setCumsumAdvanceQuota(defaultValue);
        returnsQuotaEo.setStatus(Integer.valueOf(1));
        this.returnsQuotaDas.insert((BaseEo)returnsQuotaEo);
        return returnsQuotaAccountEo.getId();
    }

    @Override
    public ReturnsQuotaAccountRespDto queryByCustomerId(Long customerId) {
        ReturnsQuotaAccountEo eo = new ReturnsQuotaAccountEo();
        eo.setCustomerId(customerId);
        ReturnsQuotaAccountEo accountEo = (ReturnsQuotaAccountEo)this.returnsQuotaAccountDas.selectOne((BaseEo)eo);
        ReturnsQuotaAccountRespDto respDto = new ReturnsQuotaAccountRespDto();
        DtoHelper.eo2Dto((BaseEo)accountEo, (BaseVo)respDto);
        return respDto;
    }

    @Override
    public List<ReturnsQuotaAccountEo> queryByCustomerIds(List<Long> customerIds) {
        if (CollectionUtil.isEmpty(customerIds)) {
            return null;
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"customer_id", customerIds));
        ReturnsQuotaAccountEo params = new ReturnsQuotaAccountEo();
        params.setSqlFilters(sqlFilters);
        return this.returnsQuotaAccountDas.select((BaseEo)params);
    }

    @Override
    public BigDecimal queryCustomerScale(Long customerId) {
        BigDecimal scale;
        this.logger.info("\u67e5\u8be2\u5ba2\u6237\u5f53\u524d\u9000\u8d27\u6bd4\u4f8b\uff1a{}", (Object)JSON.toJSONString((Object)customerId));
        ReturnsQuotaConfigSpecialEo specialEo = new ReturnsQuotaConfigSpecialEo();
        specialEo.setCustomerId(customerId);
        ReturnsQuotaConfigSpecialEo returnsQuotaConfigSpecialEo = (ReturnsQuotaConfigSpecialEo)this.returnsQuotaConfigSpecialDas.selectOne((BaseEo)specialEo);
        if (ObjectUtil.isNotEmpty((Object)returnsQuotaConfigSpecialEo) && returnsQuotaConfigSpecialEo.getScale() != null) {
            scale = returnsQuotaConfigSpecialEo.getScale();
        } else {
            CustomerExtDetailRespDto customer = (CustomerExtDetailRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerDetails(customerId));
            if (ObjectUtil.isEmpty((Object)customer) || ObjectUtil.isEmpty((Object)customer.getMerchantId())) {
                throw new BizException("-1", "\u65e0\u6cd5\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f");
            }
            ReturnsQuotaConfigGeneralRespDto returnsQuotaConfig = this.returnsQuotaConfigGeneralService.query(customer.getMerchantId().toString());
            if (ObjectUtil.isEmpty((Object)returnsQuotaConfig)) {
                throw new BizException("\u83b7\u53d6\u5ba2\u6237\u9000\u8d27\u989d\u5ea6\u6bd4\u4f8b\u5f02\u5e38\uff0c\u672a\u8bbe\u7f6e\u901a\u7528\u6bd4\u4f8b");
            }
            scale = returnsQuotaConfig.getScale();
        }
        return scale;
    }

    @Override
    public String addAllAccount() {
        RestResponse listRestResponse = this.customerQueryApi.queryCustomerList(Integer.valueOf(3));
        if (CollectionUtil.isEmpty((Collection)((Collection)listRestResponse.getData()))) {
            return "\u65e0\u5c0fB\u5ba2\u6237\u6570\u636e";
        }
        int successNum = 0;
        for (CustomerRespDto dto : (List)listRestResponse.getData()) {
            ReturnsQuotaAccountReqDto account = new ReturnsQuotaAccountReqDto();
            account.setAdvanceQuota(BigDecimal.ZERO);
            account.setAdvanceUnbackQuota(BigDecimal.ZERO);
            account.setGeneralReturnsQuota(BigDecimal.ZERO);
            if (!ObjectUtil.isNotEmpty((Object)dto.getId())) continue;
            account.setCustomerId(dto.getId());
            this.addReturnsQuotaAccount(account);
            ++successNum;
        }
        return "\u6267\u884c\u5b8c\u6bd5\uff1a" + successNum;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ReturnQuotaImportRespDto returnQuotaAccountImport(ReturnQuotaImportReqDto returnQuotaImportReqDto) {
        ReturnQuotaImportRespDto returnQuotaImportRespDto = new ReturnQuotaImportRespDto();
        returnQuotaImportRespDto.setOrganizationId(returnQuotaImportReqDto.getOrganizationId());
        try {
            InputStream is = EasyPoiExportUtil.getInputStream(returnQuotaImportReqDto.getFileUrl());
            ImportParams params = new ImportParams();
            params.setTitleRows(0);
            params.setHeadRows(1);
            List importList = ExcelImportUtil.importExcel((InputStream)is, ReturnQuotaAccountReqDto.class, (ImportParams)params);
            importList = BeanPropertyNullUtil.getAllFieldNullList(importList);
            if (CollectionUtil.isEmpty(importList)) {
                throw new BizException("\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            AtomicInteger lineNo = new AtomicInteger(1);
            ArrayList errorList = Lists.newArrayList();
            HashSet singleCustomerCodes = Sets.newHashSet();
            List finalImportList = importList;
            Stream.iterate(0, n -> n + 1).limit(ReturnsQuotaAccountServiceImpl.getCount(importList.size()).intValue()).forEach(page -> {
                List<ReturnQuotaAccountReqDto> list = finalImportList.stream().skip(page * PAGE_SIZE).limit(PAGE_SIZE.intValue()).collect(Collectors.toList());
                this.executeImport(returnQuotaImportReqDto.getOrganizationId(), list, errorList, singleCustomerCodes, lineNo);
            });
            if (CollectionUtil.isNotEmpty((Collection)errorList)) {
                returnQuotaImportRespDto.setFailNum(Integer.valueOf(errorList.size()));
                String title = "\u5ba2\u6237\u9000\u8d27\u989d\u5ea6\u5bfc\u5165\u9519\u8bef\u4fe1\u606f";
                String fileName = title + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, ReturnQuotaAccountRespDto.class, null, fileName, "xls");
                returnQuotaImportRespDto.setErrorFile(exportUrl);
            }
            returnQuotaImportRespDto.setNum(Integer.valueOf(importList.size()));
            returnQuotaImportRespDto.setSuccessNum(Integer.valueOf(returnQuotaImportRespDto.getNum() - returnQuotaImportRespDto.getFailNum()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff0c" + e.getMessage());
        }
        return returnQuotaImportRespDto;
    }

    private void executeImport(Long organizationId, List<ReturnQuotaAccountReqDto> list, List<ReturnQuotaAccountRespDto> errorList, Set<String> singleCustomerCodes, AtomicInteger lineNo) {
        List customerCodes = list.stream().map(ReturnQuotaAccountReqDto::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map<Object, Object> customerRespDtoMap = Maps.newHashMap();
        Map<Object, Object> accountEoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(customerCodes)) {
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByCodes(customerCodes));
            customerRespDtoMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (e1, e2) -> e1));
            if (CollectionUtil.isNotEmpty((Collection)customerRespDtos)) {
                List customerIds = customerRespDtos.stream().map(BaseRespDto::getId).collect(Collectors.toList());
                List returnsQuotaAccountEos = ((ExtQueryChainWrapper)this.returnsQuotaAccountDas.filter().in((Object)"customer_id", customerIds)).list();
                accountEoMap = returnsQuotaAccountEos.stream().collect(Collectors.toMap(ReturnsQuotaAccountEo::getCustomerId, Function.identity(), (e1, e2) -> e1));
            }
        }
        for (ReturnQuotaAccountReqDto returnQuotaAccountReqDto : list) {
            StringBuilder sb = new StringBuilder(80);
            if (!singleCustomerCodes.add(returnQuotaAccountReqDto.getCustomerCode())) {
                sb.append("\u5bfc\u5165\u5ba2\u6237\u7f16\u53f7\u91cd\u590d\uff1b");
            }
            if (StringUtil.isEmpty((String)returnQuotaAccountReqDto.getCustomerCode())) {
                sb.append("\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a\uff1b");
            }
            if (!NumberUtil.isNumber((CharSequence)returnQuotaAccountReqDto.getQuota())) {
                sb.append("\u671f\u521d\u989d\u5ea6\u5fc5\u987b\u8f93\u5165\u6570\u5b57\uff1b");
            } else {
                BigDecimal quota = new BigDecimal(returnQuotaAccountReqDto.getQuota());
                if (quota.compareTo(BigDecimal.ZERO) <= 0) {
                    sb.append("\u671f\u521d\u989d\u5ea6\u5fc5\u987b\u5927\u4e8e0\uff1b");
                }
                if (quota.stripTrailingZeros().scale() > 2) {
                    sb.append("\u671f\u521d\u989d\u5ea6\u4e0d\u80fd\u5927\u4e8e\u4e24\u4f4d\u5c0f\u6570\uff1b");
                }
            }
            CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoMap.get(returnQuotaAccountReqDto.getCustomerCode());
            if (customerRespDto == null || !Objects.equals(customerRespDto.getMerchantId(), organizationId)) {
                sb.append("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff1b");
            }
            if (StringUtil.isBlank((String)sb.toString())) {
                BigDecimal quota = new BigDecimal(returnQuotaAccountReqDto.getQuota());
                ReturnsQuotaAccountEo accountEo = (ReturnsQuotaAccountEo)accountEoMap.get(customerRespDto.getId());
                if (accountEo != null) {
                    AddReturnsAdvanceQuotaReqDto addReturnsAdvanceQuotaReqDto = new AddReturnsAdvanceQuotaReqDto();
                    addReturnsAdvanceQuotaReqDto.setAdvanceQuota(quota);
                    CustomerDto customerDto = new CustomerDto();
                    customerDto.setCustomerId(customerRespDto.getId());
                    customerDto.setCustomerName(customerRespDto.getName());
                    addReturnsAdvanceQuotaReqDto.setCustomerList((List)Lists.newArrayList((Object[])new CustomerDto[]{customerDto}));
                    addReturnsAdvanceQuotaReqDto.setBusinessType(ReturnsQuotaBusinessTypeEnum.IMPORT_ADD_ADVANCE.getValue());
                    this.returnsQuotaService.batchAddAdvanceQuota(addReturnsAdvanceQuotaReqDto);
                    continue;
                }
                ReturnsQuotaAccountReqDto accountReqDto = new ReturnsQuotaAccountReqDto();
                accountReqDto.setCustomerId(customerRespDto.getId());
                accountReqDto.setGeneralReturnsQuota(BigDecimal.ZERO);
                accountReqDto.setAdvanceQuota(quota);
                accountReqDto.setAdvanceUnbackQuota(quota);
                this.addReturnsQuotaAccount(accountReqDto);
                ReturnsQuotaEo returnsQuotaEo = new ReturnsQuotaEo();
                returnsQuotaEo.setCustomerId(customerRespDto.getId());
                returnsQuotaEo.setStatus(Integer.valueOf(1));
                returnsQuotaEo = (ReturnsQuotaEo)this.returnsQuotaDas.selectOne((BaseEo)returnsQuotaEo);
                AssertUtil.notNull((Object)returnsQuotaEo, (String)"\u672c\u5e74\u5ea6\u9000\u8d27\u989d\u5ea6\u8bb0\u5f55\u4e3a\u7a7a");
                ReturnsQuotaDetailEo returnsQuotaDetailEo = new ReturnsQuotaDetailEo();
                returnsQuotaDetailEo.setReturnsQuotaId(returnsQuotaEo.getId());
                returnsQuotaDetailEo.setQuotaType(ReturnsQuotaTypeEnum.RETURN_QUOTA.getValue());
                returnsQuotaDetailEo.setQuotaAdjustBefore(BigDecimal.ZERO);
                returnsQuotaDetailEo.setQuotaAdjust(accountReqDto.getAdvanceQuota());
                returnsQuotaDetailEo.setQuotaAdjustAfter(accountReqDto.getAdvanceQuota());
                returnsQuotaDetailEo.setChangeType(ReturnsQuotaChangeTypeEnum.ADD.getValue());
                returnsQuotaDetailEo.setBusinessType(ReturnsQuotaBusinessTypeEnum.IMPORT_ADD_ADVANCE.getValue());
                returnsQuotaDetailEo.setChangeTime(new Date());
                this.returnsQuotaDetailDas.insert((BaseEo)returnsQuotaDetailEo);
                continue;
            }
            ReturnQuotaAccountRespDto returnQuotaAccountRespDto = new ReturnQuotaAccountRespDto();
            BeanUtil.copyProperties((Object)returnQuotaAccountReqDto, (Object)returnQuotaAccountRespDto, (String[])new String[0]);
            returnQuotaAccountRespDto.setErrorMsg(sb.toString());
            returnQuotaAccountRespDto.setLineNo(Integer.valueOf(lineNo.incrementAndGet()));
            errorList.add(returnQuotaAccountRespDto);
        }
    }

    private static Integer getCount(Integer size) {
        return (PAGE_SIZE + size - 1) / PAGE_SIZE;
    }

    private Map<String, Date> getYearTimeRange(String configDateStr) {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        configDateStr = year + "-" + configDateStr;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowDateStr = format.format(new Date());
        HashMap<String, Date> map = new HashMap<String, Date>();
        try {
            String endDateStr;
            String startDateStr;
            Date configDate = format.parse(configDateStr);
            Date nowDate = format.parse(nowDateStr);
            GregorianCalendar calendar = new GregorianCalendar();
            Date startDate = format.parse(configDateStr);
            Date endDate = format.parse(configDateStr);
            if (configDate.before(nowDate)) {
                calendar.setTime(startDate);
                ((Calendar)calendar).add(5, 1);
                startDateStr = format.format(calendar.getTime());
                calendar.setTime(endDate);
                ((Calendar)calendar).add(1, 1);
                endDateStr = format.format(calendar.getTime());
            } else {
                calendar.setTime(startDate);
                ((Calendar)calendar).add(5, 1);
                ((Calendar)calendar).add(1, -1);
                startDateStr = format.format(calendar.getTime());
                calendar.setTime(endDate);
                endDateStr = format.format(calendar.getTime());
            }
            map.put(START, format2.parse(startDateStr + " 00:00:00"));
            map.put(END, format2.parse(endDateStr + " 23:59:59"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
        }
        return map;
    }
}

