package com.yx.tcbj.center.shop.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBListRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author shizy
 * @date 2023/11/8
 */
@Api(
        tags = {"店铺中心(F2B2b): 店铺管理"}
)
@FeignClient(
        contextId = "com.dtyunxi.yundt-b2b-center-shop-api-IShopExtQueryApi",
        name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
        url = "${yundt.cube.center.shop.api:}",
        path = "/v3/F2B2b/shop"
)
public interface IShopExtQueryV3Api {

    @GetMapping({"/current"})
    @ApiOperation(
            value = "大B卖家端-店铺列表",
            notes = "大B卖家端 - 店铺列表"
    )
    RestResponse<PageInfo<ShopToBListRespDto>> queryMyShopPage(@ModelAttribute ShopToBQueryReqDto reqDto);

    @PostMapping({"/deleteCache"})
    @ApiOperation(
            value = "大B卖家端-删除店铺缓存",
            notes = "大B卖家端 - 删除店铺缓存"
    )
    RestResponse<Void> deleteCache(@RequestBody ShopToBQueryReqDto reqDto);

}
