package com.yx.demo.center.xx.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.StatusReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerToBListRespDto;
import com.yx.demo.center.xx.api.dto.request.SellerBizStatusReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

@Api(tags = {"店铺中心: 商家管理（定制）"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-shop-api-ISellerExtendsQueryApi",
        name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
        url = "${yundt.cube.center.shop.api:}",
        path = "/v1/sellerExtends"
)
public interface ISellerExtendsApi {

    @PutMapping(
            value = {"/status"},
            produces = {"application/json"}
    )
    @ApiOperation(
            value = "状态（启用 NORMAL、停用 BANNED）",
            notes = "状态（启用 NORMAL、停用 BANNED）"
    )
    RestResponse<Void> changeStatus(@RequestBody @Valid SellerBizStatusReqDto reqDto);
}
